/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.ChannelLogger;
import alluxio.shaded.client.io.grpc.ConnectivityState;
import alluxio.shaded.client.io.grpc.ConnectivityStateInfo;
import alluxio.shaded.client.io.grpc.EquivalentAddressGroup;
import alluxio.shaded.client.io.grpc.LoadBalancer;
import alluxio.shaded.client.io.grpc.LoadBalancerProvider;
import alluxio.shaded.client.io.grpc.LoadBalancerRegistry;
import alluxio.shaded.client.io.grpc.NameResolver;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.internal.GrpcAttributes;
import alluxio.shaded.client.io.grpc.internal.ServiceConfigUtil;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class AutoConfiguredLoadBalancerFactory2 {
    private static final Logger logger = Logger.getLogger(AutoConfiguredLoadBalancerFactory2.class.getName());
    private static final String GRPCLB_POLICY_NAME = "grpclb";
    private final LoadBalancerRegistry registry;
    private final String defaultPolicy;

    public AutoConfiguredLoadBalancerFactory2(String defaultPolicy) {
        this(LoadBalancerRegistry.getDefaultRegistry(), defaultPolicy);
    }

    @VisibleForTesting
    AutoConfiguredLoadBalancerFactory2(LoadBalancerRegistry registry, String defaultPolicy) {
        this.registry = Preconditions.checkNotNull(registry, "registry");
        this.defaultPolicy = Preconditions.checkNotNull(defaultPolicy, "defaultPolicy");
    }

    public AutoConfiguredLoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    private LoadBalancerProvider getProviderOrThrow(String policy, String choiceReason) throws PolicyException {
        LoadBalancerProvider provider = this.registry.getProvider(policy);
        if (provider == null) {
            throw new PolicyException("Trying to load '" + policy + "' because " + choiceReason + ", but it's unavailable");
        }
        return provider;
    }

    @Nullable
    NameResolver.ConfigOrError parseLoadBalancerPolicy(Map<String, ?> serviceConfig, ChannelLogger channelLogger) {
        try {
            List<ServiceConfigUtil.LbConfig> loadBalancerConfigs = null;
            if (serviceConfig != null) {
                List<Map<String, ?>> rawLbConfigs = ServiceConfigUtil.getLoadBalancingConfigsFromServiceConfig(serviceConfig);
                loadBalancerConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList(rawLbConfigs);
            }
            if (loadBalancerConfigs != null && !loadBalancerConfigs.isEmpty()) {
                ArrayList<String> policiesTried = new ArrayList<String>();
                for (ServiceConfigUtil.LbConfig lbConfig : loadBalancerConfigs) {
                    NameResolver.ConfigOrError parsedLbPolicyConfig;
                    String policy = lbConfig.getPolicyName();
                    LoadBalancerProvider provider = this.registry.getProvider(policy);
                    if (provider == null) {
                        policiesTried.add(policy);
                        continue;
                    }
                    if (!policiesTried.isEmpty()) {
                        channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "{0} specified by Service Config are not available", policiesTried);
                    }
                    if ((parsedLbPolicyConfig = provider.parseLoadBalancingPolicyConfig(lbConfig.getRawConfigValue())).getError() != null) {
                        return parsedLbPolicyConfig;
                    }
                    return NameResolver.ConfigOrError.fromConfig(new PolicySelection(provider, serviceConfig, parsedLbPolicyConfig));
                }
                return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("None of " + policiesTried + " specified by Service Config are available."));
            }
            return null;
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("can't parse load balancer configuration").withCause(e));
        }
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status failure) {
            this.failure = failure;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    @VisibleForTesting
    static final class ResolvedPolicySelection {
        final PolicySelection policySelection;
        final List<EquivalentAddressGroup> serverList;

        ResolvedPolicySelection(PolicySelection policySelection, List<EquivalentAddressGroup> serverList) {
            this.policySelection = Preconditions.checkNotNull(policySelection, "policySelection");
            this.serverList = Collections.unmodifiableList(Preconditions.checkNotNull(serverList, "serverList"));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("policySelection", this.policySelection).add("serverList", this.serverList).toString();
        }
    }

    @VisibleForTesting
    static final class PolicySelection {
        final LoadBalancerProvider provider;
        @Nullable
        final Map<String, ?> rawConfig;
        @Nullable
        final NameResolver.ConfigOrError config;

        PolicySelection(LoadBalancerProvider provider, @Nullable Map<String, ?> rawConfig, @Nullable NameResolver.ConfigOrError config) {
            this.provider = Preconditions.checkNotNull(provider, "provider");
            this.rawConfig = rawConfig;
            this.config = config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PolicySelection that = (PolicySelection)o;
            return Objects.equal(this.provider, that.provider) && Objects.equal(this.rawConfig, that.rawConfig) && Objects.equal(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hashCode(this.provider, this.rawConfig, this.config);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("provider", this.provider).add("rawConfig", this.rawConfig).add("config", this.config).toString();
        }
    }

    @VisibleForTesting
    static final class PolicyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PolicyException(String msg) {
            super(msg);
        }
    }

    @VisibleForTesting
    public final class AutoConfiguredLoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancerProvider delegateProvider;
        private boolean roundRobinDueToGrpclbDepMissing;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateProvider = AutoConfiguredLoadBalancerFactory2.this.registry.getProvider(AutoConfiguredLoadBalancerFactory2.this.defaultPolicy);
            if (this.delegateProvider == null) {
                throw new IllegalStateException("Could not find policy '" + AutoConfiguredLoadBalancerFactory2.this.defaultPolicy + "'. Make sure its implementation is either registered to LoadBalancerRegistry or included in META-INF/services/io.grpc.LoadBalancerProvider from your jar files.");
            }
            this.delegate = this.delegateProvider.newLoadBalancer(helper);
        }

        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.tryHandleResolvedAddresses(resolvedAddresses);
        }

        Status tryHandleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            NameResolver.ConfigOrError lbConfig;
            ResolvedPolicySelection resolvedSelection;
            List<EquivalentAddressGroup> servers = resolvedAddresses.getAddresses();
            Attributes attributes = resolvedAddresses.getAttributes();
            if (attributes.get(LoadBalancer.ATTR_LOAD_BALANCING_CONFIG) != null) {
                throw new IllegalArgumentException("Unexpected ATTR_LOAD_BALANCING_CONFIG from upstream: " + attributes.get(LoadBalancer.ATTR_LOAD_BALANCING_CONFIG));
            }
            PolicySelection policySelection = (PolicySelection)resolvedAddresses.getLoadBalancingPolicyConfig();
            try {
                resolvedSelection = this.resolveLoadBalancerProvider(servers, policySelection);
            }
            catch (PolicyException e) {
                Status s2 = Status.INTERNAL.withDescription(e.getMessage());
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker(s2));
                this.delegate.shutdown();
                this.delegateProvider = null;
                this.delegate = new NoopLoadBalancer();
                return Status.OK;
            }
            PolicySelection selection = resolvedSelection.policySelection;
            if (this.delegateProvider == null || !selection.provider.getPolicyName().equals(this.delegateProvider.getPolicyName())) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateProvider = selection.provider;
                LoadBalancer old = this.delegate;
                this.delegate = this.delegateProvider.newLoadBalancer(this.helper);
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Load balancer changed from {0} to {1}", old.getClass().getSimpleName(), this.delegate.getClass().getSimpleName());
            }
            if ((lbConfig = selection.config) != null) {
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.DEBUG, "Load-balancing config: {0}", selection.config);
                attributes = attributes.toBuilder().set(LoadBalancer.ATTR_LOAD_BALANCING_CONFIG, selection.rawConfig).build();
            }
            LoadBalancer delegate = this.getDelegate();
            if (resolvedSelection.serverList.isEmpty() && !delegate.canHandleEmptyAddressListFromNameResolution()) {
                return Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + servers + ", attrs=" + attributes);
            }
            delegate.handleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(resolvedSelection.serverList).setAttributes(attributes).setLoadBalancingPolicyConfig(lbConfig).build());
            return Status.OK;
        }

        void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Deprecated
        void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        void requestConnection() {
            this.getDelegate().requestConnection();
        }

        void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        @VisibleForTesting
        public LoadBalancer getDelegate() {
            return this.delegate;
        }

        @VisibleForTesting
        void setDelegate(LoadBalancer lb) {
            this.delegate = lb;
        }

        @VisibleForTesting
        LoadBalancerProvider getDelegateProvider() {
            return this.delegateProvider;
        }

        @VisibleForTesting
        ResolvedPolicySelection resolveLoadBalancerProvider(List<EquivalentAddressGroup> servers, @Nullable PolicySelection policySelection) throws PolicyException {
            boolean haveBalancerAddress = false;
            ArrayList<EquivalentAddressGroup> backendAddrs = new ArrayList<EquivalentAddressGroup>();
            for (EquivalentAddressGroup s2 : servers) {
                if (s2.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) != null) {
                    haveBalancerAddress = true;
                    continue;
                }
                backendAddrs.add(s2);
            }
            if (policySelection != null) {
                String policyName = policySelection.provider.getPolicyName();
                return new ResolvedPolicySelection(policySelection, policyName.equals(AutoConfiguredLoadBalancerFactory2.GRPCLB_POLICY_NAME) ? servers : backendAddrs);
            }
            if (haveBalancerAddress) {
                LoadBalancerProvider grpclbProvider = AutoConfiguredLoadBalancerFactory2.this.registry.getProvider(AutoConfiguredLoadBalancerFactory2.GRPCLB_POLICY_NAME);
                if (grpclbProvider == null) {
                    if (backendAddrs.isEmpty()) {
                        throw new PolicyException("Received ONLY balancer addresses but grpclb runtime is missing");
                    }
                    if (!this.roundRobinDueToGrpclbDepMissing) {
                        this.roundRobinDueToGrpclbDepMissing = true;
                        String errorMsg = "Found balancer addresses but grpclb runtime is missing. Will use round_robin. Please include grpc-grpclb in your runtime dependencies.";
                        this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.ERROR, errorMsg);
                        logger.warning(errorMsg);
                    }
                    return new ResolvedPolicySelection(new PolicySelection(AutoConfiguredLoadBalancerFactory2.this.getProviderOrThrow("round_robin", "received balancer addresses but grpclb runtime is missing"), null, null), backendAddrs);
                }
                return new ResolvedPolicySelection(new PolicySelection(grpclbProvider, null, null), servers);
            }
            this.roundRobinDueToGrpclbDepMissing = false;
            return new ResolvedPolicySelection(new PolicySelection(AutoConfiguredLoadBalancerFactory2.this.getProviderOrThrow(AutoConfiguredLoadBalancerFactory2.this.defaultPolicy, "using default policy"), null, null), servers);
        }
    }

    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        @Deprecated
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> s2, Attributes a) {
        }

        @Override
        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        }

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void shutdown() {
        }
    }
}

