// Generated by the protocol buffer alluxio.shaded.client.com.iler.  DO NOT EDIT!
// source: google/api/monitoring.proto

package alluxio.shaded.client.com.google.api;

/**
 * <pre>
 * Monitoring configuration of the service.
 * The example below shows how to configure monitored resources and metrics
 * for monitoring. In the example, a monitored resource and two metrics are
 * defined. The `library.googleapis.alluxio.shaded.client.com.book/returned_count` metric is sent
 * to both producer and consumer projects, whereas the
 * `library.googleapis.alluxio.shaded.client.com.book/overdue_count` metric is only sent to the
 * consumer project.
 *     monitored_resources:
 *     - type: library.googleapis.alluxio.shaded.client.com.branch
 *       labels:
 *       - key: /city
 *         description: The city where the library branch is located in.
 *       - key: /name
 *         description: The name of the branch.
 *     metrics:
 *     - name: library.googleapis.alluxio.shaded.client.com.book/returned_count
 *       metric_kind: DELTA
 *       value_type: INT64
 *       labels:
 *       - key: /customer_id
 *     - name: library.googleapis.alluxio.shaded.client.com.book/overdue_count
 *       metric_kind: GAUGE
 *       value_type: INT64
 *       labels:
 *       - key: /customer_id
 *     monitoring:
 *       producer_destinations:
 *       - monitored_resource: library.googleapis.alluxio.shaded.client.com.branch
 *         metrics:
 *         - library.googleapis.alluxio.shaded.client.com.book/returned_count
 *       consumer_destinations:
 *       - monitored_resource: library.googleapis.alluxio.shaded.client.com.branch
 *         metrics:
 *         - library.googleapis.alluxio.shaded.client.com.book/returned_count
 *         - library.googleapis.alluxio.shaded.client.com.book/overdue_count
 * </pre>
 *
 * Protobuf type {@code google.api.Monitoring}
 */
public  final class Monitoring extends
    alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.Monitoring)
    MonitoringOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Monitoring.newBuilder() to construct.
  private Monitoring(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Monitoring() {
    producerDestinations_ = java.util.Collections.emptyList();
    consumerDestinations_ = java.util.Collections.emptyList();
  }

  @Override
  public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Monitoring(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new NullPointerException();
    }
    int mutable_bitField0_ = 0;
    alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              producerDestinations_ = new java.util.ArrayList<MonitoringDestination>();
              mutable_bitField0_ |= 0x00000001;
            }
            producerDestinations_.add(
                input.readMessage(MonitoringDestination.parser(), extensionRegistry));
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              consumerDestinations_ = new java.util.ArrayList<MonitoringDestination>();
              mutable_bitField0_ |= 0x00000002;
            }
            consumerDestinations_.add(
                input.readMessage(MonitoringDestination.parser(), extensionRegistry));
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.alluxio.shaded.client.io.IOException e) {
      throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        producerDestinations_ = java.util.Collections.unmodifiableList(producerDestinations_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
  }

  @Override
  protected FieldAccessorTable
      internalGetFieldAccessorTable() {
    return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            Monitoring.class, Builder.class);
  }

  public interface MonitoringDestinationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Monitoring.MonitoringDestination)
      alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     */
    String getMonitoredResource();
    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     */
    alluxio.shaded.client.com.google.protobuf.ByteString
        getMonitoredResourceBytes();

    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    java.util.List<String>
        getMetricsList();
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    int getMetricsCount();
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    String getMetrics(int index);
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    alluxio.shaded.client.com.google.protobuf.ByteString
        getMetricsBytes(int index);
  }
  /**
   * <pre>
   * Configuration of a specific monitoring destination (the producer project
   * or the consumer project).
   * </pre>
   *
   * Protobuf type {@code google.api.Monitoring.MonitoringDestination}
   */
  public  static final class MonitoringDestination extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Monitoring.MonitoringDestination)
      MonitoringDestinationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use MonitoringDestination.newBuilder() to construct.
    private MonitoringDestination(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private MonitoringDestination() {
      monitoredResource_ = "";
      metrics_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @Override
    public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private MonitoringDestination(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new NullPointerException();
      }
      int mutable_bitField0_ = 0;
      alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              String s = input.readStringRequireUtf8();

              monitoredResource_ = s;
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                metrics_ = new alluxio.shaded.client.com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              metrics_.add(s);
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.alluxio.shaded.client.io.IOException e) {
        throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          metrics_ = metrics_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              MonitoringDestination.class, Builder.class);
    }

    private int bitField0_;
    public static final int MONITORED_RESOURCE_FIELD_NUMBER = 1;
    private volatile Object monitoredResource_;
    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     */
    public String getMonitoredResource() {
      Object ref = monitoredResource_;
      if (ref instanceof String) {
        return (String) ref;
      } else {
        alluxio.shaded.client.com.google.protobuf.ByteString bs = 
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        String s = bs.toStringUtf8();
        monitoredResource_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getMonitoredResourceBytes() {
      Object ref = monitoredResource_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (String) ref);
        monitoredResource_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METRICS_FIELD_NUMBER = 2;
    private alluxio.shaded.client.com.google.protobuf.LazyStringList metrics_;
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ProtocolStringList
        getMetricsList() {
      return metrics_;
    }
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public int getMetricsCount() {
      return metrics_.size();
    }
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public String getMetrics(int index) {
      return metrics_.get(index);
    }
    /**
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getMetricsBytes(int index) {
      return metrics_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @Override
    public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                        throws java.alluxio.shaded.client.io.IOException {
      if (!getMonitoredResourceBytes().isEmpty()) {
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, monitoredResource_);
      }
      for (int i = 0; i < metrics_.size(); i++) {
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metrics_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getMonitoredResourceBytes().isEmpty()) {
        size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(1, monitoredResource_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < metrics_.size(); i++) {
          dataSize += alluxio.shaded.client.com.uteStringSizeNoTag(metrics_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMetricsList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @Override
    public boolean equals(final Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof MonitoringDestination)) {
        return super.equals(obj);
      }
      MonitoringDestination other = (MonitoringDestination) obj;

      if (!getMonitoredResource()
          .equals(other.getMonitoredResource())) return false;
      if (!getMetricsList()
          .equals(other.getMetricsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResource().hashCode();
      if (getMetricsCount() > 0) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetricsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static MonitoringDestination parseFrom(
        java.nio.ByteBuffer data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static MonitoringDestination parseFrom(
        java.nio.ByteBuffer data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static MonitoringDestination parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static MonitoringDestination parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static MonitoringDestination parseFrom(byte[] data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static MonitoringDestination parseFrom(
        byte[] data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static MonitoringDestination parseFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static MonitoringDestination parseFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static MonitoringDestination parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static MonitoringDestination parseDelimitedFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static MonitoringDestination parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static MonitoringDestination parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(MonitoringDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(
        BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Configuration of a specific monitoring destination (the producer project
     * or the consumer project).
     * </pre>
     *
     * Protobuf type {@code google.api.Monitoring.MonitoringDestination}
     */
    public static final class Builder extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Monitoring.MonitoringDestination)
        MonitoringDestinationOrBuilder {
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                MonitoringDestination.class, Builder.class);
      }

      // Construct using alluxio.shaded.client.com.google.api.Monitoring.MonitoringDestination.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @Override
      public Builder clear() {
        super.clear();
        monitoredResource_ = "";

        metrics_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
      }

      @Override
      public MonitoringDestination getDefaultInstanceForType() {
        return MonitoringDestination.getDefaultInstance();
      }

      @Override
      public MonitoringDestination build() {
        MonitoringDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @Override
      public MonitoringDestination buildPartial() {
        MonitoringDestination result = new MonitoringDestination(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.monitoredResource_ = monitoredResource_;
        if (((bitField0_ & 0x00000002) != 0)) {
          metrics_ = metrics_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metrics_ = metrics_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @Override
      public Builder clone() {
        return super.clone();
      }
      @Override
      public Builder setField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.setField(field, value);
      }
      @Override
      public Builder clearField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @Override
      public Builder clearOneof(
          alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @Override
      public Builder setRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @Override
      public Builder addRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.addRepeatedField(field, value);
      }
      @Override
      public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
        if (other instanceof MonitoringDestination) {
          return mergeFrom((MonitoringDestination)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(MonitoringDestination other) {
        if (other == MonitoringDestination.getDefaultInstance()) return this;
        if (!other.getMonitoredResource().isEmpty()) {
          monitoredResource_ = other.monitoredResource_;
          onChanged();
        }
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @Override
      public final boolean isInitialized() {
        return true;
      }

      @Override
      public Builder mergeFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        MonitoringDestination parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (MonitoringDestination) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private Object monitoredResource_ = "";
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       */
      public String getMonitoredResource() {
        Object ref = monitoredResource_;
        if (!(ref instanceof String)) {
          alluxio.shaded.client.com.google.protobuf.ByteString bs =
              (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
          String s = bs.toStringUtf8();
          monitoredResource_ = s;
          return s;
        } else {
          return (String) ref;
        }
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.ByteString
          getMonitoredResourceBytes() {
        Object ref = monitoredResource_;
        if (ref instanceof String) {
          alluxio.shaded.client.com.google.protobuf.ByteString b = 
              alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                  (String) ref);
          monitoredResource_ = b;
          return b;
        } else {
          return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       */
      public Builder setMonitoredResource(
          String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        monitoredResource_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       */
      public Builder clearMonitoredResource() {
        
        monitoredResource_ = getDefaultInstance().getMonitoredResource();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       */
      public Builder setMonitoredResourceBytes(
          alluxio.shaded.client.com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        monitoredResource_ = value;
        onChanged();
        return this;
      }

      private alluxio.shaded.client.com.google.protobuf.LazyStringList metrics_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureMetricsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          metrics_ = new alluxio.shaded.client.com.google.protobuf.LazyStringArrayList(metrics_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.ProtocolStringList
          getMetricsList() {
        return metrics_.getUnmodifiableView();
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public int getMetricsCount() {
        return metrics_.size();
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public String getMetrics(int index) {
        return metrics_.get(index);
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.ByteString
          getMetricsBytes(int index) {
        return metrics_.getByteString(index);
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder setMetrics(
          int index, String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder addMetrics(
          String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder addAllMetrics(
          Iterable<String> values) {
        ensureMetricsIsMutable();
        alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, metrics_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder clearMetrics() {
        metrics_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder addMetricsBytes(
          alluxio.shaded.client.com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
        return this;
      }
      @Override
      public final Builder setUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @Override
      public final Builder mergeUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.api.Monitoring.MonitoringDestination)
    }

    // @@protoc_insertion_point(class_scope:google.api.Monitoring.MonitoringDestination)
    private static final MonitoringDestination DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new MonitoringDestination();
    }

    public static MonitoringDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final alluxio.shaded.client.com.google.protobuf.Parser<MonitoringDestination>
        PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<MonitoringDestination>() {
      @Override
      public MonitoringDestination parsePartialFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return new MonitoringDestination(input, extensionRegistry);
      }
    };

    public static alluxio.shaded.client.com.google.protobuf.Parser<MonitoringDestination> parser() {
      return PARSER;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Parser<MonitoringDestination> getParserForType() {
      return PARSER;
    }

    @Override
    public MonitoringDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int PRODUCER_DESTINATIONS_FIELD_NUMBER = 1;
  private java.util.List<MonitoringDestination> producerDestinations_;
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public java.util.List<MonitoringDestination> getProducerDestinationsList() {
    return producerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public java.util.List<? extends MonitoringDestinationOrBuilder>
      getProducerDestinationsOrBuilderList() {
    return producerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public int getProducerDestinationsCount() {
    return producerDestinations_.size();
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public MonitoringDestination getProducerDestinations(int index) {
    return producerDestinations_.get(index);
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public MonitoringDestinationOrBuilder getProducerDestinationsOrBuilder(
      int index) {
    return producerDestinations_.get(index);
  }

  public static final int CONSUMER_DESTINATIONS_FIELD_NUMBER = 2;
  private java.util.List<MonitoringDestination> consumerDestinations_;
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public java.util.List<MonitoringDestination> getConsumerDestinationsList() {
    return consumerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public java.util.List<? extends MonitoringDestinationOrBuilder>
      getConsumerDestinationsOrBuilderList() {
    return consumerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public int getConsumerDestinationsCount() {
    return consumerDestinations_.size();
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public MonitoringDestination getConsumerDestinations(int index) {
    return consumerDestinations_.get(index);
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resouce type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public MonitoringDestinationOrBuilder getConsumerDestinationsOrBuilder(
      int index) {
    return consumerDestinations_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @Override
  public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                      throws java.alluxio.shaded.client.io.IOException {
    for (int i = 0; i < producerDestinations_.size(); i++) {
      output.writeMessage(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      output.writeMessage(2, consumerDestinations_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < producerDestinations_.size(); i++) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(2, consumerDestinations_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof Monitoring)) {
      return super.equals(obj);
    }
    Monitoring other = (Monitoring) obj;

    if (!getProducerDestinationsList()
        .equals(other.getProducerDestinationsList())) return false;
    if (!getConsumerDestinationsList()
        .equals(other.getConsumerDestinationsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getProducerDestinationsCount() > 0) {
      hash = (37 * hash) + PRODUCER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProducerDestinationsList().hashCode();
    }
    if (getConsumerDestinationsCount() > 0) {
      hash = (37 * hash) + CONSUMER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerDestinationsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static Monitoring parseFrom(
      java.nio.ByteBuffer data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Monitoring parseFrom(
      java.nio.ByteBuffer data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Monitoring parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Monitoring parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Monitoring parseFrom(byte[] data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Monitoring parseFrom(
      byte[] data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Monitoring parseFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Monitoring parseFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static Monitoring parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static Monitoring parseDelimitedFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static Monitoring parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Monitoring parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(Monitoring prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @Override
  protected Builder newBuilderForType(
      BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Monitoring configuration of the service.
   * The example below shows how to configure monitored resources and metrics
   * for monitoring. In the example, a monitored resource and two metrics are
   * defined. The `library.googleapis.alluxio.shaded.client.com.book/returned_count` metric is sent
   * to both producer and consumer projects, whereas the
   * `library.googleapis.alluxio.shaded.client.com.book/overdue_count` metric is only sent to the
   * consumer project.
   *     monitored_resources:
   *     - type: library.googleapis.alluxio.shaded.client.com.branch
   *       labels:
   *       - key: /city
   *         description: The city where the library branch is located in.
   *       - key: /name
   *         description: The name of the branch.
   *     metrics:
   *     - name: library.googleapis.alluxio.shaded.client.com.book/returned_count
   *       metric_kind: DELTA
   *       value_type: INT64
   *       labels:
   *       - key: /customer_id
   *     - name: library.googleapis.alluxio.shaded.client.com.book/overdue_count
   *       metric_kind: GAUGE
   *       value_type: INT64
   *       labels:
   *       - key: /customer_id
   *     monitoring:
   *       producer_destinations:
   *       - monitored_resource: library.googleapis.alluxio.shaded.client.com.branch
   *         metrics:
   *         - library.googleapis.alluxio.shaded.client.com.book/returned_count
   *       consumer_destinations:
   *       - monitored_resource: library.googleapis.alluxio.shaded.client.com.branch
   *         metrics:
   *         - library.googleapis.alluxio.shaded.client.com.book/returned_count
   *         - library.googleapis.alluxio.shaded.client.com.book/overdue_count
   * </pre>
   *
   * Protobuf type {@code google.api.Monitoring}
   */
  public static final class Builder extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.Monitoring)
      alluxio.shaded.client.com.google.api.MonitoringOrBuilder {
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Monitoring.class, Builder.class);
    }

    // Construct using alluxio.shaded.client.com.google.api.Monitoring.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getProducerDestinationsFieldBuilder();
        getConsumerDestinationsFieldBuilder();
      }
    }
    @Override
    public Builder clear() {
      super.clear();
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        producerDestinationsBuilder_.clear();
      }
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return alluxio.shaded.client.com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
    }

    @Override
    public Monitoring getDefaultInstanceForType() {
      return Monitoring.getDefaultInstance();
    }

    @Override
    public Monitoring build() {
      Monitoring result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @Override
    public Monitoring buildPartial() {
      Monitoring result = new Monitoring(this);
      int from_bitField0_ = bitField0_;
      if (producerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          producerDestinations_ = java.util.Collections.unmodifiableList(producerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.producerDestinations_ = producerDestinations_;
      } else {
        result.producerDestinations_ = producerDestinationsBuilder_.build();
      }
      if (consumerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.consumerDestinations_ = consumerDestinations_;
      } else {
        result.consumerDestinations_ = consumerDestinationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @Override
    public Builder clone() {
      return super.clone();
    }
    @Override
    public Builder setField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.setField(field, value);
    }
    @Override
    public Builder clearField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @Override
    public Builder clearOneof(
        alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @Override
    public Builder setRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @Override
    public Builder addRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.addRepeatedField(field, value);
    }
    @Override
    public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
      if (other instanceof Monitoring) {
        return mergeFrom((Monitoring)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(Monitoring other) {
      if (other == Monitoring.getDefaultInstance()) return this;
      if (producerDestinationsBuilder_ == null) {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinations_.isEmpty()) {
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureProducerDestinationsIsMutable();
            producerDestinations_.addAll(other.producerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinationsBuilder_.isEmpty()) {
            producerDestinationsBuilder_.dispose();
            producerDestinationsBuilder_ = null;
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            producerDestinationsBuilder_ = 
              alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getProducerDestinationsFieldBuilder() : null;
          } else {
            producerDestinationsBuilder_.addAllMessages(other.producerDestinations_);
          }
        }
      }
      if (consumerDestinationsBuilder_ == null) {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinations_.isEmpty()) {
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureConsumerDestinationsIsMutable();
            consumerDestinations_.addAll(other.consumerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinationsBuilder_.isEmpty()) {
            consumerDestinationsBuilder_.dispose();
            consumerDestinationsBuilder_ = null;
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            consumerDestinationsBuilder_ = 
              alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getConsumerDestinationsFieldBuilder() : null;
          } else {
            consumerDestinationsBuilder_.addAllMessages(other.consumerDestinations_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @Override
    public final boolean isInitialized() {
      return true;
    }

    @Override
    public Builder mergeFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      Monitoring parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (Monitoring) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.util.List<MonitoringDestination> producerDestinations_ =
      java.util.Collections.emptyList();
    private void ensureProducerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        producerDestinations_ = new java.util.ArrayList<MonitoringDestination>(producerDestinations_);
        bitField0_ |= 0x00000001;
       }
    }

    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        MonitoringDestination, MonitoringDestination.Builder, MonitoringDestinationOrBuilder> producerDestinationsBuilder_;

    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<MonitoringDestination> getProducerDestinationsList() {
      if (producerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      } else {
        return producerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public int getProducerDestinationsCount() {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.size();
      } else {
        return producerDestinationsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public MonitoringDestination getProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);
      } else {
        return producerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addAllProducerDestinations(
        Iterable<? extends MonitoringDestination> values) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, producerDestinations_);
        onChanged();
      } else {
        producerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder clearProducerDestinations() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        producerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder removeProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.remove(index);
        onChanged();
      } else {
        producerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public MonitoringDestination.Builder getProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public MonitoringDestinationOrBuilder getProducerDestinationsOrBuilder(
        int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);  } else {
        return producerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<? extends MonitoringDestinationOrBuilder>
         getProducerDestinationsOrBuilderList() {
      if (producerDestinationsBuilder_ != null) {
        return producerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public MonitoringDestination.Builder addProducerDestinationsBuilder() {
      return getProducerDestinationsFieldBuilder().addBuilder(
          MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public MonitoringDestination.Builder addProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder().addBuilder(
          index, MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<MonitoringDestination.Builder>
         getProducerDestinationsBuilderList() {
      return getProducerDestinationsFieldBuilder().getBuilderList();
    }
    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        MonitoringDestination, MonitoringDestination.Builder, MonitoringDestinationOrBuilder>
        getProducerDestinationsFieldBuilder() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinationsBuilder_ = new alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
            MonitoringDestination, MonitoringDestination.Builder, MonitoringDestinationOrBuilder>(
                producerDestinations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        producerDestinations_ = null;
      }
      return producerDestinationsBuilder_;
    }

    private java.util.List<MonitoringDestination> consumerDestinations_ =
      java.util.Collections.emptyList();
    private void ensureConsumerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        consumerDestinations_ = new java.util.ArrayList<MonitoringDestination>(consumerDestinations_);
        bitField0_ |= 0x00000002;
       }
    }

    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        MonitoringDestination, MonitoringDestination.Builder, MonitoringDestinationOrBuilder> consumerDestinationsBuilder_;

    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<MonitoringDestination> getConsumerDestinationsList() {
      if (consumerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      } else {
        return consumerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public int getConsumerDestinationsCount() {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.size();
      } else {
        return consumerDestinationsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public MonitoringDestination getConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addAllConsumerDestinations(
        Iterable<? extends MonitoringDestination> values) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, consumerDestinations_);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder clearConsumerDestinations() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder removeConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.remove(index);
        onChanged();
      } else {
        consumerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public MonitoringDestination.Builder getConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public MonitoringDestinationOrBuilder getConsumerDestinationsOrBuilder(
        int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);  } else {
        return consumerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<? extends MonitoringDestinationOrBuilder>
         getConsumerDestinationsOrBuilderList() {
      if (consumerDestinationsBuilder_ != null) {
        return consumerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public MonitoringDestination.Builder addConsumerDestinationsBuilder() {
      return getConsumerDestinationsFieldBuilder().addBuilder(
          MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public MonitoringDestination.Builder addConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().addBuilder(
          index, MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resouce type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<MonitoringDestination.Builder>
         getConsumerDestinationsBuilderList() {
      return getConsumerDestinationsFieldBuilder().getBuilderList();
    }
    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        MonitoringDestination, MonitoringDestination.Builder, MonitoringDestinationOrBuilder>
        getConsumerDestinationsFieldBuilder() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinationsBuilder_ = new alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
            MonitoringDestination, MonitoringDestination.Builder, MonitoringDestinationOrBuilder>(
                consumerDestinations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        consumerDestinations_ = null;
      }
      return consumerDestinationsBuilder_;
    }
    @Override
    public final Builder setUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @Override
    public final Builder mergeUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.api.Monitoring)
  }

  // @@protoc_insertion_point(class_scope:google.api.Monitoring)
  private static final Monitoring DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new Monitoring();
  }

  public static Monitoring getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final alluxio.shaded.client.com.google.protobuf.Parser<Monitoring>
      PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Monitoring>() {
    @Override
    public Monitoring parsePartialFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return new Monitoring(input, extensionRegistry);
    }
  };

  public static alluxio.shaded.client.com.google.protobuf.Parser<Monitoring> parser() {
    return PARSER;
  }

  @Override
  public alluxio.shaded.client.com.google.protobuf.Parser<Monitoring> getParserForType() {
    return PARSER;
  }

  @Override
  public Monitoring getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

