// Generated by the protocol buffer alluxio.shaded.client.com.iler.  DO NOT EDIT!
// source: google/type/color.proto

package alluxio.shaded.client.com.google.type;

/**
 * <pre>
 * Represents a color in the RGBA color space. This representation is designed
 * for simplicity of conversion to/from color representations in various
 * languages over alluxio.shaded.client.com.actness; for example, the fields of this representation
 * can be trivially provided to the constructor of "java.awt.Color" in Java; it
 * can also be trivially provided to UIColor's "+colorWithRed:green:blue:alpha"
 * method in iOS; and, with just a little work, it can be easily formatted into
 * a CSS "rgba()" string in JavaScript, as well.
 * Note: this proto does not carry information about the absolute color space
 * that should be used to interpret the RGB value (e.g. sRGB, Adobe RGB,
 * DCI-P3, BT.2020, etc.). By default, applications SHOULD assume the sRGB color
 * space.
 * Example (Java):
 *      import alluxio.shaded.client.com.google.type.Color;
 *      // ...
 *      public static java.awt.Color fromProto(Color protocolor) {
 *        float alpha = protocolor.hasAlpha()
 *            ? protocolor.getAlpha().getValue()
 *            : 1.0;
 *        return new java.awt.Color(
 *            protocolor.getRed(),
 *            protocolor.getGreen(),
 *            protocolor.getBlue(),
 *            alpha);
 *      }
 *      public static Color toProto(java.awt.Color color) {
 *        float red = (float) color.getRed();
 *        float green = (float) color.getGreen();
 *        float blue = (float) color.getBlue();
 *        float denominator = 255.0;
 *        Color.Builder resultBuilder =
 *            Color
 *                .newBuilder()
 *                .setRed(red / denominator)
 *                .setGreen(green / denominator)
 *                .setBlue(blue / denominator);
 *        int alpha = color.getAlpha();
 *        if (alpha != 255) {
 *          result.setAlpha(
 *              FloatValue
 *                  .newBuilder()
 *                  .setValue(((float) alpha) / denominator)
 *                  .build());
 *        }
 *        return resultBuilder.build();
 *      }
 *      // ...
 * Example (iOS / Obj-C):
 *      // ...
 *      static UIColor* fromProto(Color* protocolor) {
 *         float red = [protocolor red];
 *         float green = [protocolor green];
 *         float blue = [protocolor blue];
 *         FloatValue* alpha_wrapper = [protocolor alpha];
 *         float alpha = 1.0;
 *         if (alpha_wrapper != nil) {
 *           alpha = [alpha_wrapper value];
 *         }
 *         return [UIColor colorWithRed:red green:green blue:blue alpha:alpha];
 *      }
 *      static Color* toProto(UIColor* color) {
 *          CGFloat red, green, blue, alpha;
 *          if (![color getRed:&amp;red green:&amp;green blue:&amp;blue alpha:&amp;alpha]) {
 *            return nil;
 *          }
 *          Color* result = [[Color alloc] init];
 *          [result setRed:red];
 *          [result setGreen:green];
 *          [result setBlue:blue];
 *          if (alpha &lt;= 0.9999) {
 *            [result setAlpha:floatWrapperWithValue(alpha)];
 *          }
 *          [result autorelease];
 *          return result;
 *     }
 *     // ...
 *  Example (JavaScript):
 *     // ...
 *     var protoToCssColor = function(rgb_color) {
 *        var redFrac = rgb_color.red || 0.0;
 *        var greenFrac = rgb_color.green || 0.0;
 *        var blueFrac = rgb_color.blue || 0.0;
 *        var red = Math.floor(redFrac * 255);
 *        var green = Math.floor(greenFrac * 255);
 *        var blue = Math.floor(blueFrac * 255);
 *        if (!('alpha' in rgb_color)) {
 *           return rgbToCssColor_(red, green, blue);
 *        }
 *        var alphaFrac = rgb_color.alpha.value || 0.0;
 *        var rgbParams = [red, green, blue].join(',');
 *        return ['rgba(', rgbParams, ',', alphaFrac, ')'].join('');
 *     };
 *     var rgbToCssColor_ = function(red, green, blue) {
 *       var rgbNumber = new Number((red &lt;&lt; 16) | (green &lt;&lt; 8) | blue);
 *       var hexString = rgbNumber.toString(16);
 *       var missingZeros = 6 - hexString.length;
 *       var resultBuilder = ['#'];
 *       for (var i = 0; i &lt; missingZeros; i++) {
 *          resultBuilder.push('0');
 *       }
 *       resultBuilder.push(hexString);
 *       return resultBuilder.join('');
 *     };
 *     // ...
 * </pre>
 *
 * Protobuf type {@code google.type.Color}
 */
public  final class Color extends
    alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.type.Color)
    ColorOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Color.newBuilder() to construct.
  private Color(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Color() {
  }

  @Override
  public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Color(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new NullPointerException();
    }
    int mutable_bitField0_ = 0;
    alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 13: {

            red_ = input.readFloat();
            break;
          }
          case 21: {

            green_ = input.readFloat();
            break;
          }
          case 29: {

            blue_ = input.readFloat();
            break;
          }
          case 34: {
            alluxio.shaded.client.com.google.protobuf.FloatValue.Builder subBuilder = null;
            if (alpha_ != null) {
              subBuilder = alpha_.toBuilder();
            }
            alpha_ = input.readMessage(alluxio.shaded.client.com.google.protobuf.FloatValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(alpha_);
              alpha_ = subBuilder.buildPartial();
            }

            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.alluxio.shaded.client.io.IOException e) {
      throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return alluxio.shaded.client.com.google.type.ColorProto.internal_static_google_type_Color_descriptor;
  }

  @Override
  protected FieldAccessorTable
      internalGetFieldAccessorTable() {
    return alluxio.shaded.client.com.google.type.ColorProto.internal_static_google_type_Color_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            Color.class, Builder.class);
  }

  public static final int RED_FIELD_NUMBER = 1;
  private float red_;
  /**
   * <pre>
   * The amount of red in the color as a value in the interval [0, 1].
   * </pre>
   *
   * <code>float red = 1;</code>
   */
  public float getRed() {
    return red_;
  }

  public static final int GREEN_FIELD_NUMBER = 2;
  private float green_;
  /**
   * <pre>
   * The amount of green in the color as a value in the interval [0, 1].
   * </pre>
   *
   * <code>float green = 2;</code>
   */
  public float getGreen() {
    return green_;
  }

  public static final int BLUE_FIELD_NUMBER = 3;
  private float blue_;
  /**
   * <pre>
   * The amount of blue in the color as a value in the interval [0, 1].
   * </pre>
   *
   * <code>float blue = 3;</code>
   */
  public float getBlue() {
    return blue_;
  }

  public static final int ALPHA_FIELD_NUMBER = 4;
  private alluxio.shaded.client.com.google.protobuf.FloatValue alpha_;
  /**
   * <pre>
   * The fraction of this color that should be applied to the pixel. That is,
   * the final pixel color is defined by the equation:
   *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
   * This means that a value of 1.0 corresponds to a solid color, whereas
   * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
   * uses a wrapper message rather than a simple float scalar so that it is
   * possible to distinguish between a default value and the value being unset.
   * If omitted, this color object is to be rendered as a solid color
   * (as if the alpha value had been explicitly given with a value of 1.0).
   * </pre>
   *
   * <code>.google.protobuf.FloatValue alpha = 4;</code>
   */
  public boolean hasAlpha() {
    return alpha_ != null;
  }
  /**
   * <pre>
   * The fraction of this color that should be applied to the pixel. That is,
   * the final pixel color is defined by the equation:
   *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
   * This means that a value of 1.0 corresponds to a solid color, whereas
   * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
   * uses a wrapper message rather than a simple float scalar so that it is
   * possible to distinguish between a default value and the value being unset.
   * If omitted, this color object is to be rendered as a solid color
   * (as if the alpha value had been explicitly given with a value of 1.0).
   * </pre>
   *
   * <code>.google.protobuf.FloatValue alpha = 4;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.FloatValue getAlpha() {
    return alpha_ == null ? alluxio.shaded.client.com.google.protobuf.FloatValue.getDefaultInstance() : alpha_;
  }
  /**
   * <pre>
   * The fraction of this color that should be applied to the pixel. That is,
   * the final pixel color is defined by the equation:
   *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
   * This means that a value of 1.0 corresponds to a solid color, whereas
   * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
   * uses a wrapper message rather than a simple float scalar so that it is
   * possible to distinguish between a default value and the value being unset.
   * If omitted, this color object is to be rendered as a solid color
   * (as if the alpha value had been explicitly given with a value of 1.0).
   * </pre>
   *
   * <code>.google.protobuf.FloatValue alpha = 4;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.FloatValueOrBuilder getAlphaOrBuilder() {
    return getAlpha();
  }

  private byte memoizedIsInitialized = -1;
  @Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @Override
  public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                      throws java.alluxio.shaded.client.io.IOException {
    if (red_ != 0F) {
      output.writeFloat(1, red_);
    }
    if (green_ != 0F) {
      output.writeFloat(2, green_);
    }
    if (blue_ != 0F) {
      output.writeFloat(3, blue_);
    }
    if (alpha_ != null) {
      output.writeMessage(4, getAlpha());
    }
    unknownFields.writeTo(output);
  }

  @Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (red_ != 0F) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteFloatSize(1, red_);
    }
    if (green_ != 0F) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteFloatSize(2, green_);
    }
    if (blue_ != 0F) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteFloatSize(3, blue_);
    }
    if (alpha_ != null) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(4, getAlpha());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof Color)) {
      return super.equals(obj);
    }
    Color other = (Color) obj;

    if (Float.floatToIntBits(getRed())
        != Float.floatToIntBits(
            other.getRed())) return false;
    if (Float.floatToIntBits(getGreen())
        != Float.floatToIntBits(
            other.getGreen())) return false;
    if (Float.floatToIntBits(getBlue())
        != Float.floatToIntBits(
            other.getBlue())) return false;
    if (hasAlpha() != other.hasAlpha()) return false;
    if (hasAlpha()) {
      if (!getAlpha()
          .equals(other.getAlpha())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RED_FIELD_NUMBER;
    hash = (53 * hash) + Float.floatToIntBits(
        getRed());
    hash = (37 * hash) + GREEN_FIELD_NUMBER;
    hash = (53 * hash) + Float.floatToIntBits(
        getGreen());
    hash = (37 * hash) + BLUE_FIELD_NUMBER;
    hash = (53 * hash) + Float.floatToIntBits(
        getBlue());
    if (hasAlpha()) {
      hash = (37 * hash) + ALPHA_FIELD_NUMBER;
      hash = (53 * hash) + getAlpha().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static Color parseFrom(
      java.nio.ByteBuffer data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Color parseFrom(
      java.nio.ByteBuffer data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Color parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Color parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Color parseFrom(byte[] data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Color parseFrom(
      byte[] data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Color parseFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Color parseFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static Color parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static Color parseDelimitedFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static Color parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Color parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(Color prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @Override
  protected Builder newBuilderForType(
      BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents a color in the RGBA color space. This representation is designed
   * for simplicity of conversion to/from color representations in various
   * languages over alluxio.shaded.client.com.actness; for example, the fields of this representation
   * can be trivially provided to the constructor of "java.awt.Color" in Java; it
   * can also be trivially provided to UIColor's "+colorWithRed:green:blue:alpha"
   * method in iOS; and, with just a little work, it can be easily formatted into
   * a CSS "rgba()" string in JavaScript, as well.
   * Note: this proto does not carry information about the absolute color space
   * that should be used to interpret the RGB value (e.g. sRGB, Adobe RGB,
   * DCI-P3, BT.2020, etc.). By default, applications SHOULD assume the sRGB color
   * space.
   * Example (Java):
   *      import alluxio.shaded.client.com.google.type.Color;
   *      // ...
   *      public static java.awt.Color fromProto(Color protocolor) {
   *        float alpha = protocolor.hasAlpha()
   *            ? protocolor.getAlpha().getValue()
   *            : 1.0;
   *        return new java.awt.Color(
   *            protocolor.getRed(),
   *            protocolor.getGreen(),
   *            protocolor.getBlue(),
   *            alpha);
   *      }
   *      public static Color toProto(java.awt.Color color) {
   *        float red = (float) color.getRed();
   *        float green = (float) color.getGreen();
   *        float blue = (float) color.getBlue();
   *        float denominator = 255.0;
   *        Color.Builder resultBuilder =
   *            Color
   *                .newBuilder()
   *                .setRed(red / denominator)
   *                .setGreen(green / denominator)
   *                .setBlue(blue / denominator);
   *        int alpha = color.getAlpha();
   *        if (alpha != 255) {
   *          result.setAlpha(
   *              FloatValue
   *                  .newBuilder()
   *                  .setValue(((float) alpha) / denominator)
   *                  .build());
   *        }
   *        return resultBuilder.build();
   *      }
   *      // ...
   * Example (iOS / Obj-C):
   *      // ...
   *      static UIColor* fromProto(Color* protocolor) {
   *         float red = [protocolor red];
   *         float green = [protocolor green];
   *         float blue = [protocolor blue];
   *         FloatValue* alpha_wrapper = [protocolor alpha];
   *         float alpha = 1.0;
   *         if (alpha_wrapper != nil) {
   *           alpha = [alpha_wrapper value];
   *         }
   *         return [UIColor colorWithRed:red green:green blue:blue alpha:alpha];
   *      }
   *      static Color* toProto(UIColor* color) {
   *          CGFloat red, green, blue, alpha;
   *          if (![color getRed:&amp;red green:&amp;green blue:&amp;blue alpha:&amp;alpha]) {
   *            return nil;
   *          }
   *          Color* result = [[Color alloc] init];
   *          [result setRed:red];
   *          [result setGreen:green];
   *          [result setBlue:blue];
   *          if (alpha &lt;= 0.9999) {
   *            [result setAlpha:floatWrapperWithValue(alpha)];
   *          }
   *          [result autorelease];
   *          return result;
   *     }
   *     // ...
   *  Example (JavaScript):
   *     // ...
   *     var protoToCssColor = function(rgb_color) {
   *        var redFrac = rgb_color.red || 0.0;
   *        var greenFrac = rgb_color.green || 0.0;
   *        var blueFrac = rgb_color.blue || 0.0;
   *        var red = Math.floor(redFrac * 255);
   *        var green = Math.floor(greenFrac * 255);
   *        var blue = Math.floor(blueFrac * 255);
   *        if (!('alpha' in rgb_color)) {
   *           return rgbToCssColor_(red, green, blue);
   *        }
   *        var alphaFrac = rgb_color.alpha.value || 0.0;
   *        var rgbParams = [red, green, blue].join(',');
   *        return ['rgba(', rgbParams, ',', alphaFrac, ')'].join('');
   *     };
   *     var rgbToCssColor_ = function(red, green, blue) {
   *       var rgbNumber = new Number((red &lt;&lt; 16) | (green &lt;&lt; 8) | blue);
   *       var hexString = rgbNumber.toString(16);
   *       var missingZeros = 6 - hexString.length;
   *       var resultBuilder = ['#'];
   *       for (var i = 0; i &lt; missingZeros; i++) {
   *          resultBuilder.push('0');
   *       }
   *       resultBuilder.push(hexString);
   *       return resultBuilder.join('');
   *     };
   *     // ...
   * </pre>
   *
   * Protobuf type {@code google.type.Color}
   */
  public static final class Builder extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.type.Color)
      alluxio.shaded.client.com.google.type.ColorOrBuilder {
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.type.ColorProto.internal_static_google_type_Color_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.type.ColorProto.internal_static_google_type_Color_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Color.class, Builder.class);
    }

    // Construct using alluxio.shaded.client.com.google.type.Color.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @Override
    public Builder clear() {
      super.clear();
      red_ = 0F;

      green_ = 0F;

      blue_ = 0F;

      if (alphaBuilder_ == null) {
        alpha_ = null;
      } else {
        alpha_ = null;
        alphaBuilder_ = null;
      }
      return this;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return alluxio.shaded.client.com.google.type.ColorProto.internal_static_google_type_Color_descriptor;
    }

    @Override
    public Color getDefaultInstanceForType() {
      return Color.getDefaultInstance();
    }

    @Override
    public Color build() {
      Color result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @Override
    public Color buildPartial() {
      Color result = new Color(this);
      result.red_ = red_;
      result.green_ = green_;
      result.blue_ = blue_;
      if (alphaBuilder_ == null) {
        result.alpha_ = alpha_;
      } else {
        result.alpha_ = alphaBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @Override
    public Builder clone() {
      return super.clone();
    }
    @Override
    public Builder setField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.setField(field, value);
    }
    @Override
    public Builder clearField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @Override
    public Builder clearOneof(
        alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @Override
    public Builder setRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @Override
    public Builder addRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.addRepeatedField(field, value);
    }
    @Override
    public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
      if (other instanceof Color) {
        return mergeFrom((Color)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(Color other) {
      if (other == Color.getDefaultInstance()) return this;
      if (other.getRed() != 0F) {
        setRed(other.getRed());
      }
      if (other.getGreen() != 0F) {
        setGreen(other.getGreen());
      }
      if (other.getBlue() != 0F) {
        setBlue(other.getBlue());
      }
      if (other.hasAlpha()) {
        mergeAlpha(other.getAlpha());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @Override
    public final boolean isInitialized() {
      return true;
    }

    @Override
    public Builder mergeFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      Color parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (Color) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private float red_ ;
    /**
     * <pre>
     * The amount of red in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float red = 1;</code>
     */
    public float getRed() {
      return red_;
    }
    /**
     * <pre>
     * The amount of red in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float red = 1;</code>
     */
    public Builder setRed(float value) {
      
      red_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The amount of red in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float red = 1;</code>
     */
    public Builder clearRed() {
      
      red_ = 0F;
      onChanged();
      return this;
    }

    private float green_ ;
    /**
     * <pre>
     * The amount of green in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float green = 2;</code>
     */
    public float getGreen() {
      return green_;
    }
    /**
     * <pre>
     * The amount of green in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float green = 2;</code>
     */
    public Builder setGreen(float value) {
      
      green_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The amount of green in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float green = 2;</code>
     */
    public Builder clearGreen() {
      
      green_ = 0F;
      onChanged();
      return this;
    }

    private float blue_ ;
    /**
     * <pre>
     * The amount of blue in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float blue = 3;</code>
     */
    public float getBlue() {
      return blue_;
    }
    /**
     * <pre>
     * The amount of blue in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float blue = 3;</code>
     */
    public Builder setBlue(float value) {
      
      blue_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The amount of blue in the color as a value in the interval [0, 1].
     * </pre>
     *
     * <code>float blue = 3;</code>
     */
    public Builder clearBlue() {
      
      blue_ = 0F;
      onChanged();
      return this;
    }

    private alluxio.shaded.client.com.google.protobuf.FloatValue alpha_;
    private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
        alluxio.shaded.client.com.google.protobuf.FloatValue, alluxio.shaded.client.com.google.protobuf.FloatValue.Builder, alluxio.shaded.client.com.google.protobuf.FloatValueOrBuilder> alphaBuilder_;
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public boolean hasAlpha() {
      return alphaBuilder_ != null || alpha_ != null;
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.FloatValue getAlpha() {
      if (alphaBuilder_ == null) {
        return alpha_ == null ? alluxio.shaded.client.com.google.protobuf.FloatValue.getDefaultInstance() : alpha_;
      } else {
        return alphaBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public Builder setAlpha(alluxio.shaded.client.com.google.protobuf.FloatValue value) {
      if (alphaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alpha_ = value;
        onChanged();
      } else {
        alphaBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public Builder setAlpha(
        alluxio.shaded.client.com.google.protobuf.FloatValue.Builder builderForValue) {
      if (alphaBuilder_ == null) {
        alpha_ = builderForValue.build();
        onChanged();
      } else {
        alphaBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public Builder mergeAlpha(alluxio.shaded.client.com.google.protobuf.FloatValue value) {
      if (alphaBuilder_ == null) {
        if (alpha_ != null) {
          alpha_ =
            alluxio.shaded.client.com.google.protobuf.FloatValue.newBuilder(alpha_).mergeFrom(value).buildPartial();
        } else {
          alpha_ = value;
        }
        onChanged();
      } else {
        alphaBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public Builder clearAlpha() {
      if (alphaBuilder_ == null) {
        alpha_ = null;
        onChanged();
      } else {
        alpha_ = null;
        alphaBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.FloatValue.Builder getAlphaBuilder() {
      
      onChanged();
      return getAlphaFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.FloatValueOrBuilder getAlphaOrBuilder() {
      if (alphaBuilder_ != null) {
        return alphaBuilder_.getMessageOrBuilder();
      } else {
        return alpha_ == null ?
            alluxio.shaded.client.com.google.protobuf.FloatValue.getDefaultInstance() : alpha_;
      }
    }
    /**
     * <pre>
     * The fraction of this color that should be applied to the pixel. That is,
     * the final pixel color is defined by the equation:
     *   pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * This means that a value of 1.0 corresponds to a solid color, whereas
     * a value of 0.0 corresponds to a alluxio.shaded.client.com.letely transparent color. This
     * uses a wrapper message rather than a simple float scalar so that it is
     * possible to distinguish between a default value and the value being unset.
     * If omitted, this color object is to be rendered as a solid color
     * (as if the alpha value had been explicitly given with a value of 1.0).
     * </pre>
     *
     * <code>.google.protobuf.FloatValue alpha = 4;</code>
     */
    private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
        alluxio.shaded.client.com.google.protobuf.FloatValue, alluxio.shaded.client.com.google.protobuf.FloatValue.Builder, alluxio.shaded.client.com.google.protobuf.FloatValueOrBuilder> 
        getAlphaFieldBuilder() {
      if (alphaBuilder_ == null) {
        alphaBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
            alluxio.shaded.client.com.google.protobuf.FloatValue, alluxio.shaded.client.com.google.protobuf.FloatValue.Builder, alluxio.shaded.client.com.google.protobuf.FloatValueOrBuilder>(
                getAlpha(),
                getParentForChildren(),
                isClean());
        alpha_ = null;
      }
      return alphaBuilder_;
    }
    @Override
    public final Builder setUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @Override
    public final Builder mergeUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.type.Color)
  }

  // @@protoc_insertion_point(class_scope:google.type.Color)
  private static final Color DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new Color();
  }

  public static Color getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final alluxio.shaded.client.com.google.protobuf.Parser<Color>
      PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Color>() {
    @Override
    public Color parsePartialFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return new Color(input, extensionRegistry);
    }
  };

  public static alluxio.shaded.client.com.google.protobuf.Parser<Color> parser() {
    return PARSER;
  }

  @Override
  public alluxio.shaded.client.com.google.protobuf.Parser<Color> getParserForType() {
    return PARSER;
  }

  @Override
  public Color getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

