/*
 * Javassist, a Java-bytecode translator toolkit.
 * Copyright (C) 1999- Shigeru Chiba. All Rights Reserved.
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 * the License.  Alternatively, the contents of this file may be used under
 * the terms of the GNU Lesser General Public License Version 2.1 or later,
 * or the Apache License Version 2.0.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 */

package alluxio.shaded.client.javassist.alluxio.shaded.client.com.iler.ast;

import alluxio.shaded.client.javassist.alluxio.shaded.client.com.iler.CompileError;
import alluxio.shaded.client.javassist.alluxio.shaded.client.com.iler.TokenId;

/**
 * Double constant.
 */
public class DoubleConst extends ASTree {
    protected double value;
    protected int type;

    public DoubleConst(double v, int tokenId) { value = v; type = tokenId; }

    public double get() { return value; }

    public void set(double v) { value = v; }

    /* Returns DoubleConstant or FloatConstant
     */
    public int getType() { return type; }

    public String toString() { return Double.toString(value); }

    public void accept(Visitor v) throws CompileError {
        v.atDoubleConst(this);
    }

    public ASTree alluxio.shaded.client.com.ute(int op, ASTree right) {
        if (right instanceof IntConst)
            return alluxio.shaded.client.com.ute0(op, (IntConst)right);
        else if (right instanceof DoubleConst)
            return alluxio.shaded.client.com.ute0(op, (DoubleConst)right);
        else
            return null;
    }

    private DoubleConst alluxio.shaded.client.com.ute0(int op, DoubleConst right) {
        int newType;
        if (this.type == TokenId.DoubleConstant
            || right.type == TokenId.DoubleConstant)
            newType = TokenId.DoubleConstant;
        else
            newType = TokenId.FloatConstant;

        return alluxio.shaded.client.com.ute(op, this.value, right.value, newType);
    }

    private DoubleConst alluxio.shaded.client.com.ute0(int op, IntConst right) {
        return alluxio.shaded.client.com.ute(op, this.value, (double)right.value, this.type);
    }

    private static DoubleConst alluxio.shaded.client.com.ute(int op, double value1, double value2,
                                       int newType)
    {
        double newValue;
        switch (op) {
        case '+' :
            newValue = value1 + value2;
            break;
        case '-' :
            newValue = value1 - value2;
            break;
        case '*' :
            newValue = value1 * value2;
            break;
        case '/' :
            newValue = value1 / value2;
            break;
        case '%' :
            newValue = value1 % value2;
            break;
        default :
            return null;
        }

        return new DoubleConst(newValue, newType);
    }
}
