package alluxio.shaded.client.org.reflections.scanners;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Predicate;
import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.Multimap;
import alluxio.shaded.client.org.reflections.Configuration;
import alluxio.shaded.client.org.reflections.vfs.Vfs;

import alluxio.shaded.client.javax.annotation.Nullable;

/**
 *
 */
public interface Scanner {

    void setConfiguration(Configuration configuration);

    Multimap<String, String> getStore();

    void setStore(Multimap<String, String> store);

    Scanner filterResultsBy(Predicate<String> filter);

    boolean acceptsInput(String file);

    Object scan(Vfs.File file, @Nullable Object classObject);

    boolean acceptResult(String fqn);
}
