/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.shaded.client.com.codahale.metrics.Metric;
import alluxio.shaded.client.com.codahale.metrics.MetricFilter;
import alluxio.shaded.client.org.apache.commons.lang.StringUtils;
import java.util.Properties;

public class RegexMetricFilter
implements MetricFilter {
    private static final String SLF4J_KEY_FILTER_REGEX = "filter-regex";
    private final Properties mProperties;
    private final String mRegex;

    public RegexMetricFilter(Properties properties) {
        this.mProperties = properties;
        this.mRegex = this.getRegex();
    }

    @Override
    public boolean matches(String name, Metric metric) {
        if (this.mRegex != null) {
            return name.matches(this.mRegex);
        }
        return true;
    }

    private String getRegex() {
        String regex = this.mProperties.getProperty(SLF4J_KEY_FILTER_REGEX);
        if (StringUtils.isBlank(regex)) {
            regex = null;
        }
        return regex;
    }
}

