// Generated by the protocol buffer alluxio.shaded.client.com.iler.  DO NOT EDIT!
// source: google/api/distribution.proto

package alluxio.shaded.client.com.google.api;

/**
 * <pre>
 * `Distribution` contains summary statistics for a population of values. It
 * optionally contains a histogram representing the distribution of those values
 * across a set of buckets.
 * The summary statistics are the count, mean, sum of the squared deviation from
 * the mean, the minimum, and the maximum of the set of population of values.
 * The histogram is based on a sequence of buckets and gives a count of values
 * that fall into each bucket. The boundaries of the buckets are given either
 * explicitly or by formulas for buckets of fixed or exponentially increasing
 * widths.
 * Although it is not forbidden, it is generally a bad idea to include
 * non-finite values (infinities or NaNs) in the population of values, as this
 * will render the `mean` and `sum_of_squared_deviation` fields meaningless.
 * </pre>
 *
 * Protobuf type {@code google.api.Distribution}
 */
public  final class Distribution extends
    alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.Distribution)
    DistributionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Distribution.newBuilder() to construct.
  private Distribution(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Distribution() {
    bucketCounts_ = emptyLongList();
    exemplars_ = java.util.Collections.emptyList();
  }

  @Override
  public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Distribution(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new NullPointerException();
    }
    int mutable_bitField0_ = 0;
    alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {

            count_ = input.readInt64();
            break;
          }
          case 17: {

            mean_ = input.readDouble();
            break;
          }
          case 25: {

            sumOfSquaredDeviation_ = input.readDouble();
            break;
          }
          case 34: {
            Range.Builder subBuilder = null;
            if (range_ != null) {
              subBuilder = range_.toBuilder();
            }
            range_ = input.readMessage(Range.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(range_);
              range_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            BucketOptions.Builder subBuilder = null;
            if (bucketOptions_ != null) {
              subBuilder = bucketOptions_.toBuilder();
            }
            bucketOptions_ = input.readMessage(BucketOptions.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(bucketOptions_);
              bucketOptions_ = subBuilder.buildPartial();
            }

            break;
          }
          case 56: {
            if (!((mutable_bitField0_ & 0x00000020) != 0)) {
              bucketCounts_ = newLongList();
              mutable_bitField0_ |= 0x00000020;
            }
            bucketCounts_.addLong(input.readInt64());
            break;
          }
          case 58: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000020) != 0) && input.getBytesUntilLimit() > 0) {
              bucketCounts_ = newLongList();
              mutable_bitField0_ |= 0x00000020;
            }
            while (input.getBytesUntilLimit() > 0) {
              bucketCounts_.addLong(input.readInt64());
            }
            input.popLimit(limit);
            break;
          }
          case 82: {
            if (!((mutable_bitField0_ & 0x00000040) != 0)) {
              exemplars_ = new java.util.ArrayList<Exemplar>();
              mutable_bitField0_ |= 0x00000040;
            }
            exemplars_.add(
                input.readMessage(Exemplar.parser(), extensionRegistry));
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.alluxio.shaded.client.io.IOException e) {
      throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000020) != 0)) {
        bucketCounts_.makeImmutable(); // C
      }
      if (((mutable_bitField0_ & 0x00000040) != 0)) {
        exemplars_ = java.util.Collections.unmodifiableList(exemplars_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
  }

  @Override
  protected FieldAccessorTable
      internalGetFieldAccessorTable() {
    return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            Distribution.class, Builder.class);
  }

  public interface RangeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.Range)
      alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The minimum of the population values.
     * </pre>
     *
     * <code>double min = 1;</code>
     */
    double getMin();

    /**
     * <pre>
     * The maximum of the population values.
     * </pre>
     *
     * <code>double max = 2;</code>
     */
    double getMax();
  }
  /**
   * <pre>
   * The range of the population values.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.Range}
   */
  public  static final class Range extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.Range)
      RangeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Range.newBuilder() to construct.
    private Range(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Range() {
    }

    @Override
    public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Range(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new NullPointerException();
      }
      int mutable_bitField0_ = 0;
      alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9: {

              min_ = input.readDouble();
              break;
            }
            case 17: {

              max_ = input.readDouble();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.alluxio.shaded.client.io.IOException e) {
        throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Range.class, Builder.class);
    }

    public static final int MIN_FIELD_NUMBER = 1;
    private double min_;
    /**
     * <pre>
     * The minimum of the population values.
     * </pre>
     *
     * <code>double min = 1;</code>
     */
    public double getMin() {
      return min_;
    }

    public static final int MAX_FIELD_NUMBER = 2;
    private double max_;
    /**
     * <pre>
     * The maximum of the population values.
     * </pre>
     *
     * <code>double max = 2;</code>
     */
    public double getMax() {
      return max_;
    }

    private byte memoizedIsInitialized = -1;
    @Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @Override
    public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                        throws java.alluxio.shaded.client.io.IOException {
      if (min_ != 0D) {
        output.writeDouble(1, min_);
      }
      if (max_ != 0D) {
        output.writeDouble(2, max_);
      }
      unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (min_ != 0D) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteDoubleSize(1, min_);
      }
      if (max_ != 0D) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteDoubleSize(2, max_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @Override
    public boolean equals(final Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof Range)) {
        return super.equals(obj);
      }
      Range other = (Range) obj;

      if (Double.doubleToLongBits(getMin())
          != Double.doubleToLongBits(
              other.getMin())) return false;
      if (Double.doubleToLongBits(getMax())
          != Double.doubleToLongBits(
              other.getMax())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_FIELD_NUMBER;
      hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
          Double.doubleToLongBits(getMin()));
      hash = (37 * hash) + MAX_FIELD_NUMBER;
      hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
          Double.doubleToLongBits(getMax()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static Range parseFrom(
        java.nio.ByteBuffer data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Range parseFrom(
        java.nio.ByteBuffer data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Range parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Range parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Range parseFrom(byte[] data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Range parseFrom(
        byte[] data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Range parseFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static Range parseFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static Range parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static Range parseDelimitedFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static Range parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static Range parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(Range prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(
        BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * The range of the population values.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.Range}
     */
    public static final class Builder extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.Range)
        RangeOrBuilder {
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Range.class, Builder.class);
      }

      // Construct using alluxio.shaded.client.com.google.api.Distribution.Range.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @Override
      public Builder clear() {
        super.clear();
        min_ = 0D;

        max_ = 0D;

        return this;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_descriptor;
      }

      @Override
      public Range getDefaultInstanceForType() {
        return Range.getDefaultInstance();
      }

      @Override
      public Range build() {
        Range result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @Override
      public Range buildPartial() {
        Range result = new Range(this);
        result.min_ = min_;
        result.max_ = max_;
        onBuilt();
        return result;
      }

      @Override
      public Builder clone() {
        return super.clone();
      }
      @Override
      public Builder setField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.setField(field, value);
      }
      @Override
      public Builder clearField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @Override
      public Builder clearOneof(
          alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @Override
      public Builder setRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @Override
      public Builder addRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.addRepeatedField(field, value);
      }
      @Override
      public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
        if (other instanceof Range) {
          return mergeFrom((Range)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Range other) {
        if (other == Range.getDefaultInstance()) return this;
        if (other.getMin() != 0D) {
          setMin(other.getMin());
        }
        if (other.getMax() != 0D) {
          setMax(other.getMax());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @Override
      public final boolean isInitialized() {
        return true;
      }

      @Override
      public Builder mergeFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        Range parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Range) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private double min_ ;
      /**
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       */
      public double getMin() {
        return min_;
      }
      /**
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       */
      public Builder setMin(double value) {
        
        min_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       */
      public Builder clearMin() {
        
        min_ = 0D;
        onChanged();
        return this;
      }

      private double max_ ;
      /**
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       */
      public double getMax() {
        return max_;
      }
      /**
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       */
      public Builder setMax(double value) {
        
        max_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       */
      public Builder clearMax() {
        
        max_ = 0D;
        onChanged();
        return this;
      }
      @Override
      public final Builder setUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @Override
      public final Builder mergeUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.api.Distribution.Range)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.Range)
    private static final Range DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new Range();
    }

    public static Range getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final alluxio.shaded.client.com.google.protobuf.Parser<Range>
        PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Range>() {
      @Override
      public Range parsePartialFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return new Range(input, extensionRegistry);
      }
    };

    public static alluxio.shaded.client.com.google.protobuf.Parser<Range> parser() {
      return PARSER;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Parser<Range> getParserForType() {
      return PARSER;
    }

    @Override
    public Range getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface BucketOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions)
      alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    boolean hasLinearBuckets();
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    BucketOptions.Linear getLinearBuckets();
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder();

    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    boolean hasExponentialBuckets();
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    BucketOptions.Exponential getExponentialBuckets();
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    BucketOptions.ExponentialOrBuilder getExponentialBucketsOrBuilder();

    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    boolean hasExplicitBuckets();
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    BucketOptions.Explicit getExplicitBuckets();
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    BucketOptions.ExplicitOrBuilder getExplicitBucketsOrBuilder();

    public BucketOptions.OptionsCase getOptionsCase();
  }
  /**
   * <pre>
   * `BucketOptions` describes the bucket boundaries used to create a histogram
   * for the distribution. The buckets can be in a linear sequence, an
   * exponential sequence, or each bucket can be specified explicitly.
   * `BucketOptions` does not include the number of values in each bucket.
   * A bucket has an inclusive lower bound and exclusive upper bound for the
   * values that are counted for that bucket. The upper bound of a bucket must
   * be strictly greater than the lower bound. The sequence of N buckets for a
   * distribution consists of an underflow bucket (number 0), zero or more
   * finite buckets (number 1 through N - 2) and an overflow bucket (number N -
   * 1). The buckets are contiguous: the lower bound of bucket i (i &gt; 0) is the
   * same as the upper bound of bucket i - 1. The buckets span the whole range
   * of finite values: lower bound of the underflow bucket is -infinity and the
   * upper bound of the overflow bucket is +infinity. The finite buckets are
   * so-called because both bounds are finite.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.BucketOptions}
   */
  public  static final class BucketOptions extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions)
      BucketOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BucketOptions.newBuilder() to construct.
    private BucketOptions(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BucketOptions() {
    }

    @Override
    public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BucketOptions(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new NullPointerException();
      }
      int mutable_bitField0_ = 0;
      alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              Linear.Builder subBuilder = null;
              if (optionsCase_ == 1) {
                subBuilder = ((Linear) options_).toBuilder();
              }
              options_ =
                  input.readMessage(Linear.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((Linear) options_);
                options_ = subBuilder.buildPartial();
              }
              optionsCase_ = 1;
              break;
            }
            case 18: {
              Exponential.Builder subBuilder = null;
              if (optionsCase_ == 2) {
                subBuilder = ((Exponential) options_).toBuilder();
              }
              options_ =
                  input.readMessage(Exponential.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((Exponential) options_);
                options_ = subBuilder.buildPartial();
              }
              optionsCase_ = 2;
              break;
            }
            case 26: {
              Explicit.Builder subBuilder = null;
              if (optionsCase_ == 3) {
                subBuilder = ((Explicit) options_).toBuilder();
              }
              options_ =
                  input.readMessage(Explicit.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((Explicit) options_);
                options_ = subBuilder.buildPartial();
              }
              optionsCase_ = 3;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.alluxio.shaded.client.io.IOException e) {
        throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              BucketOptions.class, Builder.class);
    }

    public interface LinearOrBuilder extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Linear)
        alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      int getNumFiniteBuckets();

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      double getWidth();

      /**
       * <pre>
       * Lower bound of the first bucket.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      double getOffset();
    }
    /**
     * <pre>
     * Specifies a linear sequence of buckets that all have the same width
     * (except overflow and underflow). Each bucket represents a constant
     * absolute uncertainty on the specific value in the bucket.
     * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
     * following boundaries:
     *    Upper bound (0 &lt;= i &lt; N-1):     offset + (width * i).
     *    Lower bound (1 &lt;= i &lt; N):       offset + (width * (i - 1)).
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Linear}
     */
    public  static final class Linear extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Linear)
        LinearOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Linear.newBuilder() to construct.
      private Linear(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Linear() {
      }

      @Override
      public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Linear(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {

                numFiniteBuckets_ = input.readInt32();
                break;
              }
              case 17: {

                width_ = input.readDouble();
                break;
              }
              case 25: {

                offset_ = input.readDouble();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.alluxio.shaded.client.io.IOException e) {
          throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Linear.class, Builder.class);
      }

      public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
      private int numFiniteBuckets_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }

      public static final int WIDTH_FIELD_NUMBER = 2;
      private double width_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      public double getWidth() {
        return width_;
      }

      public static final int OFFSET_FIELD_NUMBER = 3;
      private double offset_;
      /**
       * <pre>
       * Lower bound of the first bucket.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      public double getOffset() {
        return offset_;
      }

      private byte memoizedIsInitialized = -1;
      @Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @Override
      public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                          throws java.alluxio.shaded.client.io.IOException {
        if (numFiniteBuckets_ != 0) {
          output.writeInt32(1, numFiniteBuckets_);
        }
        if (width_ != 0D) {
          output.writeDouble(2, width_);
        }
        if (offset_ != 0D) {
          output.writeDouble(3, offset_);
        }
        unknownFields.writeTo(output);
      }

      @Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numFiniteBuckets_ != 0) {
          size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteInt32Size(1, numFiniteBuckets_);
        }
        if (width_ != 0D) {
          size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteDoubleSize(2, width_);
        }
        if (offset_ != 0D) {
          size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteDoubleSize(3, offset_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @Override
      public boolean equals(final Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof Linear)) {
          return super.equals(obj);
        }
        Linear other = (Linear) obj;

        if (getNumFiniteBuckets()
            != other.getNumFiniteBuckets()) return false;
        if (Double.doubleToLongBits(getWidth())
            != Double.doubleToLongBits(
                other.getWidth())) return false;
        if (Double.doubleToLongBits(getOffset())
            != Double.doubleToLongBits(
                other.getOffset())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getNumFiniteBuckets();
        hash = (37 * hash) + WIDTH_FIELD_NUMBER;
        hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
            Double.doubleToLongBits(getWidth()));
        hash = (37 * hash) + OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
            Double.doubleToLongBits(getOffset()));
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static Linear parseFrom(
          java.nio.ByteBuffer data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Linear parseFrom(
          java.nio.ByteBuffer data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Linear parseFrom(
          alluxio.shaded.client.com.google.protobuf.ByteString data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Linear parseFrom(
          alluxio.shaded.client.com.google.protobuf.ByteString data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Linear parseFrom(byte[] data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Linear parseFrom(
          byte[] data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Linear parseFrom(java.alluxio.shaded.client.io.InputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static Linear parseFrom(
          java.alluxio.shaded.client.io.InputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static Linear parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static Linear parseDelimitedFrom(
          java.alluxio.shaded.client.io.InputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static Linear parseFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static Linear parseFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(Linear prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @Override
      protected Builder newBuilderForType(
          BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Specifies a linear sequence of buckets that all have the same width
       * (except overflow and underflow). Each bucket represents a constant
       * absolute uncertainty on the specific value in the bucket.
       * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
       * following boundaries:
       *    Upper bound (0 &lt;= i &lt; N-1):     offset + (width * i).
       *    Lower bound (1 &lt;= i &lt; N):       offset + (width * (i - 1)).
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Linear}
       */
      public static final class Builder extends
          alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Linear)
          LinearOrBuilder {
        public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
        }

        @Override
        protected FieldAccessorTable
            internalGetFieldAccessorTable() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  Linear.class, Builder.class);
        }

        // Construct using alluxio.shaded.client.com.google.api.Distribution.BucketOptions.Linear.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @Override
        public Builder clear() {
          super.clear();
          numFiniteBuckets_ = 0;

          width_ = 0D;

          offset_ = 0D;

          return this;
        }

        @Override
        public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
        }

        @Override
        public Linear getDefaultInstanceForType() {
          return Linear.getDefaultInstance();
        }

        @Override
        public Linear build() {
          Linear result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @Override
        public Linear buildPartial() {
          Linear result = new Linear(this);
          result.numFiniteBuckets_ = numFiniteBuckets_;
          result.width_ = width_;
          result.offset_ = offset_;
          onBuilt();
          return result;
        }

        @Override
        public Builder clone() {
          return super.clone();
        }
        @Override
        public Builder setField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            Object value) {
          return super.setField(field, value);
        }
        @Override
        public Builder clearField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @Override
        public Builder clearOneof(
            alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @Override
        public Builder setRepeatedField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @Override
        public Builder addRepeatedField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            Object value) {
          return super.addRepeatedField(field, value);
        }
        @Override
        public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
          if (other instanceof Linear) {
            return mergeFrom((Linear)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(Linear other) {
          if (other == Linear.getDefaultInstance()) return this;
          if (other.getNumFiniteBuckets() != 0) {
            setNumFiniteBuckets(other.getNumFiniteBuckets());
          }
          if (other.getWidth() != 0D) {
            setWidth(other.getWidth());
          }
          if (other.getOffset() != 0D) {
            setOffset(other.getOffset());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @Override
        public final boolean isInitialized() {
          return true;
        }

        @Override
        public Builder mergeFrom(
            alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
            alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.alluxio.shaded.client.io.IOException {
          Linear parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (Linear) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numFiniteBuckets_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public int getNumFiniteBuckets() {
          return numFiniteBuckets_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder setNumFiniteBuckets(int value) {
          
          numFiniteBuckets_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder clearNumFiniteBuckets() {
          
          numFiniteBuckets_ = 0;
          onChanged();
          return this;
        }

        private double width_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         */
        public double getWidth() {
          return width_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         */
        public Builder setWidth(double value) {
          
          width_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         */
        public Builder clearWidth() {
          
          width_ = 0D;
          onChanged();
          return this;
        }

        private double offset_ ;
        /**
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         */
        public double getOffset() {
          return offset_;
        }
        /**
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         */
        public Builder setOffset(double value) {
          
          offset_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         */
        public Builder clearOffset() {
          
          offset_ = 0D;
          onChanged();
          return this;
        }
        @Override
        public final Builder setUnknownFields(
            final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(
            final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Linear)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Linear)
      private static final Linear DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new Linear();
      }

      public static Linear getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final alluxio.shaded.client.com.google.protobuf.Parser<Linear>
          PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Linear>() {
        @Override
        public Linear parsePartialFrom(
            alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
            alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
          return new Linear(input, extensionRegistry);
        }
      };

      public static alluxio.shaded.client.com.google.protobuf.Parser<Linear> parser() {
        return PARSER;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Parser<Linear> getParserForType() {
        return PARSER;
      }

      @Override
      public Linear getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ExponentialOrBuilder extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Exponential)
        alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      int getNumFiniteBuckets();

      /**
       * <pre>
       * Must be greater than 1.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      double getGrowthFactor();

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      double getScale();
    }
    /**
     * <pre>
     * Specifies an exponential sequence of buckets that have a width that is
     * proportional to the value of the lower bound. Each bucket represents a
     * constant relative uncertainty on a specific value in the bucket.
     * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
     * following boundaries:
     *    Upper bound (0 &lt;= i &lt; N-1):     scale * (growth_factor ^ i).
     *    Lower bound (1 &lt;= i &lt; N):       scale * (growth_factor ^ (i - 1)).
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Exponential}
     */
    public  static final class Exponential extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Exponential)
        ExponentialOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Exponential.newBuilder() to construct.
      private Exponential(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Exponential() {
      }

      @Override
      public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Exponential(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {

                numFiniteBuckets_ = input.readInt32();
                break;
              }
              case 17: {

                growthFactor_ = input.readDouble();
                break;
              }
              case 25: {

                scale_ = input.readDouble();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.alluxio.shaded.client.io.IOException e) {
          throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Exponential.class, Builder.class);
      }

      public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
      private int numFiniteBuckets_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }

      public static final int GROWTH_FACTOR_FIELD_NUMBER = 2;
      private double growthFactor_;
      /**
       * <pre>
       * Must be greater than 1.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      public double getGrowthFactor() {
        return growthFactor_;
      }

      public static final int SCALE_FIELD_NUMBER = 3;
      private double scale_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      public double getScale() {
        return scale_;
      }

      private byte memoizedIsInitialized = -1;
      @Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @Override
      public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                          throws java.alluxio.shaded.client.io.IOException {
        if (numFiniteBuckets_ != 0) {
          output.writeInt32(1, numFiniteBuckets_);
        }
        if (growthFactor_ != 0D) {
          output.writeDouble(2, growthFactor_);
        }
        if (scale_ != 0D) {
          output.writeDouble(3, scale_);
        }
        unknownFields.writeTo(output);
      }

      @Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numFiniteBuckets_ != 0) {
          size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteInt32Size(1, numFiniteBuckets_);
        }
        if (growthFactor_ != 0D) {
          size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteDoubleSize(2, growthFactor_);
        }
        if (scale_ != 0D) {
          size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteDoubleSize(3, scale_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @Override
      public boolean equals(final Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof Exponential)) {
          return super.equals(obj);
        }
        Exponential other = (Exponential) obj;

        if (getNumFiniteBuckets()
            != other.getNumFiniteBuckets()) return false;
        if (Double.doubleToLongBits(getGrowthFactor())
            != Double.doubleToLongBits(
                other.getGrowthFactor())) return false;
        if (Double.doubleToLongBits(getScale())
            != Double.doubleToLongBits(
                other.getScale())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getNumFiniteBuckets();
        hash = (37 * hash) + GROWTH_FACTOR_FIELD_NUMBER;
        hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
            Double.doubleToLongBits(getGrowthFactor()));
        hash = (37 * hash) + SCALE_FIELD_NUMBER;
        hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
            Double.doubleToLongBits(getScale()));
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static Exponential parseFrom(
          java.nio.ByteBuffer data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Exponential parseFrom(
          java.nio.ByteBuffer data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Exponential parseFrom(
          alluxio.shaded.client.com.google.protobuf.ByteString data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Exponential parseFrom(
          alluxio.shaded.client.com.google.protobuf.ByteString data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Exponential parseFrom(byte[] data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Exponential parseFrom(
          byte[] data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Exponential parseFrom(java.alluxio.shaded.client.io.InputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static Exponential parseFrom(
          java.alluxio.shaded.client.io.InputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static Exponential parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static Exponential parseDelimitedFrom(
          java.alluxio.shaded.client.io.InputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static Exponential parseFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static Exponential parseFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(Exponential prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @Override
      protected Builder newBuilderForType(
          BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Specifies an exponential sequence of buckets that have a width that is
       * proportional to the value of the lower bound. Each bucket represents a
       * constant relative uncertainty on a specific value in the bucket.
       * There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the
       * following boundaries:
       *    Upper bound (0 &lt;= i &lt; N-1):     scale * (growth_factor ^ i).
       *    Lower bound (1 &lt;= i &lt; N):       scale * (growth_factor ^ (i - 1)).
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Exponential}
       */
      public static final class Builder extends
          alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Exponential)
          ExponentialOrBuilder {
        public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
        }

        @Override
        protected FieldAccessorTable
            internalGetFieldAccessorTable() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  Exponential.class, Builder.class);
        }

        // Construct using alluxio.shaded.client.com.google.api.Distribution.BucketOptions.Exponential.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @Override
        public Builder clear() {
          super.clear();
          numFiniteBuckets_ = 0;

          growthFactor_ = 0D;

          scale_ = 0D;

          return this;
        }

        @Override
        public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
        }

        @Override
        public Exponential getDefaultInstanceForType() {
          return Exponential.getDefaultInstance();
        }

        @Override
        public Exponential build() {
          Exponential result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @Override
        public Exponential buildPartial() {
          Exponential result = new Exponential(this);
          result.numFiniteBuckets_ = numFiniteBuckets_;
          result.growthFactor_ = growthFactor_;
          result.scale_ = scale_;
          onBuilt();
          return result;
        }

        @Override
        public Builder clone() {
          return super.clone();
        }
        @Override
        public Builder setField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            Object value) {
          return super.setField(field, value);
        }
        @Override
        public Builder clearField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @Override
        public Builder clearOneof(
            alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @Override
        public Builder setRepeatedField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @Override
        public Builder addRepeatedField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            Object value) {
          return super.addRepeatedField(field, value);
        }
        @Override
        public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
          if (other instanceof Exponential) {
            return mergeFrom((Exponential)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(Exponential other) {
          if (other == Exponential.getDefaultInstance()) return this;
          if (other.getNumFiniteBuckets() != 0) {
            setNumFiniteBuckets(other.getNumFiniteBuckets());
          }
          if (other.getGrowthFactor() != 0D) {
            setGrowthFactor(other.getGrowthFactor());
          }
          if (other.getScale() != 0D) {
            setScale(other.getScale());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @Override
        public final boolean isInitialized() {
          return true;
        }

        @Override
        public Builder mergeFrom(
            alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
            alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.alluxio.shaded.client.io.IOException {
          Exponential parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (Exponential) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numFiniteBuckets_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public int getNumFiniteBuckets() {
          return numFiniteBuckets_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder setNumFiniteBuckets(int value) {
          
          numFiniteBuckets_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder clearNumFiniteBuckets() {
          
          numFiniteBuckets_ = 0;
          onChanged();
          return this;
        }

        private double growthFactor_ ;
        /**
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         */
        public double getGrowthFactor() {
          return growthFactor_;
        }
        /**
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         */
        public Builder setGrowthFactor(double value) {
          
          growthFactor_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         */
        public Builder clearGrowthFactor() {
          
          growthFactor_ = 0D;
          onChanged();
          return this;
        }

        private double scale_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         */
        public double getScale() {
          return scale_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         */
        public Builder setScale(double value) {
          
          scale_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         */
        public Builder clearScale() {
          
          scale_ = 0D;
          onChanged();
          return this;
        }
        @Override
        public final Builder setUnknownFields(
            final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(
            final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Exponential)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Exponential)
      private static final Exponential DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new Exponential();
      }

      public static Exponential getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final alluxio.shaded.client.com.google.protobuf.Parser<Exponential>
          PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Exponential>() {
        @Override
        public Exponential parsePartialFrom(
            alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
            alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
          return new Exponential(input, extensionRegistry);
        }
      };

      public static alluxio.shaded.client.com.google.protobuf.Parser<Exponential> parser() {
        return PARSER;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Parser<Exponential> getParserForType() {
        return PARSER;
      }

      @Override
      public Exponential getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ExplicitOrBuilder extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Explicit)
        alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      java.util.List<Double> getBoundsList();
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      int getBoundsCount();
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      double getBounds(int index);
    }
    /**
     * <pre>
     * Specifies a set of buckets with arbitrary widths.
     * There are `size(bounds) + 1` (= N) buckets. Bucket `i` has the following
     * boundaries:
     *    Upper bound (0 &lt;= i &lt; N-1):     bounds[i]
     *    Lower bound (1 &lt;= i &lt; N);       bounds[i - 1]
     * The `bounds` field must contain at least one element. If `bounds` has
     * only one element, then there are no finite buckets, and that single
     * element is the alluxio.shaded.client.com.on boundary of the overflow and underflow buckets.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Explicit}
     */
    public  static final class Explicit extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Explicit)
        ExplicitOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Explicit.newBuilder() to construct.
      private Explicit(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Explicit() {
        bounds_ = emptyDoubleList();
      }

      @Override
      public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Explicit(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  bounds_ = newDoubleList();
                  mutable_bitField0_ |= 0x00000001;
                }
                bounds_.addDouble(input.readDouble());
                break;
              }
              case 10: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                  bounds_ = newDoubleList();
                  mutable_bitField0_ |= 0x00000001;
                }
                while (input.getBytesUntilLimit() > 0) {
                  bounds_.addDouble(input.readDouble());
                }
                input.popLimit(limit);
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.alluxio.shaded.client.io.IOException e) {
          throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            bounds_.makeImmutable(); // C
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Explicit.class, Builder.class);
      }

      public static final int BOUNDS_FIELD_NUMBER = 1;
      private alluxio.shaded.client.com.google.protobuf.Internal.DoubleList bounds_;
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public java.util.List<Double>
          getBoundsList() {
        return bounds_;
      }
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public int getBoundsCount() {
        return bounds_.size();
      }
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public double getBounds(int index) {
        return bounds_.getDouble(index);
      }
      private int boundsMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;
      @Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @Override
      public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                          throws java.alluxio.shaded.client.io.IOException {
        getSerializedSize();
        if (getBoundsList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(boundsMemoizedSerializedSize);
        }
        for (int i = 0; i < bounds_.size(); i++) {
          output.writeDoubleNoTag(bounds_.getDouble(i));
        }
        unknownFields.writeTo(output);
      }

      @Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          dataSize = 8 * getBoundsList().size();
          size += dataSize;
          if (!getBoundsList().isEmpty()) {
            size += 1;
            size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
                .alluxio.shaded.client.com.uteInt32SizeNoTag(dataSize);
          }
          boundsMemoizedSerializedSize = dataSize;
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @Override
      public boolean equals(final Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof Explicit)) {
          return super.equals(obj);
        }
        Explicit other = (Explicit) obj;

        if (!getBoundsList()
            .equals(other.getBoundsList())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getBoundsCount() > 0) {
          hash = (37 * hash) + BOUNDS_FIELD_NUMBER;
          hash = (53 * hash) + getBoundsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static Explicit parseFrom(
          java.nio.ByteBuffer data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Explicit parseFrom(
          java.nio.ByteBuffer data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Explicit parseFrom(
          alluxio.shaded.client.com.google.protobuf.ByteString data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Explicit parseFrom(
          alluxio.shaded.client.com.google.protobuf.ByteString data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Explicit parseFrom(byte[] data)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static Explicit parseFrom(
          byte[] data,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static Explicit parseFrom(java.alluxio.shaded.client.io.InputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static Explicit parseFrom(
          java.alluxio.shaded.client.io.InputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static Explicit parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static Explicit parseDelimitedFrom(
          java.alluxio.shaded.client.io.InputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static Explicit parseFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static Explicit parseFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(Explicit prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @Override
      protected Builder newBuilderForType(
          BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Specifies a set of buckets with arbitrary widths.
       * There are `size(bounds) + 1` (= N) buckets. Bucket `i` has the following
       * boundaries:
       *    Upper bound (0 &lt;= i &lt; N-1):     bounds[i]
       *    Lower bound (1 &lt;= i &lt; N);       bounds[i - 1]
       * The `bounds` field must contain at least one element. If `bounds` has
       * only one element, then there are no finite buckets, and that single
       * element is the alluxio.shaded.client.com.on boundary of the overflow and underflow buckets.
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Explicit}
       */
      public static final class Builder extends
          alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Explicit)
          ExplicitOrBuilder {
        public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
        }

        @Override
        protected FieldAccessorTable
            internalGetFieldAccessorTable() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  Explicit.class, Builder.class);
        }

        // Construct using alluxio.shaded.client.com.google.api.Distribution.BucketOptions.Explicit.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @Override
        public Builder clear() {
          super.clear();
          bounds_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @Override
        public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
        }

        @Override
        public Explicit getDefaultInstanceForType() {
          return Explicit.getDefaultInstance();
        }

        @Override
        public Explicit build() {
          Explicit result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @Override
        public Explicit buildPartial() {
          Explicit result = new Explicit(this);
          int from_bitField0_ = bitField0_;
          if (((bitField0_ & 0x00000001) != 0)) {
            bounds_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.bounds_ = bounds_;
          onBuilt();
          return result;
        }

        @Override
        public Builder clone() {
          return super.clone();
        }
        @Override
        public Builder setField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            Object value) {
          return super.setField(field, value);
        }
        @Override
        public Builder clearField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @Override
        public Builder clearOneof(
            alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @Override
        public Builder setRepeatedField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @Override
        public Builder addRepeatedField(
            alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
            Object value) {
          return super.addRepeatedField(field, value);
        }
        @Override
        public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
          if (other instanceof Explicit) {
            return mergeFrom((Explicit)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(Explicit other) {
          if (other == Explicit.getDefaultInstance()) return this;
          if (!other.bounds_.isEmpty()) {
            if (bounds_.isEmpty()) {
              bounds_ = other.bounds_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBoundsIsMutable();
              bounds_.addAll(other.bounds_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @Override
        public final boolean isInitialized() {
          return true;
        }

        @Override
        public Builder mergeFrom(
            alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
            alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.alluxio.shaded.client.io.IOException {
          Explicit parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (Explicit) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private alluxio.shaded.client.com.google.protobuf.Internal.DoubleList bounds_ = emptyDoubleList();
        private void ensureBoundsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            bounds_ = mutableCopy(bounds_);
            bitField0_ |= 0x00000001;
           }
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public java.util.List<Double>
            getBoundsList() {
          return ((bitField0_ & 0x00000001) != 0) ?
                   java.util.Collections.unmodifiableList(bounds_) : bounds_;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public int getBoundsCount() {
          return bounds_.size();
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public double getBounds(int index) {
          return bounds_.getDouble(index);
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder setBounds(
            int index, double value) {
          ensureBoundsIsMutable();
          bounds_.setDouble(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder addBounds(double value) {
          ensureBoundsIsMutable();
          bounds_.addDouble(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder addAllBounds(
            Iterable<? extends Double> values) {
          ensureBoundsIsMutable();
          alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, bounds_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder clearBounds() {
          bounds_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        @Override
        public final Builder setUnknownFields(
            final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(
            final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Explicit)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Explicit)
      private static final Explicit DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new Explicit();
      }

      public static Explicit getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final alluxio.shaded.client.com.google.protobuf.Parser<Explicit>
          PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Explicit>() {
        @Override
        public Explicit parsePartialFrom(
            alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
            alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
          return new Explicit(input, extensionRegistry);
        }
      };

      public static alluxio.shaded.client.com.google.protobuf.Parser<Explicit> parser() {
        return PARSER;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Parser<Explicit> getParserForType() {
        return PARSER;
      }

      @Override
      public Explicit getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int optionsCase_ = 0;
    private Object options_;
    public enum OptionsCase
        implements alluxio.shaded.client.com.google.protobuf.Internal.EnumLite {
      LINEAR_BUCKETS(1),
      EXPONENTIAL_BUCKETS(2),
      EXPLICIT_BUCKETS(3),
      OPTIONS_NOT_SET(0);
      private final int value;
      private OptionsCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @Deprecated
      public static OptionsCase valueOf(int value) {
        return forNumber(value);
      }

      public static OptionsCase forNumber(int value) {
        switch (value) {
          case 1: return LINEAR_BUCKETS;
          case 2: return EXPONENTIAL_BUCKETS;
          case 3: return EXPLICIT_BUCKETS;
          case 0: return OPTIONS_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public OptionsCase
    getOptionsCase() {
      return OptionsCase.forNumber(
          optionsCase_);
    }

    public static final int LINEAR_BUCKETS_FIELD_NUMBER = 1;
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    public boolean hasLinearBuckets() {
      return optionsCase_ == 1;
    }
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    public Linear getLinearBuckets() {
      if (optionsCase_ == 1) {
         return (Linear) options_;
      }
      return Linear.getDefaultInstance();
    }
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    public LinearOrBuilder getLinearBucketsOrBuilder() {
      if (optionsCase_ == 1) {
         return (Linear) options_;
      }
      return Linear.getDefaultInstance();
    }

    public static final int EXPONENTIAL_BUCKETS_FIELD_NUMBER = 2;
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    public boolean hasExponentialBuckets() {
      return optionsCase_ == 2;
    }
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    public Exponential getExponentialBuckets() {
      if (optionsCase_ == 2) {
         return (Exponential) options_;
      }
      return Exponential.getDefaultInstance();
    }
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    public ExponentialOrBuilder getExponentialBucketsOrBuilder() {
      if (optionsCase_ == 2) {
         return (Exponential) options_;
      }
      return Exponential.getDefaultInstance();
    }

    public static final int EXPLICIT_BUCKETS_FIELD_NUMBER = 3;
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    public boolean hasExplicitBuckets() {
      return optionsCase_ == 3;
    }
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    public Explicit getExplicitBuckets() {
      if (optionsCase_ == 3) {
         return (Explicit) options_;
      }
      return Explicit.getDefaultInstance();
    }
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    public ExplicitOrBuilder getExplicitBucketsOrBuilder() {
      if (optionsCase_ == 3) {
         return (Explicit) options_;
      }
      return Explicit.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @Override
    public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                        throws java.alluxio.shaded.client.io.IOException {
      if (optionsCase_ == 1) {
        output.writeMessage(1, (Linear) options_);
      }
      if (optionsCase_ == 2) {
        output.writeMessage(2, (Exponential) options_);
      }
      if (optionsCase_ == 3) {
        output.writeMessage(3, (Explicit) options_);
      }
      unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (optionsCase_ == 1) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteMessageSize(1, (Linear) options_);
      }
      if (optionsCase_ == 2) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteMessageSize(2, (Exponential) options_);
      }
      if (optionsCase_ == 3) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteMessageSize(3, (Explicit) options_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @Override
    public boolean equals(final Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof BucketOptions)) {
        return super.equals(obj);
      }
      BucketOptions other = (BucketOptions) obj;

      if (!getOptionsCase().equals(other.getOptionsCase())) return false;
      switch (optionsCase_) {
        case 1:
          if (!getLinearBuckets()
              .equals(other.getLinearBuckets())) return false;
          break;
        case 2:
          if (!getExponentialBuckets()
              .equals(other.getExponentialBuckets())) return false;
          break;
        case 3:
          if (!getExplicitBuckets()
              .equals(other.getExplicitBuckets())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (optionsCase_) {
        case 1:
          hash = (37 * hash) + LINEAR_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getLinearBuckets().hashCode();
          break;
        case 2:
          hash = (37 * hash) + EXPONENTIAL_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExponentialBuckets().hashCode();
          break;
        case 3:
          hash = (37 * hash) + EXPLICIT_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExplicitBuckets().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static BucketOptions parseFrom(
        java.nio.ByteBuffer data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static BucketOptions parseFrom(
        java.nio.ByteBuffer data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static BucketOptions parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static BucketOptions parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static BucketOptions parseFrom(byte[] data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static BucketOptions parseFrom(
        byte[] data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static BucketOptions parseFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static BucketOptions parseFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static BucketOptions parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static BucketOptions parseDelimitedFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static BucketOptions parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static BucketOptions parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(BucketOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(
        BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * `BucketOptions` describes the bucket boundaries used to create a histogram
     * for the distribution. The buckets can be in a linear sequence, an
     * exponential sequence, or each bucket can be specified explicitly.
     * `BucketOptions` does not include the number of values in each bucket.
     * A bucket has an inclusive lower bound and exclusive upper bound for the
     * values that are counted for that bucket. The upper bound of a bucket must
     * be strictly greater than the lower bound. The sequence of N buckets for a
     * distribution consists of an underflow bucket (number 0), zero or more
     * finite buckets (number 1 through N - 2) and an overflow bucket (number N -
     * 1). The buckets are contiguous: the lower bound of bucket i (i &gt; 0) is the
     * same as the upper bound of bucket i - 1. The buckets span the whole range
     * of finite values: lower bound of the underflow bucket is -infinity and the
     * upper bound of the overflow bucket is +infinity. The finite buckets are
     * so-called because both bounds are finite.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions}
     */
    public static final class Builder extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions)
        BucketOptionsOrBuilder {
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                BucketOptions.class, Builder.class);
      }

      // Construct using alluxio.shaded.client.com.google.api.Distribution.BucketOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @Override
      public Builder clear() {
        super.clear();
        optionsCase_ = 0;
        options_ = null;
        return this;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_descriptor;
      }

      @Override
      public BucketOptions getDefaultInstanceForType() {
        return BucketOptions.getDefaultInstance();
      }

      @Override
      public BucketOptions build() {
        BucketOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @Override
      public BucketOptions buildPartial() {
        BucketOptions result = new BucketOptions(this);
        if (optionsCase_ == 1) {
          if (linearBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = linearBucketsBuilder_.build();
          }
        }
        if (optionsCase_ == 2) {
          if (exponentialBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = exponentialBucketsBuilder_.build();
          }
        }
        if (optionsCase_ == 3) {
          if (explicitBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = explicitBucketsBuilder_.build();
          }
        }
        result.optionsCase_ = optionsCase_;
        onBuilt();
        return result;
      }

      @Override
      public Builder clone() {
        return super.clone();
      }
      @Override
      public Builder setField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.setField(field, value);
      }
      @Override
      public Builder clearField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @Override
      public Builder clearOneof(
          alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @Override
      public Builder setRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @Override
      public Builder addRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.addRepeatedField(field, value);
      }
      @Override
      public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
        if (other instanceof BucketOptions) {
          return mergeFrom((BucketOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(BucketOptions other) {
        if (other == BucketOptions.getDefaultInstance()) return this;
        switch (other.getOptionsCase()) {
          case LINEAR_BUCKETS: {
            mergeLinearBuckets(other.getLinearBuckets());
            break;
          }
          case EXPONENTIAL_BUCKETS: {
            mergeExponentialBuckets(other.getExponentialBuckets());
            break;
          }
          case EXPLICIT_BUCKETS: {
            mergeExplicitBuckets(other.getExplicitBuckets());
            break;
          }
          case OPTIONS_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @Override
      public final boolean isInitialized() {
        return true;
      }

      @Override
      public Builder mergeFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        BucketOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (BucketOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int optionsCase_ = 0;
      private Object options_;
      public OptionsCase
          getOptionsCase() {
        return OptionsCase.forNumber(
            optionsCase_);
      }

      public Builder clearOptions() {
        optionsCase_ = 0;
        options_ = null;
        onChanged();
        return this;
      }


      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          Linear, Linear.Builder, LinearOrBuilder> linearBucketsBuilder_;
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public boolean hasLinearBuckets() {
        return optionsCase_ == 1;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Linear getLinearBuckets() {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1) {
            return (Linear) options_;
          }
          return Linear.getDefaultInstance();
        } else {
          if (optionsCase_ == 1) {
            return linearBucketsBuilder_.getMessage();
          }
          return Linear.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder setLinearBuckets(Linear value) {
        if (linearBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          linearBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder setLinearBuckets(
          Linear.Builder builderForValue) {
        if (linearBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          linearBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder mergeLinearBuckets(Linear value) {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1 &&
              options_ != Linear.getDefaultInstance()) {
            options_ = Linear.newBuilder((Linear) options_)
                .mergeFrom(value).buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 1) {
            linearBucketsBuilder_.mergeFrom(value);
          }
          linearBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder clearLinearBuckets() {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 1) {
            optionsCase_ = 0;
            options_ = null;
          }
          linearBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Linear.Builder getLinearBucketsBuilder() {
        return getLinearBucketsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public LinearOrBuilder getLinearBucketsOrBuilder() {
        if ((optionsCase_ == 1) && (linearBucketsBuilder_ != null)) {
          return linearBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 1) {
            return (Linear) options_;
          }
          return Linear.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          Linear, Linear.Builder, LinearOrBuilder>
          getLinearBucketsFieldBuilder() {
        if (linearBucketsBuilder_ == null) {
          if (!(optionsCase_ == 1)) {
            options_ = Linear.getDefaultInstance();
          }
          linearBucketsBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
              Linear, Linear.Builder, LinearOrBuilder>(
                  (Linear) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 1;
        onChanged();;
        return linearBucketsBuilder_;
      }

      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          Exponential, Exponential.Builder, ExponentialOrBuilder> exponentialBucketsBuilder_;
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public boolean hasExponentialBuckets() {
        return optionsCase_ == 2;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Exponential getExponentialBuckets() {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2) {
            return (Exponential) options_;
          }
          return Exponential.getDefaultInstance();
        } else {
          if (optionsCase_ == 2) {
            return exponentialBucketsBuilder_.getMessage();
          }
          return Exponential.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder setExponentialBuckets(Exponential value) {
        if (exponentialBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          exponentialBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder setExponentialBuckets(
          Exponential.Builder builderForValue) {
        if (exponentialBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          exponentialBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder mergeExponentialBuckets(Exponential value) {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2 &&
              options_ != Exponential.getDefaultInstance()) {
            options_ = Exponential.newBuilder((Exponential) options_)
                .mergeFrom(value).buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 2) {
            exponentialBucketsBuilder_.mergeFrom(value);
          }
          exponentialBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder clearExponentialBuckets() {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 2) {
            optionsCase_ = 0;
            options_ = null;
          }
          exponentialBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Exponential.Builder getExponentialBucketsBuilder() {
        return getExponentialBucketsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public ExponentialOrBuilder getExponentialBucketsOrBuilder() {
        if ((optionsCase_ == 2) && (exponentialBucketsBuilder_ != null)) {
          return exponentialBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 2) {
            return (Exponential) options_;
          }
          return Exponential.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          Exponential, Exponential.Builder, ExponentialOrBuilder>
          getExponentialBucketsFieldBuilder() {
        if (exponentialBucketsBuilder_ == null) {
          if (!(optionsCase_ == 2)) {
            options_ = Exponential.getDefaultInstance();
          }
          exponentialBucketsBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
              Exponential, Exponential.Builder, ExponentialOrBuilder>(
                  (Exponential) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 2;
        onChanged();;
        return exponentialBucketsBuilder_;
      }

      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          Explicit, Explicit.Builder, ExplicitOrBuilder> explicitBucketsBuilder_;
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public boolean hasExplicitBuckets() {
        return optionsCase_ == 3;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Explicit getExplicitBuckets() {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3) {
            return (Explicit) options_;
          }
          return Explicit.getDefaultInstance();
        } else {
          if (optionsCase_ == 3) {
            return explicitBucketsBuilder_.getMessage();
          }
          return Explicit.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder setExplicitBuckets(Explicit value) {
        if (explicitBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          explicitBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder setExplicitBuckets(
          Explicit.Builder builderForValue) {
        if (explicitBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          explicitBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder mergeExplicitBuckets(Explicit value) {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3 &&
              options_ != Explicit.getDefaultInstance()) {
            options_ = Explicit.newBuilder((Explicit) options_)
                .mergeFrom(value).buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 3) {
            explicitBucketsBuilder_.mergeFrom(value);
          }
          explicitBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder clearExplicitBuckets() {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 3) {
            optionsCase_ = 0;
            options_ = null;
          }
          explicitBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Explicit.Builder getExplicitBucketsBuilder() {
        return getExplicitBucketsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public ExplicitOrBuilder getExplicitBucketsOrBuilder() {
        if ((optionsCase_ == 3) && (explicitBucketsBuilder_ != null)) {
          return explicitBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 3) {
            return (Explicit) options_;
          }
          return Explicit.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          Explicit, Explicit.Builder, ExplicitOrBuilder>
          getExplicitBucketsFieldBuilder() {
        if (explicitBucketsBuilder_ == null) {
          if (!(optionsCase_ == 3)) {
            options_ = Explicit.getDefaultInstance();
          }
          explicitBucketsBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
              Explicit, Explicit.Builder, ExplicitOrBuilder>(
                  (Explicit) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 3;
        onChanged();;
        return explicitBucketsBuilder_;
      }
      @Override
      public final Builder setUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @Override
      public final Builder mergeUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions)
    private static final BucketOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new BucketOptions();
    }

    public static BucketOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final alluxio.shaded.client.com.google.protobuf.Parser<BucketOptions>
        PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<BucketOptions>() {
      @Override
      public BucketOptions parsePartialFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return new BucketOptions(input, extensionRegistry);
      }
    };

    public static alluxio.shaded.client.com.google.protobuf.Parser<BucketOptions> parser() {
      return PARSER;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Parser<BucketOptions> getParserForType() {
      return PARSER;
    }

    @Override
    public BucketOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExemplarOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.Exemplar)
      alluxio.shaded.client.com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Value of the exemplar point. This value determines to which bucket the
     * exemplar belongs.
     * </pre>
     *
     * <code>double value = 1;</code>
     */
    double getValue();

    /**
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    boolean hasTimestamp();
    /**
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    alluxio.shaded.client.com.google.protobuf.Timestamp getTimestamp();
    /**
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    alluxio.shaded.client.com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder();

    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    java.util.List<alluxio.shaded.client.com.google.protobuf.Any> 
        getAttachmentsList();
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    alluxio.shaded.client.com.google.protobuf.Any getAttachments(int index);
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    int getAttachmentsCount();
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    java.util.List<? extends alluxio.shaded.client.com.google.protobuf.AnyOrBuilder> 
        getAttachmentsOrBuilderList();
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    alluxio.shaded.client.com.google.protobuf.AnyOrBuilder getAttachmentsOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Exemplars are example points that may be used to annotate aggregated
   * distribution values. They are metadata that gives information about a
   * particular value added to a Distribution bucket, such as a trace ID that
   * was active when a value was added. They may contain further information,
   * such as a example values and timestamps, origin, etc.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.Exemplar}
   */
  public  static final class Exemplar extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.Exemplar)
      ExemplarOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Exemplar.newBuilder() to construct.
    private Exemplar(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Exemplar() {
      attachments_ = java.util.Collections.emptyList();
    }

    @Override
    public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Exemplar(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new NullPointerException();
      }
      int mutable_bitField0_ = 0;
      alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9: {

              value_ = input.readDouble();
              break;
            }
            case 18: {
              alluxio.shaded.client.com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (timestamp_ != null) {
                subBuilder = timestamp_.toBuilder();
              }
              timestamp_ = input.readMessage(alluxio.shaded.client.com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timestamp_);
                timestamp_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                attachments_ = new java.util.ArrayList<alluxio.shaded.client.com.google.protobuf.Any>();
                mutable_bitField0_ |= 0x00000004;
              }
              attachments_.add(
                  input.readMessage(alluxio.shaded.client.com.google.protobuf.Any.parser(), extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.alluxio.shaded.client.io.IOException e) {
        throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          attachments_ = java.util.Collections.unmodifiableList(attachments_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Exemplar_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Exemplar_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Exemplar.class, Builder.class);
    }

    private int bitField0_;
    public static final int VALUE_FIELD_NUMBER = 1;
    private double value_;
    /**
     * <pre>
     * Value of the exemplar point. This value determines to which bucket the
     * exemplar belongs.
     * </pre>
     *
     * <code>double value = 1;</code>
     */
    public double getValue() {
      return value_;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 2;
    private alluxio.shaded.client.com.google.protobuf.Timestamp timestamp_;
    /**
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    public boolean hasTimestamp() {
      return timestamp_ != null;
    }
    /**
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.Timestamp getTimestamp() {
      return timestamp_ == null ? alluxio.shaded.client.com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
    }
    /**
     * <pre>
     * The observation (sampling) time of the above value.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 2;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      return getTimestamp();
    }

    public static final int ATTACHMENTS_FIELD_NUMBER = 3;
    private java.util.List<alluxio.shaded.client.com.google.protobuf.Any> attachments_;
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    public java.util.List<alluxio.shaded.client.com.google.protobuf.Any> getAttachmentsList() {
      return attachments_;
    }
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    public java.util.List<? extends alluxio.shaded.client.com.google.protobuf.AnyOrBuilder> 
        getAttachmentsOrBuilderList() {
      return attachments_;
    }
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    public int getAttachmentsCount() {
      return attachments_.size();
    }
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.Any getAttachments(int index) {
      return attachments_.get(index);
    }
    /**
     * <pre>
     * Contextual information about the example value. Examples are:
     *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
     *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
     *   Labels dropped during aggregation:
     *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
     * There may be only a single attachment of any given message type in a
     * single exemplar, and this is enforced by the system.
     * </pre>
     *
     * <code>repeated .google.protobuf.Any attachments = 3;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.AnyOrBuilder getAttachmentsOrBuilder(
        int index) {
      return attachments_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @Override
    public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                        throws java.alluxio.shaded.client.io.IOException {
      if (value_ != 0D) {
        output.writeDouble(1, value_);
      }
      if (timestamp_ != null) {
        output.writeMessage(2, getTimestamp());
      }
      for (int i = 0; i < attachments_.size(); i++) {
        output.writeMessage(3, attachments_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (value_ != 0D) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteDoubleSize(1, value_);
      }
      if (timestamp_ != null) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteMessageSize(2, getTimestamp());
      }
      for (int i = 0; i < attachments_.size(); i++) {
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteMessageSize(3, attachments_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @Override
    public boolean equals(final Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof Exemplar)) {
        return super.equals(obj);
      }
      Exemplar other = (Exemplar) obj;

      if (Double.doubleToLongBits(getValue())
          != Double.doubleToLongBits(
              other.getValue())) return false;
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (!getTimestamp()
            .equals(other.getTimestamp())) return false;
      }
      if (!getAttachmentsList()
          .equals(other.getAttachmentsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
          Double.doubleToLongBits(getValue()));
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getTimestamp().hashCode();
      }
      if (getAttachmentsCount() > 0) {
        hash = (37 * hash) + ATTACHMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getAttachmentsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static Exemplar parseFrom(
        java.nio.ByteBuffer data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Exemplar parseFrom(
        java.nio.ByteBuffer data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Exemplar parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Exemplar parseFrom(
        alluxio.shaded.client.com.google.protobuf.ByteString data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Exemplar parseFrom(byte[] data)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Exemplar parseFrom(
        byte[] data,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Exemplar parseFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static Exemplar parseFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static Exemplar parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static Exemplar parseDelimitedFrom(
        java.alluxio.shaded.client.io.InputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static Exemplar parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static Exemplar parseFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(Exemplar prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(
        BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Exemplars are example points that may be used to annotate aggregated
     * distribution values. They are metadata that gives information about a
     * particular value added to a Distribution bucket, such as a trace ID that
     * was active when a value was added. They may contain further information,
     * such as a example values and timestamps, origin, etc.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.Exemplar}
     */
    public static final class Builder extends
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.Exemplar)
        ExemplarOrBuilder {
      public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Exemplar_descriptor;
      }

      @Override
      protected FieldAccessorTable
          internalGetFieldAccessorTable() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Exemplar_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Exemplar.class, Builder.class);
      }

      // Construct using alluxio.shaded.client.com.google.api.Distribution.Exemplar.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getAttachmentsFieldBuilder();
        }
      }
      @Override
      public Builder clear() {
        super.clear();
        value_ = 0D;

        if (timestampBuilder_ == null) {
          timestamp_ = null;
        } else {
          timestamp_ = null;
          timestampBuilder_ = null;
        }
        if (attachmentsBuilder_ == null) {
          attachments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          attachmentsBuilder_.clear();
        }
        return this;
      }

      @Override
      public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_Exemplar_descriptor;
      }

      @Override
      public Exemplar getDefaultInstanceForType() {
        return Exemplar.getDefaultInstance();
      }

      @Override
      public Exemplar build() {
        Exemplar result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @Override
      public Exemplar buildPartial() {
        Exemplar result = new Exemplar(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.value_ = value_;
        if (timestampBuilder_ == null) {
          result.timestamp_ = timestamp_;
        } else {
          result.timestamp_ = timestampBuilder_.build();
        }
        if (attachmentsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            attachments_ = java.util.Collections.unmodifiableList(attachments_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.attachments_ = attachments_;
        } else {
          result.attachments_ = attachmentsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @Override
      public Builder clone() {
        return super.clone();
      }
      @Override
      public Builder setField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.setField(field, value);
      }
      @Override
      public Builder clearField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @Override
      public Builder clearOneof(
          alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @Override
      public Builder setRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @Override
      public Builder addRepeatedField(
          alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return super.addRepeatedField(field, value);
      }
      @Override
      public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
        if (other instanceof Exemplar) {
          return mergeFrom((Exemplar)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Exemplar other) {
        if (other == Exemplar.getDefaultInstance()) return this;
        if (other.getValue() != 0D) {
          setValue(other.getValue());
        }
        if (other.hasTimestamp()) {
          mergeTimestamp(other.getTimestamp());
        }
        if (attachmentsBuilder_ == null) {
          if (!other.attachments_.isEmpty()) {
            if (attachments_.isEmpty()) {
              attachments_ = other.attachments_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureAttachmentsIsMutable();
              attachments_.addAll(other.attachments_);
            }
            onChanged();
          }
        } else {
          if (!other.attachments_.isEmpty()) {
            if (attachmentsBuilder_.isEmpty()) {
              attachmentsBuilder_.dispose();
              attachmentsBuilder_ = null;
              attachments_ = other.attachments_;
              bitField0_ = (bitField0_ & ~0x00000004);
              attachmentsBuilder_ = 
                alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getAttachmentsFieldBuilder() : null;
            } else {
              attachmentsBuilder_.addAllMessages(other.attachments_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @Override
      public final boolean isInitialized() {
        return true;
      }

      @Override
      public Builder mergeFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.alluxio.shaded.client.io.IOException {
        Exemplar parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Exemplar) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private double value_ ;
      /**
       * <pre>
       * Value of the exemplar point. This value determines to which bucket the
       * exemplar belongs.
       * </pre>
       *
       * <code>double value = 1;</code>
       */
      public double getValue() {
        return value_;
      }
      /**
       * <pre>
       * Value of the exemplar point. This value determines to which bucket the
       * exemplar belongs.
       * </pre>
       *
       * <code>double value = 1;</code>
       */
      public Builder setValue(double value) {
        
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Value of the exemplar point. This value determines to which bucket the
       * exemplar belongs.
       * </pre>
       *
       * <code>double value = 1;</code>
       */
      public Builder clearValue() {
        
        value_ = 0D;
        onChanged();
        return this;
      }

      private alluxio.shaded.client.com.google.protobuf.Timestamp timestamp_;
      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          alluxio.shaded.client.com.google.protobuf.Timestamp, alluxio.shaded.client.com.google.protobuf.Timestamp.Builder, alluxio.shaded.client.com.google.protobuf.TimestampOrBuilder> timestampBuilder_;
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public boolean hasTimestamp() {
        return timestampBuilder_ != null || timestamp_ != null;
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.Timestamp getTimestamp() {
        if (timestampBuilder_ == null) {
          return timestamp_ == null ? alluxio.shaded.client.com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
        } else {
          return timestampBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder setTimestamp(alluxio.shaded.client.com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestamp_ = value;
          onChanged();
        } else {
          timestampBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder setTimestamp(
          alluxio.shaded.client.com.google.protobuf.Timestamp.Builder builderForValue) {
        if (timestampBuilder_ == null) {
          timestamp_ = builderForValue.build();
          onChanged();
        } else {
          timestampBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder mergeTimestamp(alluxio.shaded.client.com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (timestamp_ != null) {
            timestamp_ =
              alluxio.shaded.client.com.google.protobuf.Timestamp.newBuilder(timestamp_).mergeFrom(value).buildPartial();
          } else {
            timestamp_ = value;
          }
          onChanged();
        } else {
          timestampBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public Builder clearTimestamp() {
        if (timestampBuilder_ == null) {
          timestamp_ = null;
          onChanged();
        } else {
          timestamp_ = null;
          timestampBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.Timestamp.Builder getTimestampBuilder() {
        
        onChanged();
        return getTimestampFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
        if (timestampBuilder_ != null) {
          return timestampBuilder_.getMessageOrBuilder();
        } else {
          return timestamp_ == null ?
              alluxio.shaded.client.com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
        }
      }
      /**
       * <pre>
       * The observation (sampling) time of the above value.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 2;</code>
       */
      private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
          alluxio.shaded.client.com.google.protobuf.Timestamp, alluxio.shaded.client.com.google.protobuf.Timestamp.Builder, alluxio.shaded.client.com.google.protobuf.TimestampOrBuilder> 
          getTimestampFieldBuilder() {
        if (timestampBuilder_ == null) {
          timestampBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
              alluxio.shaded.client.com.google.protobuf.Timestamp, alluxio.shaded.client.com.google.protobuf.Timestamp.Builder, alluxio.shaded.client.com.google.protobuf.TimestampOrBuilder>(
                  getTimestamp(),
                  getParentForChildren(),
                  isClean());
          timestamp_ = null;
        }
        return timestampBuilder_;
      }

      private java.util.List<alluxio.shaded.client.com.google.protobuf.Any> attachments_ =
        java.util.Collections.emptyList();
      private void ensureAttachmentsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          attachments_ = new java.util.ArrayList<alluxio.shaded.client.com.google.protobuf.Any>(attachments_);
          bitField0_ |= 0x00000004;
         }
      }

      private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
          alluxio.shaded.client.com.google.protobuf.Any, alluxio.shaded.client.com.google.protobuf.Any.Builder, alluxio.shaded.client.com.google.protobuf.AnyOrBuilder> attachmentsBuilder_;

      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public java.util.List<alluxio.shaded.client.com.google.protobuf.Any> getAttachmentsList() {
        if (attachmentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(attachments_);
        } else {
          return attachmentsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public int getAttachmentsCount() {
        if (attachmentsBuilder_ == null) {
          return attachments_.size();
        } else {
          return attachmentsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.Any getAttachments(int index) {
        if (attachmentsBuilder_ == null) {
          return attachments_.get(index);
        } else {
          return attachmentsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder setAttachments(
          int index, alluxio.shaded.client.com.google.protobuf.Any value) {
        if (attachmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentsIsMutable();
          attachments_.set(index, value);
          onChanged();
        } else {
          attachmentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder setAttachments(
          int index, alluxio.shaded.client.com.google.protobuf.Any.Builder builderForValue) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.set(index, builderForValue.build());
          onChanged();
        } else {
          attachmentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(alluxio.shaded.client.com.google.protobuf.Any value) {
        if (attachmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentsIsMutable();
          attachments_.add(value);
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(
          int index, alluxio.shaded.client.com.google.protobuf.Any value) {
        if (attachmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentsIsMutable();
          attachments_.add(index, value);
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(
          alluxio.shaded.client.com.google.protobuf.Any.Builder builderForValue) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.add(builderForValue.build());
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAttachments(
          int index, alluxio.shaded.client.com.google.protobuf.Any.Builder builderForValue) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.add(index, builderForValue.build());
          onChanged();
        } else {
          attachmentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder addAllAttachments(
          Iterable<? extends alluxio.shaded.client.com.google.protobuf.Any> values) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, attachments_);
          onChanged();
        } else {
          attachmentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder clearAttachments() {
        if (attachmentsBuilder_ == null) {
          attachments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          attachmentsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public Builder removeAttachments(int index) {
        if (attachmentsBuilder_ == null) {
          ensureAttachmentsIsMutable();
          attachments_.remove(index);
          onChanged();
        } else {
          attachmentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.Any.Builder getAttachmentsBuilder(
          int index) {
        return getAttachmentsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.AnyOrBuilder getAttachmentsOrBuilder(
          int index) {
        if (attachmentsBuilder_ == null) {
          return attachments_.get(index);  } else {
          return attachmentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public java.util.List<? extends alluxio.shaded.client.com.google.protobuf.AnyOrBuilder> 
           getAttachmentsOrBuilderList() {
        if (attachmentsBuilder_ != null) {
          return attachmentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(attachments_);
        }
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.Any.Builder addAttachmentsBuilder() {
        return getAttachmentsFieldBuilder().addBuilder(
            alluxio.shaded.client.com.google.protobuf.Any.getDefaultInstance());
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public alluxio.shaded.client.com.google.protobuf.Any.Builder addAttachmentsBuilder(
          int index) {
        return getAttachmentsFieldBuilder().addBuilder(
            index, alluxio.shaded.client.com.google.protobuf.Any.getDefaultInstance());
      }
      /**
       * <pre>
       * Contextual information about the example value. Examples are:
       *   Trace: type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.SpanContext
       *   Literal string: type.googleapis.alluxio.shaded.client.com.google.protobuf.StringValue
       *   Labels dropped during aggregation:
       *     type.googleapis.alluxio.shaded.client.com.google.monitoring.v3.DroppedLabels
       * There may be only a single attachment of any given message type in a
       * single exemplar, and this is enforced by the system.
       * </pre>
       *
       * <code>repeated .google.protobuf.Any attachments = 3;</code>
       */
      public java.util.List<alluxio.shaded.client.com.google.protobuf.Any.Builder> 
           getAttachmentsBuilderList() {
        return getAttachmentsFieldBuilder().getBuilderList();
      }
      private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
          alluxio.shaded.client.com.google.protobuf.Any, alluxio.shaded.client.com.google.protobuf.Any.Builder, alluxio.shaded.client.com.google.protobuf.AnyOrBuilder> 
          getAttachmentsFieldBuilder() {
        if (attachmentsBuilder_ == null) {
          attachmentsBuilder_ = new alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
              alluxio.shaded.client.com.google.protobuf.Any, alluxio.shaded.client.com.google.protobuf.Any.Builder, alluxio.shaded.client.com.google.protobuf.AnyOrBuilder>(
                  attachments_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          attachments_ = null;
        }
        return attachmentsBuilder_;
      }
      @Override
      public final Builder setUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @Override
      public final Builder mergeUnknownFields(
          final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.api.Distribution.Exemplar)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.Exemplar)
    private static final Exemplar DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new Exemplar();
    }

    public static Exemplar getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final alluxio.shaded.client.com.google.protobuf.Parser<Exemplar>
        PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Exemplar>() {
      @Override
      public Exemplar parsePartialFrom(
          alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
          alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return new Exemplar(input, extensionRegistry);
      }
    };

    public static alluxio.shaded.client.com.google.protobuf.Parser<Exemplar> parser() {
      return PARSER;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Parser<Exemplar> getParserForType() {
      return PARSER;
    }

    @Override
    public Exemplar getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  public static final int COUNT_FIELD_NUMBER = 1;
  private long count_;
  /**
   * <pre>
   * The number of values in the population. Must be non-negative. This value
   * must equal the sum of the values in `bucket_counts` if a histogram is
   * provided.
   * </pre>
   *
   * <code>int64 count = 1;</code>
   */
  public long getCount() {
    return count_;
  }

  public static final int MEAN_FIELD_NUMBER = 2;
  private double mean_;
  /**
   * <pre>
   * The arithmetic mean of the values in the population. If `count` is zero
   * then this field must be zero.
   * </pre>
   *
   * <code>double mean = 2;</code>
   */
  public double getMean() {
    return mean_;
  }

  public static final int SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER = 3;
  private double sumOfSquaredDeviation_;
  /**
   * <pre>
   * The sum of squared deviations from the mean of the values in the
   * population. For values x_i this is:
   *     Sum[i=1..n]((x_i - mean)^2)
   * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
   * describes Welford's method for accumulating this sum in one pass.
   * If `count` is zero then this field must be zero.
   * </pre>
   *
   * <code>double sum_of_squared_deviation = 3;</code>
   */
  public double getSumOfSquaredDeviation() {
    return sumOfSquaredDeviation_;
  }

  public static final int RANGE_FIELD_NUMBER = 4;
  private Range range_;
  /**
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  public boolean hasRange() {
    return range_ != null;
  }
  /**
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  public Range getRange() {
    return range_ == null ? Range.getDefaultInstance() : range_;
  }
  /**
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  public RangeOrBuilder getRangeOrBuilder() {
    return getRange();
  }

  public static final int BUCKET_OPTIONS_FIELD_NUMBER = 6;
  private BucketOptions bucketOptions_;
  /**
   * <pre>
   * Defines the histogram bucket boundaries. If the distribution does not
   * contain a histogram, then omit this field.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  public boolean hasBucketOptions() {
    return bucketOptions_ != null;
  }
  /**
   * <pre>
   * Defines the histogram bucket boundaries. If the distribution does not
   * contain a histogram, then omit this field.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  public BucketOptions getBucketOptions() {
    return bucketOptions_ == null ? BucketOptions.getDefaultInstance() : bucketOptions_;
  }
  /**
   * <pre>
   * Defines the histogram bucket boundaries. If the distribution does not
   * contain a histogram, then omit this field.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  public BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
    return getBucketOptions();
  }

  public static final int BUCKET_COUNTS_FIELD_NUMBER = 7;
  private alluxio.shaded.client.com.google.protobuf.Internal.LongList bucketCounts_;
  /**
   * <pre>
   * The number of values in each bucket of the histogram, as described in
   * `bucket_options`. If the distribution does not have a histogram, then omit
   * this field. If there is a histogram, then the sum of the values in
   * `bucket_counts` must equal the value in the `count` field of the
   * distribution.
   * If present, `bucket_counts` should contain N values, where N is the number
   * of buckets specified in `bucket_options`. If you supply fewer than N
   * values, the remaining values are assumed to be 0.
   * The order of the values in `bucket_counts` follows the bucket numbering
   * schemes described for the three bucket types. The first value must be the
   * count for the underflow bucket (number 0). The next N-2 values are the
   * counts for the finite buckets (number 1 through N-2). The N'th value in
   * `bucket_counts` is the count for the overflow bucket (number N-1).
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   */
  public java.util.List<Long>
      getBucketCountsList() {
    return bucketCounts_;
  }
  /**
   * <pre>
   * The number of values in each bucket of the histogram, as described in
   * `bucket_options`. If the distribution does not have a histogram, then omit
   * this field. If there is a histogram, then the sum of the values in
   * `bucket_counts` must equal the value in the `count` field of the
   * distribution.
   * If present, `bucket_counts` should contain N values, where N is the number
   * of buckets specified in `bucket_options`. If you supply fewer than N
   * values, the remaining values are assumed to be 0.
   * The order of the values in `bucket_counts` follows the bucket numbering
   * schemes described for the three bucket types. The first value must be the
   * count for the underflow bucket (number 0). The next N-2 values are the
   * counts for the finite buckets (number 1 through N-2). The N'th value in
   * `bucket_counts` is the count for the overflow bucket (number N-1).
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   */
  public int getBucketCountsCount() {
    return bucketCounts_.size();
  }
  /**
   * <pre>
   * The number of values in each bucket of the histogram, as described in
   * `bucket_options`. If the distribution does not have a histogram, then omit
   * this field. If there is a histogram, then the sum of the values in
   * `bucket_counts` must equal the value in the `count` field of the
   * distribution.
   * If present, `bucket_counts` should contain N values, where N is the number
   * of buckets specified in `bucket_options`. If you supply fewer than N
   * values, the remaining values are assumed to be 0.
   * The order of the values in `bucket_counts` follows the bucket numbering
   * schemes described for the three bucket types. The first value must be the
   * count for the underflow bucket (number 0). The next N-2 values are the
   * counts for the finite buckets (number 1 through N-2). The N'th value in
   * `bucket_counts` is the count for the overflow bucket (number N-1).
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   */
  public long getBucketCounts(int index) {
    return bucketCounts_.getLong(index);
  }
  private int bucketCountsMemoizedSerializedSize = -1;

  public static final int EXEMPLARS_FIELD_NUMBER = 10;
  private java.util.List<Exemplar> exemplars_;
  /**
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  public java.util.List<Exemplar> getExemplarsList() {
    return exemplars_;
  }
  /**
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  public java.util.List<? extends ExemplarOrBuilder>
      getExemplarsOrBuilderList() {
    return exemplars_;
  }
  /**
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  public int getExemplarsCount() {
    return exemplars_.size();
  }
  /**
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  public Exemplar getExemplars(int index) {
    return exemplars_.get(index);
  }
  /**
   * <pre>
   * Must be in increasing order of `value` field.
   * </pre>
   *
   * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
   */
  public ExemplarOrBuilder getExemplarsOrBuilder(
      int index) {
    return exemplars_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @Override
  public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                      throws java.alluxio.shaded.client.io.IOException {
    getSerializedSize();
    if (count_ != 0L) {
      output.writeInt64(1, count_);
    }
    if (mean_ != 0D) {
      output.writeDouble(2, mean_);
    }
    if (sumOfSquaredDeviation_ != 0D) {
      output.writeDouble(3, sumOfSquaredDeviation_);
    }
    if (range_ != null) {
      output.writeMessage(4, getRange());
    }
    if (bucketOptions_ != null) {
      output.writeMessage(6, getBucketOptions());
    }
    if (getBucketCountsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(bucketCountsMemoizedSerializedSize);
    }
    for (int i = 0; i < bucketCounts_.size(); i++) {
      output.writeInt64NoTag(bucketCounts_.getLong(i));
    }
    for (int i = 0; i < exemplars_.size(); i++) {
      output.writeMessage(10, exemplars_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (count_ != 0L) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteInt64Size(1, count_);
    }
    if (mean_ != 0D) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteDoubleSize(2, mean_);
    }
    if (sumOfSquaredDeviation_ != 0D) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteDoubleSize(3, sumOfSquaredDeviation_);
    }
    if (range_ != null) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(4, getRange());
    }
    if (bucketOptions_ != null) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(6, getBucketOptions());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < bucketCounts_.size(); i++) {
        dataSize += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
          .alluxio.shaded.client.com.uteInt64SizeNoTag(bucketCounts_.getLong(i));
      }
      size += dataSize;
      if (!getBucketCountsList().isEmpty()) {
        size += 1;
        size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
            .alluxio.shaded.client.com.uteInt32SizeNoTag(dataSize);
      }
      bucketCountsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < exemplars_.size(); i++) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(10, exemplars_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof Distribution)) {
      return super.equals(obj);
    }
    Distribution other = (Distribution) obj;

    if (getCount()
        != other.getCount()) return false;
    if (Double.doubleToLongBits(getMean())
        != Double.doubleToLongBits(
            other.getMean())) return false;
    if (Double.doubleToLongBits(getSumOfSquaredDeviation())
        != Double.doubleToLongBits(
            other.getSumOfSquaredDeviation())) return false;
    if (hasRange() != other.hasRange()) return false;
    if (hasRange()) {
      if (!getRange()
          .equals(other.getRange())) return false;
    }
    if (hasBucketOptions() != other.hasBucketOptions()) return false;
    if (hasBucketOptions()) {
      if (!getBucketOptions()
          .equals(other.getBucketOptions())) return false;
    }
    if (!getBucketCountsList()
        .equals(other.getBucketCountsList())) return false;
    if (!getExemplarsList()
        .equals(other.getExemplarsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COUNT_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        getCount());
    hash = (37 * hash) + MEAN_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        Double.doubleToLongBits(getMean()));
    hash = (37 * hash) + SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        Double.doubleToLongBits(getSumOfSquaredDeviation()));
    if (hasRange()) {
      hash = (37 * hash) + RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getRange().hashCode();
    }
    if (hasBucketOptions()) {
      hash = (37 * hash) + BUCKET_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketOptions().hashCode();
    }
    if (getBucketCountsCount() > 0) {
      hash = (37 * hash) + BUCKET_COUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketCountsList().hashCode();
    }
    if (getExemplarsCount() > 0) {
      hash = (37 * hash) + EXEMPLARS_FIELD_NUMBER;
      hash = (53 * hash) + getExemplarsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static Distribution parseFrom(
      java.nio.ByteBuffer data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Distribution parseFrom(
      java.nio.ByteBuffer data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Distribution parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Distribution parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Distribution parseFrom(byte[] data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Distribution parseFrom(
      byte[] data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Distribution parseFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Distribution parseFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static Distribution parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static Distribution parseDelimitedFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static Distribution parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Distribution parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(Distribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @Override
  protected Builder newBuilderForType(
      BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * `Distribution` contains summary statistics for a population of values. It
   * optionally contains a histogram representing the distribution of those values
   * across a set of buckets.
   * The summary statistics are the count, mean, sum of the squared deviation from
   * the mean, the minimum, and the maximum of the set of population of values.
   * The histogram is based on a sequence of buckets and gives a count of values
   * that fall into each bucket. The boundaries of the buckets are given either
   * explicitly or by formulas for buckets of fixed or exponentially increasing
   * widths.
   * Although it is not forbidden, it is generally a bad idea to include
   * non-finite values (infinities or NaNs) in the population of values, as this
   * will render the `mean` and `sum_of_squared_deviation` fields meaningless.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution}
   */
  public static final class Builder extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.Distribution)
      alluxio.shaded.client.com.google.api.DistributionOrBuilder {
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Distribution.class, Builder.class);
    }

    // Construct using alluxio.shaded.client.com.google.api.Distribution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getExemplarsFieldBuilder();
      }
    }
    @Override
    public Builder clear() {
      super.clear();
      count_ = 0L;

      mean_ = 0D;

      sumOfSquaredDeviation_ = 0D;

      if (rangeBuilder_ == null) {
        range_ = null;
      } else {
        range_ = null;
        rangeBuilder_ = null;
      }
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }
      bucketCounts_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000020);
      if (exemplarsBuilder_ == null) {
        exemplars_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
      } else {
        exemplarsBuilder_.clear();
      }
      return this;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return alluxio.shaded.client.com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
    }

    @Override
    public Distribution getDefaultInstanceForType() {
      return Distribution.getDefaultInstance();
    }

    @Override
    public Distribution build() {
      Distribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @Override
    public Distribution buildPartial() {
      Distribution result = new Distribution(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.count_ = count_;
      result.mean_ = mean_;
      result.sumOfSquaredDeviation_ = sumOfSquaredDeviation_;
      if (rangeBuilder_ == null) {
        result.range_ = range_;
      } else {
        result.range_ = rangeBuilder_.build();
      }
      if (bucketOptionsBuilder_ == null) {
        result.bucketOptions_ = bucketOptions_;
      } else {
        result.bucketOptions_ = bucketOptionsBuilder_.build();
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        bucketCounts_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.bucketCounts_ = bucketCounts_;
      if (exemplarsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          exemplars_ = java.util.Collections.unmodifiableList(exemplars_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.exemplars_ = exemplars_;
      } else {
        result.exemplars_ = exemplarsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @Override
    public Builder clone() {
      return super.clone();
    }
    @Override
    public Builder setField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.setField(field, value);
    }
    @Override
    public Builder clearField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @Override
    public Builder clearOneof(
        alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @Override
    public Builder setRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @Override
    public Builder addRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.addRepeatedField(field, value);
    }
    @Override
    public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
      if (other instanceof Distribution) {
        return mergeFrom((Distribution)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(Distribution other) {
      if (other == Distribution.getDefaultInstance()) return this;
      if (other.getCount() != 0L) {
        setCount(other.getCount());
      }
      if (other.getMean() != 0D) {
        setMean(other.getMean());
      }
      if (other.getSumOfSquaredDeviation() != 0D) {
        setSumOfSquaredDeviation(other.getSumOfSquaredDeviation());
      }
      if (other.hasRange()) {
        mergeRange(other.getRange());
      }
      if (other.hasBucketOptions()) {
        mergeBucketOptions(other.getBucketOptions());
      }
      if (!other.bucketCounts_.isEmpty()) {
        if (bucketCounts_.isEmpty()) {
          bucketCounts_ = other.bucketCounts_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureBucketCountsIsMutable();
          bucketCounts_.addAll(other.bucketCounts_);
        }
        onChanged();
      }
      if (exemplarsBuilder_ == null) {
        if (!other.exemplars_.isEmpty()) {
          if (exemplars_.isEmpty()) {
            exemplars_ = other.exemplars_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureExemplarsIsMutable();
            exemplars_.addAll(other.exemplars_);
          }
          onChanged();
        }
      } else {
        if (!other.exemplars_.isEmpty()) {
          if (exemplarsBuilder_.isEmpty()) {
            exemplarsBuilder_.dispose();
            exemplarsBuilder_ = null;
            exemplars_ = other.exemplars_;
            bitField0_ = (bitField0_ & ~0x00000040);
            exemplarsBuilder_ = 
              alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getExemplarsFieldBuilder() : null;
          } else {
            exemplarsBuilder_.addAllMessages(other.exemplars_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @Override
    public final boolean isInitialized() {
      return true;
    }

    @Override
    public Builder mergeFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      Distribution parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (Distribution) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private long count_ ;
    /**
     * <pre>
     * The number of values in the population. Must be non-negative. This value
     * must equal the sum of the values in `bucket_counts` if a histogram is
     * provided.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public long getCount() {
      return count_;
    }
    /**
     * <pre>
     * The number of values in the population. Must be non-negative. This value
     * must equal the sum of the values in `bucket_counts` if a histogram is
     * provided.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public Builder setCount(long value) {
      
      count_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of values in the population. Must be non-negative. This value
     * must equal the sum of the values in `bucket_counts` if a histogram is
     * provided.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public Builder clearCount() {
      
      count_ = 0L;
      onChanged();
      return this;
    }

    private double mean_ ;
    /**
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public double getMean() {
      return mean_;
    }
    /**
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public Builder setMean(double value) {
      
      mean_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public Builder clearMean() {
      
      mean_ = 0D;
      onChanged();
      return this;
    }

    private double sumOfSquaredDeviation_ ;
    /**
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population. For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     */
    public double getSumOfSquaredDeviation() {
      return sumOfSquaredDeviation_;
    }
    /**
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population. For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     */
    public Builder setSumOfSquaredDeviation(double value) {
      
      sumOfSquaredDeviation_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population. For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     */
    public Builder clearSumOfSquaredDeviation() {
      
      sumOfSquaredDeviation_ = 0D;
      onChanged();
      return this;
    }

    private Range range_;
    private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
        Range, Range.Builder, RangeOrBuilder> rangeBuilder_;
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public boolean hasRange() {
      return rangeBuilder_ != null || range_ != null;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Range getRange() {
      if (rangeBuilder_ == null) {
        return range_ == null ? Range.getDefaultInstance() : range_;
      } else {
        return rangeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder setRange(Range value) {
      if (rangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        range_ = value;
        onChanged();
      } else {
        rangeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder setRange(
        Range.Builder builderForValue) {
      if (rangeBuilder_ == null) {
        range_ = builderForValue.build();
        onChanged();
      } else {
        rangeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder mergeRange(Range value) {
      if (rangeBuilder_ == null) {
        if (range_ != null) {
          range_ =
            Range.newBuilder(range_).mergeFrom(value).buildPartial();
        } else {
          range_ = value;
        }
        onChanged();
      } else {
        rangeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder clearRange() {
      if (rangeBuilder_ == null) {
        range_ = null;
        onChanged();
      } else {
        range_ = null;
        rangeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Range.Builder getRangeBuilder() {
      
      onChanged();
      return getRangeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public RangeOrBuilder getRangeOrBuilder() {
      if (rangeBuilder_ != null) {
        return rangeBuilder_.getMessageOrBuilder();
      } else {
        return range_ == null ?
            Range.getDefaultInstance() : range_;
      }
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
        Range, Range.Builder, RangeOrBuilder>
        getRangeFieldBuilder() {
      if (rangeBuilder_ == null) {
        rangeBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
            Range, Range.Builder, RangeOrBuilder>(
                getRange(),
                getParentForChildren(),
                isClean());
        range_ = null;
      }
      return rangeBuilder_;
    }

    private BucketOptions bucketOptions_;
    private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
        BucketOptions, BucketOptions.Builder, BucketOptionsOrBuilder> bucketOptionsBuilder_;
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public boolean hasBucketOptions() {
      return bucketOptionsBuilder_ != null || bucketOptions_ != null;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public BucketOptions getBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        return bucketOptions_ == null ? BucketOptions.getDefaultInstance() : bucketOptions_;
      } else {
        return bucketOptionsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder setBucketOptions(BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOptions_ = value;
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder setBucketOptions(
        BucketOptions.Builder builderForValue) {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = builderForValue.build();
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder mergeBucketOptions(BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (bucketOptions_ != null) {
          bucketOptions_ =
            BucketOptions.newBuilder(bucketOptions_).mergeFrom(value).buildPartial();
        } else {
          bucketOptions_ = value;
        }
        onChanged();
      } else {
        bucketOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder clearBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
        onChanged();
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public BucketOptions.Builder getBucketOptionsBuilder() {
      
      onChanged();
      return getBucketOptionsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
      if (bucketOptionsBuilder_ != null) {
        return bucketOptionsBuilder_.getMessageOrBuilder();
      } else {
        return bucketOptions_ == null ?
            BucketOptions.getDefaultInstance() : bucketOptions_;
      }
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries. If the distribution does not
     * contain a histogram, then omit this field.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    private alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
        BucketOptions, BucketOptions.Builder, BucketOptionsOrBuilder>
        getBucketOptionsFieldBuilder() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptionsBuilder_ = new alluxio.shaded.client.com.google.protobuf.SingleFieldBuilderV3<
            BucketOptions, BucketOptions.Builder, BucketOptionsOrBuilder>(
                getBucketOptions(),
                getParentForChildren(),
                isClean());
        bucketOptions_ = null;
      }
      return bucketOptionsBuilder_;
    }

    private alluxio.shaded.client.com.google.protobuf.Internal.LongList bucketCounts_ = emptyLongList();
    private void ensureBucketCountsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        bucketCounts_ = mutableCopy(bucketCounts_);
        bitField0_ |= 0x00000020;
       }
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public java.util.List<Long>
        getBucketCountsList() {
      return ((bitField0_ & 0x00000020) != 0) ?
               java.util.Collections.unmodifiableList(bucketCounts_) : bucketCounts_;
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public int getBucketCountsCount() {
      return bucketCounts_.size();
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public long getBucketCounts(int index) {
      return bucketCounts_.getLong(index);
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder setBucketCounts(
        int index, long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder addBucketCounts(long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.addLong(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder addAllBucketCounts(
        Iterable<? extends Long> values) {
      ensureBucketCountsIsMutable();
      alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, bucketCounts_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of values in each bucket of the histogram, as described in
     * `bucket_options`. If the distribution does not have a histogram, then omit
     * this field. If there is a histogram, then the sum of the values in
     * `bucket_counts` must equal the value in the `count` field of the
     * distribution.
     * If present, `bucket_counts` should contain N values, where N is the number
     * of buckets specified in `bucket_options`. If you supply fewer than N
     * values, the remaining values are assumed to be 0.
     * The order of the values in `bucket_counts` follows the bucket numbering
     * schemes described for the three bucket types. The first value must be the
     * count for the underflow bucket (number 0). The next N-2 values are the
     * counts for the finite buckets (number 1 through N-2). The N'th value in
     * `bucket_counts` is the count for the overflow bucket (number N-1).
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder clearBucketCounts() {
      bucketCounts_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    private java.util.List<Exemplar> exemplars_ =
      java.util.Collections.emptyList();
    private void ensureExemplarsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        exemplars_ = new java.util.ArrayList<Exemplar>(exemplars_);
        bitField0_ |= 0x00000040;
       }
    }

    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        Exemplar, Exemplar.Builder, ExemplarOrBuilder> exemplarsBuilder_;

    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public java.util.List<Exemplar> getExemplarsList() {
      if (exemplarsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(exemplars_);
      } else {
        return exemplarsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public int getExemplarsCount() {
      if (exemplarsBuilder_ == null) {
        return exemplars_.size();
      } else {
        return exemplarsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Exemplar getExemplars(int index) {
      if (exemplarsBuilder_ == null) {
        return exemplars_.get(index);
      } else {
        return exemplarsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder setExemplars(
        int index, Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.set(index, value);
        onChanged();
      } else {
        exemplarsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder setExemplars(
        int index, Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.set(index, builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.add(value);
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(
        int index, Exemplar value) {
      if (exemplarsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExemplarsIsMutable();
        exemplars_.add(index, value);
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(
        Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.add(builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addExemplars(
        int index, Exemplar.Builder builderForValue) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.add(index, builderForValue.build());
        onChanged();
      } else {
        exemplarsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder addAllExemplars(
        Iterable<? extends Exemplar> values) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, exemplars_);
        onChanged();
      } else {
        exemplarsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder clearExemplars() {
      if (exemplarsBuilder_ == null) {
        exemplars_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        exemplarsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Builder removeExemplars(int index) {
      if (exemplarsBuilder_ == null) {
        ensureExemplarsIsMutable();
        exemplars_.remove(index);
        onChanged();
      } else {
        exemplarsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Exemplar.Builder getExemplarsBuilder(
        int index) {
      return getExemplarsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public ExemplarOrBuilder getExemplarsOrBuilder(
        int index) {
      if (exemplarsBuilder_ == null) {
        return exemplars_.get(index);  } else {
        return exemplarsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public java.util.List<? extends ExemplarOrBuilder>
         getExemplarsOrBuilderList() {
      if (exemplarsBuilder_ != null) {
        return exemplarsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(exemplars_);
      }
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Exemplar.Builder addExemplarsBuilder() {
      return getExemplarsFieldBuilder().addBuilder(
          Exemplar.getDefaultInstance());
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public Exemplar.Builder addExemplarsBuilder(
        int index) {
      return getExemplarsFieldBuilder().addBuilder(
          index, Exemplar.getDefaultInstance());
    }
    /**
     * <pre>
     * Must be in increasing order of `value` field.
     * </pre>
     *
     * <code>repeated .google.api.Distribution.Exemplar exemplars = 10;</code>
     */
    public java.util.List<Exemplar.Builder>
         getExemplarsBuilderList() {
      return getExemplarsFieldBuilder().getBuilderList();
    }
    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        Exemplar, Exemplar.Builder, ExemplarOrBuilder>
        getExemplarsFieldBuilder() {
      if (exemplarsBuilder_ == null) {
        exemplarsBuilder_ = new alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
            Exemplar, Exemplar.Builder, ExemplarOrBuilder>(
                exemplars_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        exemplars_ = null;
      }
      return exemplarsBuilder_;
    }
    @Override
    public final Builder setUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @Override
    public final Builder mergeUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.api.Distribution)
  }

  // @@protoc_insertion_point(class_scope:google.api.Distribution)
  private static final Distribution DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new Distribution();
  }

  public static Distribution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final alluxio.shaded.client.com.google.protobuf.Parser<Distribution>
      PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Distribution>() {
    @Override
    public Distribution parsePartialFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return new Distribution(input, extensionRegistry);
    }
  };

  public static alluxio.shaded.client.com.google.protobuf.Parser<Distribution> parser() {
    return PARSER;
  }

  @Override
  public alluxio.shaded.client.com.google.protobuf.Parser<Distribution> getParserForType() {
    return PARSER;
  }

  @Override
  public Distribution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

