/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static String getErrorInfo(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static boolean isHdfsScheme(String path) {
        String scheme = new AlluxioURI(path).getScheme();
        return scheme != null && scheme.startsWith("hdfs");
    }

    public static class TaskResult
    implements Serializable {
        private static final long serialVersionUID = -2746652850515278409L;
        State mState = State.OK;
        String mName = "";
        String mDesc = "";
        String mOutput = "";
        String mAdvice = "";

        public TaskResult(State state, String name, String output, String advice) {
            this.mState = state;
            this.mName = name;
            this.mOutput = output;
            this.mAdvice = advice;
        }

        public TaskResult(State state, String name, String desc, String output, String advice) {
            this.mState = state;
            this.mName = name;
            this.mDesc = desc;
            this.mOutput = output;
            this.mAdvice = advice;
        }

        public TaskResult() {
        }

        public TaskResult setState(State state) {
            this.mState = state;
            return this;
        }

        public TaskResult setName(String name) {
            this.mName = name;
            return this;
        }

        public TaskResult setDesc(String desc) {
            this.mDesc = desc;
            return this;
        }

        public TaskResult setOutput(String output) {
            this.mOutput = output;
            return this;
        }

        public TaskResult setAdvice(String advice) {
            this.mAdvice = advice;
            return this;
        }

        public State getState() {
            return this.mState;
        }

        public String getName() {
            return this.mName;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public String getResult() {
            return this.mOutput;
        }

        public String getAdvice() {
            return this.mAdvice;
        }

        public String toString() {
            return String.format("%s: %s%nOutput: %s%nAdvice: %s%n", new Object[]{this.mName, this.mState, this.mOutput, this.mAdvice});
        }
    }

    public static enum State {
        OK,
        WARNING,
        FAILED,
        SKIPPED;

    }
}

