package alluxio.shaded.client.org.checkerframework.checker.i18n.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import alluxio.shaded.client.org.checkerframework.framework.qual.InvisibleQualifier;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Indicates that the {@code String} type has unknown localization properties.
 *
 * @checker_framework.manual #i18n-checker Internationalization Checker
 */
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface UnknownLocalized {}
