package alluxio.shaded.client.org.checkerframework.checker.regex.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultFor;
import alluxio.shaded.client.org.checkerframework.framework.qual.ImplicitFor;
import alluxio.shaded.client.org.checkerframework.framework.qual.InvisibleQualifier;
import alluxio.shaded.client.org.checkerframework.framework.qual.LiteralKind;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;
import alluxio.shaded.client.org.checkerframework.framework.qual.TargetLocations;
import alluxio.shaded.client.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type in the Regex type system. Programmers should rarely write this type.
 *
 * @checker_framework.manual #regex-checker Regex Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@InvisibleQualifier
@ImplicitFor(literals = LiteralKind.NULL, typeNames = java.lang.Void.class)
@SubtypeOf({Regex.class, alluxio.shaded.client.org.checkerframework.checker.regex.qual.PartialRegex.class})
@DefaultFor(value = {TypeUseLocation.LOWER_BOUND})
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
public @interface RegexBottom {}
