/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.shaded.client.com.google.gson.Gson;
import alluxio.shaded.client.com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ValidationTool {
    public Map<String, ValidationTask> getTasks();

    public List<ValidationTaskResult> runAllTests() throws InterruptedException;

    public static Map<ValidationUtils.State, List<ValidationTaskResult>> convertResults(List<ValidationTaskResult> results) {
        HashMap<ValidationUtils.State, List<ValidationTaskResult>> map = new HashMap<ValidationUtils.State, List<ValidationTaskResult>>();
        results.forEach(r -> map.computeIfAbsent(r.getState(), k -> new ArrayList()).add(r));
        return map;
    }

    public static String toJson(Map<ValidationUtils.State, List<ValidationTaskResult>> map) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(map);
    }
}

