/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.journal;

import alluxio.AbstractMasterClient;
import alluxio.client.journal.JournalMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GetQuorumInfoPRequest;
import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.JournalMasterClientServiceGrpc;
import alluxio.grpc.NetAddress;
import alluxio.grpc.RemoveQuorumServerPRequest;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHandlingJournalMasterClient
extends AbstractMasterClient
implements JournalMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(JournalMasterClient.class);
    private JournalMasterClientServiceGrpc.JournalMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingJournalMasterClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOURNAL_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "JournalMaster";
    }

    @Override
    protected long getServiceVersion() {
        return 1L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = JournalMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public GetQuorumInfoPResponse getQuorumInfo() throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getQuorumInfo(GetQuorumInfoPRequest.getDefaultInstance()), RPC_LOG, "GetQuorumInfo", "", new Object[0]);
    }

    @Override
    public void removeQuorumServer(NetAddress serverAddress) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.removeQuorumServer(RemoveQuorumServerPRequest.newBuilder().setServerAddress(serverAddress).build()), RPC_LOG, "RemoveQuorumServer", "serverAddress=%s", serverAddress);
    }
}

