package alluxio.shaded.client.org.checkerframework.checker.alluxio.shaded.client.com.ilermsgs.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import alluxio.shaded.client.org.checkerframework.framework.qual.InvisibleQualifier;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Indicates that the {@code String} type has an unknown alluxio.shaded.client.com.iler message key property.
 *
 * @checker_framework.manual #alluxio.shaded.client.com.ilermsgs-checker Compiler Message Key Checker
 */
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface UnknownCompilerMessageKey {}
