package alluxio.shaded.client.com.fasterxml.jackson.databind.deser.std;

import java.alluxio.shaded.client.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

import alluxio.shaded.client.com.fasterxml.jackson.core.JsonParser;
import alluxio.shaded.client.com.fasterxml.jackson.databind.DeserializationContext;

public class AtomicBooleanDeserializer extends StdScalarDeserializer<AtomicBoolean>
{
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() { super(AtomicBoolean.class); }

    @Override
    public AtomicBoolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return new AtomicBoolean(_parseBooleanPrimitive(ctxt, p, AtomicBoolean.class));
    }
}