/*
 * Copyright 2018 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.util;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.MoreObjects;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.ChannelLogger;
import alluxio.shaded.client.io.grpc.ConnectivityState;
import alluxio.shaded.client.io.grpc.EquivalentAddressGroup;
import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.LoadBalancer.CreateSubchannelArgs;
import alluxio.shaded.client.io.grpc.LoadBalancer.Subchannel;
import alluxio.shaded.client.io.grpc.LoadBalancer.SubchannelPicker;
import alluxio.shaded.client.io.grpc.LoadBalancer;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.grpc.NameResolver;
import alluxio.shaded.client.io.grpc.NameResolverRegistry;
import alluxio.shaded.client.io.grpc.SynchronizationContext;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@ExperimentalApi("https://github.alluxio.shaded.client.com.grpc/grpc-java/issues/1771")
public abstract class ForwardingLoadBalancerHelper extends LoadBalancer.Helper {
  /**
   * Returns the underlying helper.
   */
  protected abstract LoadBalancer.Helper delegate();

  @Deprecated
  @Override
  public Subchannel createSubchannel(List<EquivalentAddressGroup> addrs, Attributes attrs) {
    return delegate().createSubchannel(addrs, attrs);
  }

  @Override
  public Subchannel createSubchannel(CreateSubchannelArgs args) {
    return delegate().createSubchannel(args);
  }

  @Deprecated
  @Override
  public void updateSubchannelAddresses(
      Subchannel subchannel, List<EquivalentAddressGroup> addrs) {
    delegate().updateSubchannelAddresses(subchannel, addrs);
  }

  @Override
  public  ManagedChannel createOobChannel(EquivalentAddressGroup eag, String authority) {
    return delegate().createOobChannel(eag, authority);
  }

  @Override
  public void updateOobChannelAddresses(ManagedChannel channel, EquivalentAddressGroup eag) {
    delegate().updateOobChannelAddresses(channel, eag);
  }

  @Override
  public ManagedChannel createResolvingOobChannel(String target) {
    return delegate().createResolvingOobChannel(target);
  }

  @Override
  public void updateBalancingState(
      ConnectivityState newState, SubchannelPicker newPicker) {
    delegate().updateBalancingState(newState, newPicker);
  }

  @Override
  public void refreshNameResolution() {
    delegate().refreshNameResolution();
  }

  @Override
  @Deprecated
  public void runSerialized(Runnable task) {
    delegate().runSerialized(task);
  }

  @Deprecated
  @Override
  public NameResolver.Factory getNameResolverFactory() {
    return delegate().getNameResolverFactory();
  }

  @Override
  public String getAuthority() {
    return delegate().getAuthority();
  }

  @Override
  public SynchronizationContext getSynchronizationContext() {
    return delegate().getSynchronizationContext();
  }

  @Override
  public ScheduledExecutorService getScheduledExecutorService() {
    return delegate().getScheduledExecutorService();
  }

  @Override
  public ChannelLogger getChannelLogger() {
    return delegate().getChannelLogger();
  }

  @Override
  public NameResolver.Args getNameResolverArgs() {
    return delegate().getNameResolverArgs();
  }

  @Override
  public NameResolverRegistry getNameResolverRegistry() {
    return delegate().getNameResolverRegistry();
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this).add("delegate", delegate()).toString();
  }
}
