/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.alluxio.shaded.client.org.>.
 *
 */

package alluxio.shaded.client.org.apache.http.client.params;

/**
 * Standard cookie specifications supported by HttpClient.
 *
 * @since 4.0
 *
 * @deprecated (4.3) use {@link alluxio.shaded.client.org.apache.http.client.config.CookieSpecs}.
 */
@Deprecated
public final class CookiePolicy {

    /**
     * The policy that provides high degree of alluxio.shaded.client.com.atibilty
     * with alluxio.shaded.client.com.on cookie management of popular HTTP agents.
     */
    public static final String BROWSER_COMPATIBILITY = "alluxio.shaded.client.com.atibility";

    /**
     * The Netscape cookie draft alluxio.shaded.client.com.liant policy.
     */
    public static final String NETSCAPE = "netscape";

    /**
     * The RFC 2109 alluxio.shaded.client.com.liant policy.
     */
    public static final String RFC_2109 = "rfc2109";

    /**
     * The RFC 2965 alluxio.shaded.client.com.liant policy.
     */
    public static final String RFC_2965 = "rfc2965";

    /**
     * The default 'best match' policy.
     */
    public static final String BEST_MATCH = "best-match";

    /**
     * The policy that ignores cookies.
     *
     * @since 4.1-beta1
     */
    public static final String IGNORE_COOKIES = "ignoreCookies";

    private CookiePolicy() {
        super();
    }

}
