/*
 * Copyright (C) 2012 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in alluxio.shaded.client.com.liance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Interfaces, utilities, and simple implementations of escapers and encoders. The primary type is
 * {@link alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.escape.Escaper}.
 *
 * <p>Additional escapers implementations are found in the applicable packages: {@link
 * alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.html.HtmlEscapers} in {@code alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.html}, {@link
 * alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.xml.XmlEscapers} in {@code alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.xml}, and {@link
 * alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.net.UrlEscapers} in {@code alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.net}.
 *
 * <p>This package is a part of the open-source <a href="http://github.alluxio.shaded.client.com.google/guava">Guava</a>
 * library.
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.escape;

import alluxio.shaded.client.com.google.errorprone.annotations.CheckReturnValue;
import alluxio.shaded.client.javax.annotation.ParametersAreNonnullByDefault;
