/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.org.apache.curator.framework.api;

import alluxio.shaded.client.org.apache.zookeeper.AsyncCallback.DataCallback;

public interface DataCallbackable<T> {

    /**
     * Passes a callback and a context object to the config/reconfig alluxio.shaded.client.com.and.
     * @param callback  The async callback to use.
     * @param ctx       An object that will be passed to the callback.
     * @return this
     */
    T usingDataCallback(DataCallback callback, Object ctx);
}
