/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.Cancelable;
import alluxio.client.WriteType;
import alluxio.client.block.stream.GrpcDataWriter;
import alluxio.client.block.stream.LocalFileDataWriter;
import alluxio.client.block.stream.UfsFallbackLocalFileDataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.RequestType;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.network.NettyUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataWriter
extends Closeable,
Cancelable {
    public void writeChunk(ByteBuf var1) throws IOException;

    public void flush() throws IOException;

    public int chunkSize();

    public long pos();

    @ThreadSafe
    public static class Factory {
        public static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static DataWriter create(FileSystemContext context, long blockId, long blockSize, WorkerNetAddress address, OutStreamOptions options) throws IOException {
            AlluxioConfiguration alluxioConf = context.getClusterConf();
            boolean shortCircuit = alluxioConf.getBoolean(PropertyKey.USER_SHORT_CIRCUIT_ENABLED);
            boolean shortCircuitPreferred = alluxioConf.getBoolean(PropertyKey.USER_SHORT_CIRCUIT_PREFERRED);
            if (CommonUtils.isLocalHost(address, alluxioConf) && shortCircuit && (shortCircuitPreferred || !NettyUtils.isDomainSocketSupported(address))) {
                if (options.getWriteType() == WriteType.ASYNC_THROUGH && alluxioConf.getBoolean(PropertyKey.USER_FILE_UFS_TIER_ENABLED)) {
                    LOG.info("Creating UFS-fallback short circuit output stream for block {} @ {}", (Object)blockId, (Object)address);
                    return UfsFallbackLocalFileDataWriter.create(context, address, blockId, blockSize, options);
                }
                LOG.debug("Creating short circuit output stream for block {} @ {}", (Object)blockId, (Object)address);
                return LocalFileDataWriter.create(context, address, blockId, options);
            }
            LOG.debug("Creating gRPC output stream for block {} @ {} from client {}", new Object[]{blockId, address, NetworkAddressUtils.getClientHostName(alluxioConf)});
            return GrpcDataWriter.create(context, address, blockId, blockSize, RequestType.ALLUXIO_BLOCK, options);
        }
    }
}

