/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.TimeBoundPageStore;
import alluxio.client.file.cache.store.LocalPageStore;
import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.client.file.cache.store.RocksPageStore;
import alluxio.client.file.cache.store.RocksPageStoreOptions;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.util.io.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PageStore
extends AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(PageStore.class);

    public static PageStore create(PageStoreOptions options) throws IOException {
        PageStore.initialize(options);
        return PageStore.open(options);
    }

    public static PageStore open(PageStoreOptions options) throws IOException {
        PageStore pageStore;
        LOG.info("Creating PageStore with option={}", (Object)options.toString());
        switch (options.getType()) {
            case LOCAL: {
                pageStore = new LocalPageStore((LocalPageStoreOptions)options.toOptions());
                break;
            }
            case ROCKS: {
                pageStore = RocksPageStore.open((RocksPageStoreOptions)options.toOptions());
                break;
            }
            default: {
                throw new IllegalArgumentException("Incompatible PageStore " + (Object)((Object)options.getType()) + " specified");
            }
        }
        if (options.getTimeoutDuration() > 0L) {
            return new TimeBoundPageStore(pageStore, options);
        }
        return pageStore;
    }

    public static Path getStorePath(PageStoreType storeType, String rootDir) {
        return Paths.get(rootDir, storeType.name());
    }

    public static void initialize(PageStoreOptions options) throws IOException {
        String rootPath = options.getRootDir();
        Files.createDirectories(Paths.get(rootPath, new String[0]), new FileAttribute[0]);
        LOG.debug("Clean cache directory {}", (Object)rootPath);
        try (Stream<Path> stream = Files.list(Paths.get(rootPath, new String[0]));){
            stream.forEach(path -> {
                try {
                    FileUtils.deletePathRecursively(path.toString());
                }
                catch (IOException e) {
                    Metrics.UNREMOVABLE_FILES.inc();
                    LOG.warn("failed to delete {} in cache directory: {}", path, (Object)e.toString());
                }
            });
        }
    }

    public void put(PageId var1, byte[] var2) throws IOException;

    default public int get(PageId pageId, byte[] buffer) throws IOException, PageNotFoundException {
        return this.get(pageId, 0, buffer.length, buffer, 0);
    }

    public int get(PageId var1, int var2, int var3, byte[] var4, int var5) throws IOException, PageNotFoundException;

    public void delete(PageId var1) throws IOException, PageNotFoundException;

    public Stream<PageInfo> getPages() throws IOException;

    public long getCacheSize();

    public static final class Metrics {
        private static final Counter UNREMOVABLE_FILES = MetricsSystem.counter(MetricKey.CLIENT_CACHE_UNREMOVABLE_FILES.getName());
    }
}

