/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.ServerMethodDefinition;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.ServiceDescriptor;
import alluxio.shaded.client.io.grpc.internal.CompositeReadableBuffer;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.CompositeByteBuf;
import alluxio.shaded.client.io.netty.buffer.PooledByteBufAllocator;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcSerializationUtils {
    public static final CallOptions.Key<MethodDescriptor> OVERRIDDEN_METHOD_DESCRIPTOR = CallOptions.Key.create("overridden method descriptor");
    private static final Logger LOG = LoggerFactory.getLogger(GrpcSerializationUtils.class);
    private static final int TAG_TYPE_BITS = 3;
    private static final String BUFFER_INPUT_STREAM_CLASS_NAME = "alluxio.shaded.client.io.grpc.internal.ReadableBuffers$BufferInputStream";
    private static final String BUFFER_FIELD_NAME = "buffer";
    private static final String BUFFERS_FIELD_NAME = "buffers";
    private static final String NETTY_WRITABLE_BUFFER_CLASS_NAME = "alluxio.shaded.client.io.grpc.netty.NettyWritableBuffer";
    private static final String NETTY_READABLE_BUFFER_CLASS_NAME = "alluxio.shaded.client.io.grpc.netty.NettyReadableBuffer";
    private static final String BUFFER_CHAIN_OUTPUT_STREAM_CLASS_NAME = "alluxio.shaded.client.io.grpc.internal.MessageFramer$BufferChainOutputStream";
    private static final String BUFFER_LIST_FIELD_NAME = "bufferList";
    private static final String CURRENT_FIELD_NAME = "current";
    private static Constructor<?> sNettyWritableBufferConstructor;
    private static Field sBufferList;
    private static Field sCompositeBuffers;
    private static Field sCurrent;
    private static Field sReadableBufferField;
    private static Field sReadableByteBuf;
    private static boolean sZeroCopySendSupported;
    private static boolean sZeroCopyReceiveSupported;

    private static Field getPrivateField(String className, String fieldName) throws NoSuchFieldException, ClassNotFoundException {
        Class<?> declaringClass = Class.forName(className);
        Field field = declaringClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    private static Constructor<?> getPrivateConstructor(String className, Class<?> ... parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> declaringClass = Class.forName(className);
        Constructor<?> constructor = declaringClass.getDeclaredConstructor(parameterTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    public static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static ReadableBuffer getBufferFromStream(InputStream stream) {
        if (!sZeroCopyReceiveSupported || !stream.getClass().equals(sReadableBufferField.getDeclaringClass())) {
            return null;
        }
        try {
            return (ReadableBuffer)sReadableBufferField.get(stream);
        }
        catch (Exception e) {
            LOG.warn("Failed to get data buffer from stream.", (Throwable)e);
            return null;
        }
    }

    public static ByteBuf getByteBufFromReadableBuffer(ReadableBuffer buffer) {
        if (!sZeroCopyReceiveSupported) {
            return null;
        }
        try {
            if (buffer instanceof CompositeReadableBuffer) {
                Queue buffers = (Queue)sCompositeBuffers.get(buffer);
                if (buffers.size() == 1) {
                    return GrpcSerializationUtils.getByteBufFromReadableBuffer((ReadableBuffer)buffers.peek());
                }
                CompositeByteBuf buf = PooledByteBufAllocator.DEFAULT.compositeBuffer();
                for (ReadableBuffer readableBuffer : buffers) {
                    ByteBuf subBuffer = GrpcSerializationUtils.getByteBufFromReadableBuffer(readableBuffer);
                    if (subBuffer == null) {
                        return null;
                    }
                    buf.addComponent(true, subBuffer);
                }
                return buf;
            }
            if (buffer.getClass().equals(sReadableByteBuf.getDeclaringClass())) {
                return (ByteBuf)sReadableByteBuf.get(buffer);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get data buffer from stream: {}.", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    public static boolean addBuffersToStream(ByteBuf[] buffers, OutputStream stream) {
        if (!sZeroCopySendSupported || !stream.getClass().equals(sBufferList.getDeclaringClass())) {
            return false;
        }
        try {
            if (sCurrent.get(stream) != null) {
                return false;
            }
            for (ByteBuf buffer : buffers) {
                Object nettyBuffer = sNettyWritableBufferConstructor.newInstance(buffer);
                List list = (List)sBufferList.get(stream);
                list.add(nettyBuffer);
                buffer.retain();
                sCurrent.set(stream, nettyBuffer);
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to add data buffer to stream: {}.", (Object)e.getMessage());
            return false;
        }
    }

    public static ServerServiceDefinition overrideMethods(ServerServiceDefinition service, Map<MethodDescriptor, MethodDescriptor> marshallers) {
        ArrayList newMethods = new ArrayList();
        ArrayList newDescriptors = new ArrayList();
        for (ServerMethodDefinition<?, ?> definition : service.getMethods()) {
            ServerMethodDefinition<?, ?> serverMethodDefinition = GrpcSerializationUtils.interceptMethod(definition, marshallers);
            newDescriptors.add(serverMethodDefinition.getMethodDescriptor());
            newMethods.add(serverMethodDefinition);
        }
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder(new ServiceDescriptor(service.getServiceDescriptor().getName(), newDescriptors));
        for (ServerMethodDefinition serverMethodDefinition : newMethods) {
            serviceBuilder.addMethod(serverMethodDefinition);
        }
        return serviceBuilder.build();
    }

    private static <ReqT, RespT> ServerMethodDefinition<ReqT, RespT> interceptMethod(ServerMethodDefinition<ReqT, RespT> definition, Map<MethodDescriptor, MethodDescriptor> newMethods) {
        MethodDescriptor<ReqT, RespT> descriptor = definition.getMethodDescriptor();
        MethodDescriptor newMethod = newMethods.get(descriptor);
        if (newMethod != null) {
            return ServerMethodDefinition.create(newMethod, definition.getServerCallHandler());
        }
        return definition;
    }

    static {
        sCompositeBuffers = null;
        sReadableBufferField = null;
        sReadableByteBuf = null;
        sZeroCopySendSupported = true;
        sZeroCopyReceiveSupported = true;
        try {
            sReadableBufferField = GrpcSerializationUtils.getPrivateField(BUFFER_INPUT_STREAM_CLASS_NAME, BUFFER_FIELD_NAME);
        }
        catch (Exception e) {
            LOG.warn("Cannot get gRPC input stream buffer, zero copy send will be disabled.", (Throwable)e);
            sZeroCopySendSupported = false;
        }
        try {
            sNettyWritableBufferConstructor = GrpcSerializationUtils.getPrivateConstructor(NETTY_WRITABLE_BUFFER_CLASS_NAME, ByteBuf.class);
            sBufferList = GrpcSerializationUtils.getPrivateField(BUFFER_CHAIN_OUTPUT_STREAM_CLASS_NAME, BUFFER_LIST_FIELD_NAME);
            sCurrent = GrpcSerializationUtils.getPrivateField(BUFFER_CHAIN_OUTPUT_STREAM_CLASS_NAME, CURRENT_FIELD_NAME);
            sCompositeBuffers = GrpcSerializationUtils.getPrivateField(CompositeReadableBuffer.class.getName(), BUFFERS_FIELD_NAME);
            sReadableByteBuf = GrpcSerializationUtils.getPrivateField(NETTY_READABLE_BUFFER_CLASS_NAME, BUFFER_FIELD_NAME);
        }
        catch (Exception e) {
            LOG.warn("Cannot get gRPC output stream buffer, zero copy receive will be disabled.", (Throwable)e);
            sZeroCopyReceiveSupported = false;
        }
    }
}

