/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.exception.PreconditionMessage;
import alluxio.hadoop.AbstractFileSystem;
import alluxio.hadoop.HadoopUtils;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.uri.Authority;
import alluxio.uri.MultiMasterAuthority;
import alluxio.uri.SingleMasterAuthority;
import alluxio.uri.UnknownAuthority;
import alluxio.uri.ZookeeperAuthority;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;

@NotThreadSafe
public final class FileSystem
extends AbstractFileSystem {
    public FileSystem() {
    }

    public FileSystem(alluxio.client.file.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    public String getScheme() {
        return "alluxio";
    }

    @Override
    protected boolean isZookeeperMode() {
        return this.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED);
    }

    @Override
    protected Map<String, Object> getConfigurationFromUri(URI uri) {
        AlluxioURI alluxioUri = new AlluxioURI(uri.toString());
        HashMap<String, Object> alluxioConfProperties = new HashMap<String, Object>();
        if (alluxioUri.getAuthority() instanceof ZookeeperAuthority) {
            ZookeeperAuthority authority = (ZookeeperAuthority)alluxioUri.getAuthority();
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), true);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), authority.getZookeeperAddress());
        } else if (alluxioUri.getAuthority() instanceof SingleMasterAuthority) {
            SingleMasterAuthority authority = (SingleMasterAuthority)alluxioUri.getAuthority();
            alluxioConfProperties.put(PropertyKey.MASTER_HOSTNAME.getName(), authority.getHost());
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_PORT.getName(), authority.getPort());
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), false);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), null);
            alluxioConfProperties.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES.getName(), null);
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_ADDRESSES.getName(), null);
        } else if (alluxioUri.getAuthority() instanceof MultiMasterAuthority) {
            MultiMasterAuthority authority = (MultiMasterAuthority)alluxioUri.getAuthority();
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_ADDRESSES.getName(), authority.getMasterAddresses());
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), false);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), null);
        }
        return alluxioConfProperties;
    }

    @Override
    protected void validateFsUri(URI fsUri) throws IOException, IllegalArgumentException {
        Preconditions.checkArgument(fsUri.getScheme().equals(this.getScheme()), PreconditionMessage.URI_SCHEME_MISMATCH.toString(), (Object)fsUri.getScheme(), (Object)this.getScheme());
        Authority auth = Authority.fromString(fsUri.getAuthority());
        if (auth instanceof UnknownAuthority) {
            throw new IOException(String.format("Authority \"%s\" is unknown. The client can not be configured with the authority from %s", auth, fsUri));
        }
    }

    @Override
    protected String getFsScheme(URI fsUri) {
        return this.getScheme();
    }

    @Override
    protected AlluxioURI getAlluxioPath(Path path) {
        return new AlluxioURI(HadoopUtils.getPathWithoutScheme(path));
    }

    @Override
    protected Path getFsPath(String fsUriHeader, URIStatus fileStatus) {
        return new Path(fsUriHeader + fileStatus.getPath());
    }
}

