/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.util.FormatUtils;
import alluxio.util.webui.WebUtils;
import alluxio.wire.WorkerInfo;

public final class NodeInfo
implements Comparable<NodeInfo> {
    private final String mHost;
    private final int mWebPort;
    private final String mLastContactSec;
    private final String mWorkerState;
    private final long mCapacityBytes;
    private final long mUsedBytes;
    private final int mFreePercent;
    private final int mUsedPercent;
    private final String mUptimeClockTime;
    private final long mWorkerId;

    public NodeInfo(WorkerInfo workerInfo) {
        this.mHost = workerInfo.getAddress().getHost();
        this.mWebPort = workerInfo.getAddress().getWebPort();
        this.mLastContactSec = Integer.toString(workerInfo.getLastContactSec());
        this.mWorkerState = workerInfo.getState();
        this.mCapacityBytes = workerInfo.getCapacityBytes();
        this.mUsedBytes = workerInfo.getUsedBytes();
        this.mUsedPercent = this.mCapacityBytes != 0L ? (int)(100L * this.mUsedBytes / this.mCapacityBytes) : 0;
        this.mFreePercent = 100 - this.mUsedPercent;
        this.mUptimeClockTime = WebUtils.convertMsToShortClockTime(System.currentTimeMillis() - workerInfo.getStartTimeMs());
        this.mWorkerId = workerInfo.getId();
    }

    public String getCapacity() {
        return FormatUtils.getSizeFromBytes(this.mCapacityBytes);
    }

    public int getFreeSpacePercent() {
        return this.mFreePercent;
    }

    public String getLastHeartbeat() {
        return this.mLastContactSec;
    }

    public String getHost() {
        return this.mHost;
    }

    public int getWebPort() {
        return this.mWebPort;
    }

    public String getState() {
        return this.mWorkerState;
    }

    public String getUptimeClockTime() {
        return this.mUptimeClockTime;
    }

    public String getUsedMemory() {
        return FormatUtils.getSizeFromBytes(this.mUsedBytes);
    }

    public int getUsedSpacePercent() {
        return this.mUsedPercent;
    }

    public long getWorkerId() {
        return this.mWorkerId;
    }

    @Override
    public int compareTo(NodeInfo o) {
        if (o == null) {
            return 1;
        }
        return this.getHost().compareTo(o.getHost());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeInfo)) {
            return false;
        }
        return this.getHost().equals(((NodeInfo)o).getHost());
    }

    public int hashCode() {
        return Objects.hashCode(this.getHost());
    }
}

