/*
 * Copyright 2019 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.util;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.MoreObjects;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ChannelLogger;
import alluxio.shaded.client.io.grpc.EquivalentAddressGroup;
import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.LoadBalancer;
import alluxio.shaded.client.io.grpc.LoadBalancer.Subchannel;
import alluxio.shaded.client.io.grpc.LoadBalancer.SubchannelStateListener;
import java.util.List;

@ExperimentalApi("https://github.alluxio.shaded.client.com.grpc/grpc-java/issues/1771")
public abstract class ForwardingSubchannel extends LoadBalancer.Subchannel {
  /**
   * Returns the underlying Subchannel.
   */
  protected abstract Subchannel delegate();

  @Override
  public void start(SubchannelStateListener listener) {
    delegate().start(listener);
  }

  @Override
  public void shutdown() {
    delegate().shutdown();
  }

  @Override
  public void requestConnection() {
    delegate().requestConnection();
  }

  @Override
  public List<EquivalentAddressGroup> getAllAddresses() {
    return delegate().getAllAddresses();
  }

  @Override
  public Attributes getAttributes() {
    return delegate().getAttributes();
  }

  @Override
  public Channel asChannel() {
    return delegate().asChannel();
  }

  @Override
  public ChannelLogger getChannelLogger() {
    return delegate().getChannelLogger();
  }

  @Override
  public Object getInternalSubchannel() {
    return delegate().getInternalSubchannel();
  }

  @Override
  public void updateAddresses(List<EquivalentAddressGroup> addrs) {
    delegate().updateAddresses(addrs);
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this).add("delegate", delegate()).toString();
  }
}
