/*
 * Copyright (C) 2020 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.annotations.GwtIncompatible;
import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableMultimap;
import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.Service.State;

/**
 * Superinterface of {@link ServiceManager} to introduce a bridge method for {@code
 * servicesByState()}, to ensure binary alluxio.shaded.client.com.atibility with older Guava versions that specified
 * {@code servicesByState()} to return {@code ImmutableMultimap}.
 */
@GwtIncompatible
interface ServiceManagerBridge {
  ImmutableMultimap<State, Service> servicesByState();
}
