/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.WriteType;
import alluxio.client.block.stream.DataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.SessionIdUtils;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.io.BlockWriter;
import java.io.IOException;

@NotThreadSafe
public final class BlockWorkerDataWriter
implements DataWriter {
    private final long mBlockId;
    private final BlockWriter mBlockWriter;
    private final BlockWorker mBlockWorker;
    private final int mChunkSize;
    private final OutStreamOptions mOptions;
    private final long mSessionId;
    private final long mBufferSize;
    private long mReservedBytes;

    public static BlockWorkerDataWriter create(FileSystemContext context, long blockId, long blockSize, OutStreamOptions options) throws IOException {
        AlluxioConfiguration conf = context.getClusterConf();
        int chunkSize = (int)conf.getBytes(PropertyKey.USER_LOCAL_WRITER_CHUNK_SIZE_BYTES);
        long reservedBytes = Math.min(blockSize, conf.getBytes(PropertyKey.USER_FILE_RESERVED_BYTES));
        BlockWorker blockWorker = context.getProcessLocalWorker();
        Preconditions.checkNotNull(blockWorker, "blockWorker");
        long sessionId = SessionIdUtils.createSessionId();
        try {
            blockWorker.createBlock(sessionId, blockId, options.getWriteTier(), options.getMediumType(), reservedBytes);
            BlockWriter blockWriter = blockWorker.createBlockWriter(sessionId, blockId);
            return new BlockWorkerDataWriter(sessionId, blockId, options, blockWriter, blockWorker, chunkSize, reservedBytes, conf);
        }
        catch (BlockAlreadyExistsException | BlockDoesNotExistException | InvalidWorkerStateException | WorkerOutOfSpaceException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long pos() {
        return this.mBlockWriter.getPosition();
    }

    @Override
    public int chunkSize() {
        return this.mChunkSize;
    }

    @Override
    public void writeChunk(ByteBuf buf) throws IOException {
        if (this.mReservedBytes < this.pos() + (long)buf.readableBytes()) {
            try {
                long bytesToReserve = Math.max(this.mBufferSize, this.pos() + (long)buf.readableBytes() - this.mReservedBytes);
                this.mBlockWorker.requestSpace(this.mSessionId, this.mBlockId, bytesToReserve);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        long append = this.mBlockWriter.append(buf);
        MetricsSystem.counter(MetricKey.WORKER_BYTES_WRITTEN_DIRECT.getName()).inc(append);
        MetricsSystem.meter(MetricKey.WORKER_BYTES_WRITTEN_DIRECT_THROUGHPUT.getName()).mark(append);
    }

    @Override
    public void cancel() throws IOException {
        this.mBlockWriter.close();
        try {
            this.mBlockWorker.abortBlock(this.mSessionId, this.mBlockId);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.mBlockWorker.cleanupSession(this.mSessionId);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.mBlockWriter.close();
        try {
            this.mBlockWorker.commitBlock(this.mSessionId, this.mBlockId, this.mOptions.getWriteType() == WriteType.ASYNC_THROUGH);
        }
        catch (Exception e) {
            this.mBlockWorker.cleanupSession(this.mSessionId);
            throw new IOException(e);
        }
    }

    private BlockWorkerDataWriter(long sessionId, long blockId, OutStreamOptions options, BlockWriter blockWriter, BlockWorker blockWorker, int chunkSize, long reservedBytes, AlluxioConfiguration conf) {
        this.mBlockWorker = blockWorker;
        this.mBlockWriter = blockWriter;
        this.mChunkSize = chunkSize;
        this.mBlockId = blockId;
        this.mOptions = options;
        this.mSessionId = sessionId;
        this.mReservedBytes = reservedBytes;
        this.mBufferSize = conf.getBytes(PropertyKey.USER_FILE_BUFFER_BYTES);
    }
}

