/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.FormatUtils;
import alluxio.wire.MountPointInfo;

@ThreadSafe
public class UIMountPointInfo {
    private String mMountPoint = "";
    private String mUfsUri = "";
    private String mUfsType = "";
    private long mUfsCapacityBytes;
    private long mUfsUsedBytes;
    private boolean mReadOnly;
    private boolean mShared;

    public UIMountPointInfo(String mountPoint, MountPointInfo mountPointInfo) {
        this.mMountPoint = mountPoint;
        this.mUfsUri = mountPointInfo.getUfsUri();
        this.mUfsType = mountPointInfo.getUfsType();
        this.mUfsCapacityBytes = mountPointInfo.getUfsCapacityBytes();
        this.mUfsUsedBytes = mountPointInfo.getUfsUsedBytes();
        this.mReadOnly = mountPointInfo.getReadOnly();
        this.mShared = mountPointInfo.getShared();
    }

    public String getUfsCapacityBytes() {
        return FormatUtils.getSizeFromBytes(this.mUfsCapacityBytes);
    }

    public String getUfsUsedBytes() {
        return FormatUtils.getSizeFromBytes(this.mUfsUsedBytes);
    }

    public String getMountPoint() {
        return this.mMountPoint;
    }

    public String getUfsType() {
        return this.mUfsType;
    }

    public String getUfsUri() {
        return this.mUfsUri;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public boolean isShared() {
        return this.mShared;
    }
}

