/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio;

/**
 * Project constants from alluxio.shaded.client.com.ilation time by maven.
 */
public final class ProjectConstants {
  /* Project version, specified in maven property. **/
  public static final String VERSION = "2.6.2-3";
  /* The latest git revision of at the time of building**/
  public static final String REVISION = "8c161f063453590dedbe7ea248621e87c8d33e34";
  /* Hadoop version, specified in maven property. **/
  public static final String HADOOP_VERSION = "3.3.0";
  /* Whether update check is enabled. **/
  public static final String UPDATE_CHECK_ENABLED = "true";
  /* Update check host. **/
  public static final String UPDATE_CHECK_HOST = "https://diagnostics.alluxio.alluxio.shaded.client.io.;
  /* Update check auth string. **/
  public static final String UPDATE_CHECK_MAGIC_NUMBER = "YWxsdXhpbzp0YWNoeW9u";

  private ProjectConstants() {} // prevent instantiation
}
