/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.client.metrics;

import alluxio.shaded.client.com.codahale.metrics.Counter;

/**
 * Metric item for each scope, might contain multiple keys defined in MetricKeyInScope.
 */
public class MetricItem {
  private final Counter[] mCounters;

  MetricItem() {
    mCounters = new Counter[ScopedMetricKey.values().length];
    for (int i = 0; i < ScopedMetricKey.values().length; i++) {
      mCounters[i] = new Counter();
    }
  }

  long inc(ScopedMetricKey key, long n) {
    mCounters[key.ordinal()].inc(n);
    return getCount(key);
  }

  long getCount(ScopedMetricKey key) {
    return mCounters[key.ordinal()].getCount();
  }
}
