package alluxio.shaded.client.org.checkerframework.checker.alluxio.shaded.client.com.ilermsgs.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultFor;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;
import alluxio.shaded.client.org.checkerframework.framework.qual.TargetLocations;
import alluxio.shaded.client.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type in the Compiler Message Key type system. Programmers should rarely write this
 * type.
 *
 * @checker_framework.manual #alluxio.shaded.client.com.ilermsgs-checker Compiler Message Key Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@SubtypeOf(CompilerMessageKey.class)
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@DefaultFor(TypeUseLocation.LOWER_BOUND)
public @interface CompilerMessageKeyBottom {}
