/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.client.metrics.LocalCacheMetrics;
import alluxio.client.metrics.ScopedMetricKey;
import alluxio.client.metrics.ScopedMetrics;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.hash.BloomFilter;
import alluxio.shaded.client.com.google.common.hash.Funnel;
import alluxio.shaded.client.com.google.common.hash.PrimitiveSink;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class CacheManagerWithShadowCache
implements CacheManager {
    private final CacheManager mCacheManager;
    private final int mNumBloomFilter;
    private final long mBloomFilterExpectedInsertions;
    private final AtomicReferenceArray<BloomFilter<PageId>> mSegmentBloomFilters;
    private final AtomicIntegerArray mObjEachBloomFilter;
    private final AtomicLongArray mByteEachBloomFilter;
    private final AtomicLong mShadowCachePageRead = new AtomicLong(0L);
    private final AtomicLong mShadowCachePageHit = new AtomicLong(0L);
    private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(0);
    private final AtomicLong mShadowCacheByteRead = new AtomicLong(0L);
    private long mShadowCacheBytes = 0L;
    private final AtomicLong mShadowCacheByteHit = new AtomicLong(0L);
    private int mCurrentSegmentFilterIndex = 0;
    private BloomFilter<PageId> mWorkingSetBloomFilter;
    private long mShadowCachePages = 0L;
    private double mAvgPageSize;
    private final ScopedMetrics mScopedMetrics;

    public CacheManagerWithShadowCache(CacheManager cacheManager, AlluxioConfiguration conf) {
        this.mCacheManager = cacheManager;
        long windowMs = conf.getMs(PropertyKey.USER_CLIENT_CACHE_SHADOW_WINDOW);
        this.mNumBloomFilter = conf.getInt(PropertyKey.USER_CLIENT_CACHE_SHADOW_BLOOMFILTER_NUM);
        long perBloomFilterMemoryOverhead = conf.getBytes(PropertyKey.USER_CLIENT_CACHE_SHADOW_MEMORY_OVERHEAD) / (long)(this.mNumBloomFilter + 1);
        this.mBloomFilterExpectedInsertions = (long)((double)(-perBloomFilterMemoryOverhead) * Math.log(2.0) * Math.log(2.0) / Math.log(0.03));
        this.mObjEachBloomFilter = new AtomicIntegerArray(new int[this.mNumBloomFilter]);
        this.mByteEachBloomFilter = new AtomicLongArray(new long[this.mNumBloomFilter]);
        this.mSegmentBloomFilters = new AtomicReferenceArray<BloomFilter>(new BloomFilter[this.mNumBloomFilter]);
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            this.mSegmentBloomFilters.set(i, BloomFilter.create(PageIdFunnel.FUNNEL, this.mBloomFilterExpectedInsertions));
        }
        this.mWorkingSetBloomFilter = BloomFilter.create(PageIdFunnel.FUNNEL, this.mBloomFilterExpectedInsertions);
        this.mScheduler.scheduleAtFixedRate(this::switchBloomFilter, 0L, windowMs / (long)this.mNumBloomFilter, TimeUnit.MILLISECONDS);
        this.mScopedMetrics = LocalCacheMetrics.Factory.get(conf).getShadowCacheMetricsInScope();
    }

    @VisibleForTesting
    public void stopUpdate() {
        this.mScheduler.shutdown();
    }

    @VisibleForTesting
    public void updateWorkingSetSize() {
        this.updateAvgPageSize();
        long oldPages = Metrics.SHADOW_CACHE_PAGES.getCount();
        this.mShadowCachePages = (int)this.mWorkingSetBloomFilter.approximateElementCount();
        Metrics.SHADOW_CACHE_PAGES.inc(this.mShadowCachePages - oldPages);
        long oldBytes = Metrics.SHADOW_CACHE_BYTES.getCount();
        this.mShadowCacheBytes = (long)((double)this.mShadowCachePages * this.mAvgPageSize);
        long bytesDiff = this.mShadowCacheBytes - oldBytes;
        Metrics.SHADOW_CACHE_BYTES.inc(bytesDiff);
    }

    @Override
    public boolean put(PageId pageId, byte[] page, CacheContext cacheContext) {
        this.updateBloomFilterAndWorkingSet(pageId, page.length, cacheContext);
        return this.mCacheManager.put(pageId, page, cacheContext);
    }

    private void updateBloomFilterAndWorkingSet(PageId pageId, int pageLength, CacheContext cacheContext) {
        int filterIndex = this.mCurrentSegmentFilterIndex;
        BloomFilter<PageId> bf = this.mSegmentBloomFilters.get(filterIndex);
        if (!bf.mightContain(pageId)) {
            bf.put(pageId);
            this.mObjEachBloomFilter.getAndIncrement(filterIndex);
            this.mByteEachBloomFilter.getAndAdd(filterIndex, pageLength);
            this.mWorkingSetBloomFilter.put(pageId);
            this.updateFalsePositiveRatio();
            this.updateWorkingSetSize();
            if (cacheContext != null) {
                cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES.getName(), pageLength);
                this.mScopedMetrics.inc(cacheContext.getCacheScope(), ScopedMetricKey.BYTES_IN_CACHE, pageLength);
            }
        }
    }

    private void updateFalsePositiveRatio() {
        int falsePositiveRatio = (int)this.mWorkingSetBloomFilter.expectedFpp() * 100;
        long oldFalsePositiveRatio = Metrics.SHADOW_CACHE_FALSE_POSITIVE_RATIO.getCount();
        Metrics.SHADOW_CACHE_FALSE_POSITIVE_RATIO.inc((long)falsePositiveRatio - oldFalsePositiveRatio);
    }

    private void updateAvgPageSize() {
        int nInsert = 0;
        long nByte = 0L;
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            nInsert += this.mObjEachBloomFilter.get(i);
            nByte += this.mByteEachBloomFilter.get(i);
        }
        this.mAvgPageSize = nInsert == 0 ? 0.0 : (double)nByte / (double)nInsert;
    }

    public void switchBloomFilter() {
        this.updateAvgPageSize();
        this.mCurrentSegmentFilterIndex = (this.mCurrentSegmentFilterIndex + 1) % this.mNumBloomFilter;
        this.mSegmentBloomFilters.set(this.mCurrentSegmentFilterIndex, BloomFilter.create(PageIdFunnel.FUNNEL, this.mBloomFilterExpectedInsertions));
        this.mObjEachBloomFilter.set(this.mCurrentSegmentFilterIndex, 0);
        this.mByteEachBloomFilter.set(this.mCurrentSegmentFilterIndex, 0L);
        this.mWorkingSetBloomFilter = BloomFilter.create(PageIdFunnel.FUNNEL, this.mBloomFilterExpectedInsertions);
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            this.mWorkingSetBloomFilter.putAll(this.mSegmentBloomFilters.get(i));
        }
        this.mScopedMetrics.switchOrClear();
    }

    public long getShadowCachePages() {
        return this.mShadowCachePages;
    }

    public long getShadowCacheBytes() {
        return this.mShadowCacheBytes;
    }

    public long getShadowCachePageRead() {
        return this.mShadowCachePageRead.get();
    }

    public long getShadowCachePageHit() {
        return this.mShadowCachePageHit.get();
    }

    public long getShadowCacheByteRead() {
        return this.mShadowCacheByteRead.get();
    }

    public long getShadowCacheByteHit() {
        return this.mShadowCacheByteHit.get();
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer, CacheContext cacheContext) {
        boolean seen = false;
        for (int i = 0; i < this.mSegmentBloomFilters.length(); ++i) {
            seen |= this.mSegmentBloomFilters.get(i).mightContain(pageId);
        }
        if (seen) {
            Metrics.SHADOW_CACHE_PAGES_HIT.inc();
            Metrics.SHADOW_CACHE_BYTES_HIT.inc(bytesToRead);
            this.mShadowCachePageHit.getAndIncrement();
            this.mShadowCacheByteHit.getAndAdd(bytesToRead);
            this.mScopedMetrics.inc(cacheContext.getCacheScope(), ScopedMetricKey.BYTES_READ_CACHE, bytesToRead);
        } else {
            this.updateBloomFilterAndWorkingSet(pageId, bytesToRead, cacheContext);
            this.mScopedMetrics.inc(cacheContext.getCacheScope(), ScopedMetricKey.BYTES_READ_EXTERNAL, bytesToRead);
        }
        Metrics.SHADOW_CACHE_PAGES_READ.inc();
        Metrics.SHADOW_CACHE_BYTES_READ.inc(bytesToRead);
        this.mShadowCachePageRead.getAndIncrement();
        this.mShadowCacheByteRead.getAndAdd(bytesToRead);
        return this.mCacheManager.get(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer, cacheContext);
    }

    @Override
    public boolean delete(PageId pageId) {
        return this.mCacheManager.delete(pageId);
    }

    @Override
    public CacheManager.State state() {
        return this.mCacheManager.state();
    }

    @Override
    public void close() throws Exception {
        this.mCacheManager.close();
    }

    private static final class Metrics {
        private static final Counter SHADOW_CACHE_BYTES_READ = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES_READ.getName());
        private static final Counter SHADOW_CACHE_BYTES_HIT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES_HIT.getName());
        private static final Counter SHADOW_CACHE_PAGES_READ = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_PAGES_READ.getName());
        private static final Counter SHADOW_CACHE_PAGES_HIT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_PAGES_HIT.getName());
        private static final Counter SHADOW_CACHE_PAGES = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_PAGES.getName());
        private static final Counter SHADOW_CACHE_BYTES = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES.getName());
        private static final Counter SHADOW_CACHE_FALSE_POSITIVE_RATIO = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_FALSE_POSITIVE_RATIO.getName());

        private Metrics() {
        }
    }

    public static enum PageIdFunnel implements Funnel<PageId>
    {
        FUNNEL;


        @Override
        public void funnel(PageId from, PrimitiveSink into) {
            into.putUnencodedChars(from.getFileId()).putLong(from.getPageIndex());
        }
    }
}

