/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.DefaultMetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.metrics.LocalCacheMetrics;
import alluxio.client.metrics.ScopedMetricKey;
import alluxio.client.metrics.ScopedMetrics;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.PageNotFoundException;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class QuotaMetaStore
extends DefaultMetaStore {
    private final ScopedMetrics mScopedMetrics;
    private final Map<CacheScope, CacheEvictor> mCacheEvictors;
    private final Supplier<CacheEvictor> mSupplier;

    public QuotaMetaStore(AlluxioConfiguration conf) {
        super(conf);
        this.mScopedMetrics = LocalCacheMetrics.Factory.get(conf).getLocalCacheMetricsInScope();
        this.mCacheEvictors = new ConcurrentHashMap<CacheScope, CacheEvictor>();
        this.mSupplier = () -> CacheEvictor.create(conf);
    }

    @Override
    public void addPage(PageId pageId, PageInfo pageInfo) {
        super.addPage(pageId, pageInfo);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            this.mScopedMetrics.inc(cacheScope, ScopedMetricKey.BYTES_IN_CACHE, pageInfo.getPageSize());
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnPut(pageId);
        }
    }

    @Override
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        PageInfo pageInfo = super.getPageInfo(pageId);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnPut(pageId);
        }
        return pageInfo;
    }

    @Override
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        PageInfo pageInfo = super.removePage(pageId);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            this.mScopedMetrics.dec(cacheScope, ScopedMetricKey.BYTES_IN_CACHE, pageInfo.getPageSize());
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnDelete(pageId);
        }
        return pageInfo;
    }

    public long bytes(CacheScope cacheScope) {
        if (cacheScope == CacheScope.GLOBAL) {
            return this.bytes();
        }
        return this.mScopedMetrics.getCount(cacheScope, ScopedMetricKey.BYTES_IN_CACHE);
    }

    @Override
    public void reset() {
        super.reset();
        for (CacheEvictor evictor : this.mCacheEvictors.values()) {
            evictor.reset();
        }
        this.mScopedMetrics.switchOrClear();
    }

    @Nullable
    public PageInfo evict(CacheScope cacheScope) {
        if (cacheScope == CacheScope.GLOBAL) {
            return this.evict();
        }
        CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
        return this.evictInternal(evictor);
    }
}

