/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.client.metrics.InMemoryScopedMetrics;
import alluxio.client.metrics.ScopedMetricKey;
import alluxio.client.metrics.ScopedMetrics;
import alluxio.client.quota.CacheScope;
import java.util.HashSet;
import java.util.Set;

public class SegmentedScopedMetrics
implements ScopedMetrics {
    private final int mNumOfSegments;
    private final ScopedMetrics[] mSegmentedMetrics;
    private int mCurrentSegmentIndex;

    SegmentedScopedMetrics(int numOfSegments) {
        this.mNumOfSegments = numOfSegments;
        this.mSegmentedMetrics = new ScopedMetrics[numOfSegments];
        for (int i = 0; i < numOfSegments; ++i) {
            this.mSegmentedMetrics[i] = new InMemoryScopedMetrics();
        }
    }

    @Override
    public void switchOrClear() {
        int newSegmentIndex = (this.mCurrentSegmentIndex + 1) % this.mNumOfSegments;
        this.mSegmentedMetrics[newSegmentIndex].switchOrClear();
        this.mCurrentSegmentIndex = newSegmentIndex;
    }

    @Override
    public Set<CacheScope> getAllCacheScopes() {
        HashSet<CacheScope> metricsKeys = new HashSet<CacheScope>();
        for (int i = 0; i < this.mNumOfSegments; ++i) {
            metricsKeys.addAll(this.mSegmentedMetrics[i].getAllCacheScopes());
        }
        return metricsKeys;
    }

    @Override
    public long inc(CacheScope scope, ScopedMetricKey scopedMetricKey, long n) {
        return this.mSegmentedMetrics[this.mCurrentSegmentIndex].inc(scope, scopedMetricKey, n);
    }

    @Override
    public long getCount(CacheScope scope, ScopedMetricKey scopedMetricKey) {
        long sum = 0L;
        for (int i = 0; i < this.mNumOfSegments; ++i) {
            sum += this.mSegmentedMetrics[i].getCount(scope, scopedMetricKey);
        }
        return sum;
    }
}

