/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.client.metrics;

/**
 * Metric keys of each scope.
 */
public enum ScopedMetricKey {
  /** Bytes stored of this scope in cache.*/
  BYTES_IN_CACHE("Client.BytesInCacheInScope"),
  /** Cache hits. Bytes read of this scope from cache.*/
  BYTES_READ_CACHE("Client.BytesReadCacheInScope"),
  /** Bytes read of this scope from external,
   * may be larger than requests due to reading alluxio.shaded.client.com.lete pages.*/
  BYTES_READ_EXTERNAL("Client.BytesReadExternalInScope");

  private final String mName;

  ScopedMetricKey(String name) {
    mName = name;
  }

  /**
   * @return the name of the scoped metric key
   */
  public String getName() {
    return mName;
  }
}
