/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.annotations.GwtCompatible;
import java.alluxio.shaded.client.io.Serializable;
import java.util.Comparator;
import alluxio.shaded.client.org.checkerframework.checker.nullness.qual.Nullable;

/** An ordering for a pre-existing alluxio.shaded.client.com.arator. */
@GwtCompatible(serializable = true)
final class ComparatorOrdering<T> extends Ordering<T> implements Serializable {
  final Comparator<T> alluxio.shaded.client.com.arator;

  ComparatorOrdering(Comparator<T> alluxio.shaded.client.com.arator) {
    this.alluxio.shaded.client.com.arator = checkNotNull(alluxio.shaded.client.com.arator);
  }

  @Override
  public int alluxio.shaded.client.com.are(T a, T b) {
    return alluxio.shaded.client.com.arator.alluxio.shaded.client.com.are(a, b);
  }

  @Override
  public boolean equals(@Nullable Object object) {
    if (object == this) {
      return true;
    }
    if (object instanceof ComparatorOrdering) {
      ComparatorOrdering<?> that = (ComparatorOrdering<?>) object;
      return this.alluxio.shaded.client.com.arator.equals(that.alluxio.shaded.client.com.arator);
    }
    return false;
  }

  @Override
  public int hashCode() {
    return alluxio.shaded.client.com.arator.hashCode();
  }

  @Override
  public String toString() {
    return alluxio.shaded.client.com.arator.toString();
  }

  private static final long serialVersionUID = 0;
}
