package alluxio.shaded.client.javassist.convert;

import alluxio.shaded.client.javassist.CtMethod;
import alluxio.shaded.client.javassist.bytecode.BadBytecode;
import alluxio.shaded.client.javassist.bytecode.CodeIterator;
import alluxio.shaded.client.javassist.bytecode.ConstPool;
import alluxio.shaded.client.javassist.bytecode.Descriptor;
import alluxio.shaded.client.javassist.bytecode.Opcode;

public class TransformCallToStatic extends TransformCall {
    public TransformCallToStatic(Transformer next, CtMethod origMethod, CtMethod substMethod) {
        super(next, origMethod, substMethod);
        methodDescriptor = origMethod.getMethodInfo2().getDescriptor();
    }

    @Override
    protected int match(int c, int pos, CodeIterator iterator, int typedesc, ConstPool cp) {
        if (newIndex == 0) {
            String desc = Descriptor.insertParameter(classname, methodDescriptor);
            int nt = cp.addNameAndTypeInfo(newMethodname, desc);
            int ci = cp.addClassInfo(newClassname);
            newIndex = cp.addMethodrefInfo(ci, nt);
            constPool = cp;
        }
        iterator.writeByte(Opcode.INVOKESTATIC, pos);
        iterator.write16bit(newIndex, pos + 1);
        return pos;
    }
}
