/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.alluxio.shaded.client.org.>.
 *
 */

/**
 * Core HTTP alluxio.shaded.client.com.onent APIs and primitives.
 * <p>
 * These deal with the fundamental things required for using the
 * HTTP protocol, such as representing a
 * {@link alluxio.shaded.client.org.apache.http.HttpMessage message} including it's
 * {@link alluxio.shaded.client.org.apache.http.Header headers} and optional
 * {@link alluxio.shaded.client.org.apache.http.HttpEntity entity}, and
 * {@link alluxio.shaded.client.org.apache.http.HttpConnection connections}
 * over which messages are sent. In order to prepare messages
 * before sending or after receiving, there are interceptors for
 * {@link alluxio.shaded.client.org.apache.http.HttpRequestInterceptor requests} and
 * {@link alluxio.shaded.client.org.apache.http.HttpResponseInterceptor responses}.
 * </p>
 */
package alluxio.shaded.client.org.apache.http;
