/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.client.metrics.MetricItem;
import alluxio.client.metrics.ScopedMetricKey;
import alluxio.client.metrics.ScopedMetrics;
import alluxio.client.quota.CacheScope;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class InMemoryScopedMetrics
implements ScopedMetrics {
    Map<CacheScope, MetricItem> mMetrics = new ConcurrentHashMap<CacheScope, MetricItem>();

    InMemoryScopedMetrics() {
    }

    @Override
    public Set<CacheScope> getAllCacheScopes() {
        return Collections.unmodifiableSet(this.mMetrics.keySet());
    }

    @Override
    public long inc(CacheScope scope, ScopedMetricKey scopedMetricKey, long n) {
        return this.getMetricItem(scope).inc(scopedMetricKey, n);
    }

    @Override
    public long getCount(CacheScope scope, ScopedMetricKey scopedMetricKey) {
        return this.getMetricItem(scope).getCount(scopedMetricKey);
    }

    @Override
    public void switchOrClear() {
        this.mMetrics.clear();
    }

    private MetricItem getMetricItem(CacheScope scope) {
        return this.mMetrics.computeIfAbsent(scope, k -> new MetricItem());
    }
}

