/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.client.metrics.AlluxioSystemScopedMetrics;
import alluxio.client.metrics.InMemoryScopedMetrics;
import alluxio.client.metrics.NoOpScopedMetrics;
import alluxio.client.metrics.ScopedMetrics;
import alluxio.client.metrics.ScopedMetricsType;
import alluxio.client.metrics.SegmentedScopedMetrics;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;

public class LocalCacheMetrics {
    private ScopedMetrics mLocalCacheScopedMetrics;
    private ScopedMetrics mShadowCacheScopedMetrics;

    private LocalCacheMetrics() {
    }

    public ScopedMetrics getLocalCacheMetricsInScope() {
        return this.mLocalCacheScopedMetrics;
    }

    private void setLocalCacheMetricsInScope(ScopedMetrics localCacheScopedMetrics) {
        this.mLocalCacheScopedMetrics = localCacheScopedMetrics;
    }

    public ScopedMetrics getShadowCacheMetricsInScope() {
        return this.mShadowCacheScopedMetrics;
    }

    private void setShadowCacheMetricsInScope(ScopedMetrics shadowCacheScopedMetrics) {
        this.mShadowCacheScopedMetrics = shadowCacheScopedMetrics;
    }

    public static class Factory {
        private static LocalCacheMetrics sMetrics;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static LocalCacheMetrics get(AlluxioConfiguration conf) {
            if (sMetrics != null) return sMetrics;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (sMetrics != null) return sMetrics;
                sMetrics = Factory.create(conf);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sMetrics;
            }
        }

        private static LocalCacheMetrics create(AlluxioConfiguration conf) {
            LocalCacheMetrics metrics = new LocalCacheMetrics();
            ScopedMetricsType metricsType = conf.getEnum(PropertyKey.USER_CLIENT_CACHE_SCOPED_METRICS_COLLECTING_TYPE, ScopedMetricsType.class);
            switch (metricsType) {
                case ALLUXIO_SYSTEM: {
                    metrics.setLocalCacheMetricsInScope(new AlluxioSystemScopedMetrics());
                    break;
                }
                case IN_MEMORY: {
                    metrics.setLocalCacheMetricsInScope(new InMemoryScopedMetrics());
                    break;
                }
                case NO_OP: {
                    if (conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_QUOTA_ENABLED)) {
                        metrics.setLocalCacheMetricsInScope(new InMemoryScopedMetrics());
                        break;
                    }
                    metrics.setLocalCacheMetricsInScope(new NoOpScopedMetrics());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported scoped metrics type:" + (Object)((Object)metricsType));
                }
            }
            if (conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_SHADOW_METRICS_BREAKDOWN_ENABLED)) {
                int numOfSegments = conf.getInt(PropertyKey.USER_CLIENT_CACHE_SHADOW_BLOOMFILTER_NUM);
                metrics.setShadowCacheMetricsInScope(new SegmentedScopedMetrics(numOfSegments));
            } else {
                metrics.setShadowCacheMetricsInScope(new NoOpScopedMetrics());
            }
            return metrics;
        }
    }
}

