/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class EventCounter
extends AppenderSkeleton {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static EventCounts sCount = new EventCounts();

    public static long getFatal() {
        return EventCounter.sCount.get(0);
    }

    public static long getError() {
        return EventCounter.sCount.get(1);
    }

    public static long getWarn() {
        return EventCounter.sCount.get(2);
    }

    public static long getInfo() {
        return EventCounter.sCount.get(3);
    }

    public void append(LoggingEvent event) {
        Level level = event.getLevel();
        if (level.equals((Object)Level.INFO)) {
            EventCounter.sCount.incr(3);
        } else if (level.equals((Object)Level.WARN)) {
            EventCounter.sCount.incr(2);
        } else if (level.equals((Object)Level.ERROR)) {
            EventCounter.sCount.incr(1);
        } else if (level.equals((Object)Level.FATAL)) {
            EventCounter.sCount.incr(0);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    private static class EventCounts {
        private final long[] mCounts = new long[]{0L, 0L, 0L, 0L};

        private EventCounts() {
        }

        private synchronized void incr(int i) {
            int n = i;
            this.mCounts[n] = this.mCounts[n] + 1L;
        }

        private synchronized long get(int i) {
            return this.mCounts[i];
        }
    }
}

