/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.client.ReadType;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CheckConsistencyPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadDescendantPType;
import alluxio.grpc.LoadMetadataPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.UnmountPOptions;
import alluxio.grpc.WritePType;
import alluxio.security.authorization.Mode;
import alluxio.util.ModeUtils;

public class FileSystemOptions {
    public static ScheduleAsyncPersistencePOptions scheduleAsyncPersistenceDefaults(AlluxioConfiguration conf) {
        return ScheduleAsyncPersistencePOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setPersistenceWaitTime(0L).build();
    }

    public static CreateDirectoryPOptions createDirectoryDefaults(AlluxioConfiguration conf) {
        return CreateDirectoryPOptions.newBuilder().setAllowExists(false).setCommonOptions(FileSystemOptions.commonDefaults(conf)).setMode(ModeUtils.applyDirectoryUMask(Mode.defaults(), conf.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK)).toProto()).setRecursive(false).setWriteType(conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WritePType.class)).build();
    }

    public static CheckAccessPOptions checkAccessDefaults(AlluxioConfiguration conf) {
        return CheckAccessPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).build();
    }

    public static CheckConsistencyPOptions checkConsistencyDefaults(AlluxioConfiguration conf) {
        return CheckConsistencyPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).build();
    }

    public static CreateFilePOptions createFileDefaults(AlluxioConfiguration conf) {
        return CreateFilePOptions.newBuilder().setBlockSizeBytes(conf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT)).setCommonOptions(FileSystemOptions.commonDefaults(conf)).setMode(ModeUtils.applyFileUMask(Mode.defaults(), conf.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK)).toProto()).setPersistenceWaitTime(conf.getMs(PropertyKey.USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME)).setRecursive(false).setReplicationDurable(conf.getInt(PropertyKey.USER_FILE_REPLICATION_DURABLE)).setReplicationMax(conf.getInt(PropertyKey.USER_FILE_REPLICATION_MAX)).setReplicationMin(conf.getInt(PropertyKey.USER_FILE_REPLICATION_MIN)).setWriteTier(conf.getInt(PropertyKey.USER_FILE_WRITE_TIER_DEFAULT)).setWriteType(conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WritePType.class)).build();
    }

    public static DeletePOptions deleteDefaults(AlluxioConfiguration conf) {
        return DeletePOptions.newBuilder().setAlluxioOnly(false).setCommonOptions(FileSystemOptions.commonDefaults(conf)).setRecursive(false).setUnchecked(conf.getBoolean(PropertyKey.USER_FILE_DELETE_UNCHECKED)).build();
    }

    public static ExistsPOptions existsDefaults(AlluxioConfiguration conf) {
        return ExistsPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setLoadMetadataType(conf.getEnum(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.class)).build();
    }

    public static FileSystemMasterCommonPOptions commonDefaults(AlluxioConfiguration conf) {
        return FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(conf.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL)).setTtl(conf.getMs(PropertyKey.USER_FILE_CREATE_TTL)).setTtlAction(conf.getEnum(PropertyKey.USER_FILE_CREATE_TTL_ACTION, TtlAction.class)).build();
    }

    public static FreePOptions freeDefaults(AlluxioConfiguration conf) {
        return FreePOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setForced(false).setRecursive(false).build();
    }

    public static GetStatusPOptions getStatusDefaults(AlluxioConfiguration conf) {
        return GetStatusPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setLoadMetadataType(conf.getEnum(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.class)).build();
    }

    public static ListStatusPOptions listStatusDefaults(AlluxioConfiguration conf) {
        return ListStatusPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setLoadMetadataType(conf.getEnum(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.class)).setLoadMetadataOnly(false).build();
    }

    public static LoadMetadataPOptions loadMetadataDefaults(AlluxioConfiguration conf) {
        return LoadMetadataPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setCreateAncestors(false).setLoadDescendantType(LoadDescendantPType.NONE).setRecursive(false).build();
    }

    public static MountPOptions mountDefaults(AlluxioConfiguration conf) {
        return MountPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setReadOnly(false).setShared(false).build();
    }

    public static OpenFilePOptions openFileDefaults(AlluxioConfiguration conf) {
        return OpenFilePOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setMaxUfsReadConcurrency(conf.getInt(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX)).setReadType(conf.getEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.class).toProto()).build();
    }

    public static RenamePOptions renameDefaults(AlluxioConfiguration conf) {
        return RenamePOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setPersist(conf.getBoolean(PropertyKey.USER_FILE_PERSIST_ON_RENAME)).build();
    }

    public static ScheduleAsyncPersistencePOptions scheduleAsyncPersistDefaults(AlluxioConfiguration conf) {
        return ScheduleAsyncPersistencePOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).build();
    }

    public static SetAclPOptions setAclDefaults(AlluxioConfiguration conf) {
        return SetAclPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setRecursive(false).build();
    }

    public static SetAttributePOptions setAttributeDefaults(AlluxioConfiguration conf) {
        return SetAttributePOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).setRecursive(false).build();
    }

    public static SetAttributePOptions setAttributeClientDefaults(AlluxioConfiguration conf) {
        return SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(conf.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL)).build()).build();
    }

    public static UnmountPOptions unmountDefaults(AlluxioConfiguration conf) {
        return UnmountPOptions.newBuilder().setCommonOptions(FileSystemOptions.commonDefaults(conf)).build();
    }
}

