/*
 * Copyright 2019 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.netty;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.MoreObjects;
import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Objects;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.Internal;
import alluxio.shaded.client.io.grpc.InternalChannelz.Security;
import alluxio.shaded.client.javax.annotation.CheckReturnValue;
import alluxio.shaded.client.javax.annotation.Nullable;

/**
 * Represents a alluxio.shaded.client.com.letion of a protocol negotiation stage.
 */
@CheckReturnValue
@Internal
public final class ProtocolNegotiationEvent {

  static final ProtocolNegotiationEvent DEFAULT =
      new ProtocolNegotiationEvent(Attributes.EMPTY, /*security=*/ null);

  private final Attributes attributes;
  @Nullable
  private final Security security;

  private ProtocolNegotiationEvent(Attributes attributes, @Nullable Security security) {
    this.attributes = checkNotNull(attributes, "attributes");
    this.security = security;
  }

  @Nullable
  Security getSecurity() {
    return security;
  }

  Attributes getAttributes() {
    return attributes;
  }

  ProtocolNegotiationEvent withAttributes(Attributes attributes) {
    return new ProtocolNegotiationEvent(attributes, this.security);
  }

  ProtocolNegotiationEvent withSecurity(@Nullable Security security) {
    return new ProtocolNegotiationEvent(this.attributes, security);
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this)
        .add("attributes", attributes)
        .add("security", security)
        .toString();
  }

  /**
   * This method is not efficient and is intended for testing.
   */
  @Override
  public int hashCode() {
    return Objects.hashCode(attributes, security);
  }

  @Override
  public boolean equals(Object other) {
    if (!(other instanceof ProtocolNegotiationEvent)) {
      return false;
    }
    ProtocolNegotiationEvent that = (ProtocolNegotiationEvent) other;
    return Objects.equal(this.attributes, that.attributes)
        && Objects.equal(this.security, that.security);
  }
}
