/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.LRUCacheEvictor;
import alluxio.conf.AlluxioConfiguration;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

@ThreadSafe
public class NondeterministicLRUCacheEvictor
extends LRUCacheEvictor {
    private int mNumOfCandidate = 16;

    public NondeterministicLRUCacheEvictor(AlluxioConfiguration conf) {
        super(conf);
    }

    public void setNumOfCandidate(int n) {
        this.mNumOfCandidate = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PageId evict() {
        Map map = this.mLRUCache;
        synchronized (map) {
            if (this.mLRUCache.isEmpty()) {
                return null;
            }
            Iterator it = this.mLRUCache.keySet().iterator();
            PageId evictionCandidate = (PageId)it.next();
            int numMoveFromTail = ThreadLocalRandom.current().nextInt(this.mNumOfCandidate);
            for (int i = 0; it.hasNext() && i < numMoveFromTail; ++i) {
                evictionCandidate = (PageId)it.next();
            }
            return evictionCandidate;
        }
    }
}

