/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.file.meta.PersistenceState;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.Ordering;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.webui.UIFileBlockInfo;
import alluxio.wire.FileInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ThreadSafe
public final class UIFileInfo {
    public static final Ordering<UIFileInfo> PATH_STRING_COMPARE = Ordering.natural().onResultOf(input -> input.mAbsolutePath);
    private final long mId;
    private final String mName;
    private final String mAbsolutePath;
    private final long mBlockSizeBytes;
    private final long mSize;
    private final long mCreationTimeMs;
    private final long mLastModificationTimeMs;
    private final boolean mInAlluxio;
    private final int mInAlluxioPercentage;
    private final boolean mIsDirectory;
    private final boolean mPinned;
    private final String mOwner;
    private final String mGroup;
    private final String mMode;
    private final String mPersistenceState;
    private final List<String> mFileLocations;
    private final AlluxioConfiguration mAlluxioConfiguration;
    private final List<String> mOrderedTierAliases;
    private final Map<String, List<UIFileBlockInfo>> mBlocksOnTier = new HashMap<String, List<UIFileBlockInfo>>();
    private final Map<String, Long> mSizeOnTier = new HashMap<String, Long>();
    private final List<Long> mBlockIds = new ArrayList<Long>();

    public UIFileInfo(URIStatus status, AlluxioConfiguration alluxioConfiguration, List<String> orderedTierAliases) {
        boolean hasExtended = status.getAcl().hasExtended() || !status.getDefaultAcl().isEmpty();
        this.mId = status.getFileId();
        this.mName = status.getName();
        this.mAbsolutePath = status.getPath();
        this.mBlockSizeBytes = status.getBlockSizeBytes();
        this.mSize = status.getLength();
        this.mCreationTimeMs = status.getCreationTimeMs();
        this.mLastModificationTimeMs = status.getLastModificationTimeMs();
        this.mInAlluxio = 100 == status.getInAlluxioPercentage();
        this.mInAlluxioPercentage = status.getInAlluxioPercentage();
        this.mIsDirectory = status.isFolder();
        this.mPinned = status.isPinned();
        this.mOwner = status.getOwner();
        this.mGroup = status.getGroup();
        this.mMode = FormatUtils.formatMode((short)status.getMode(), status.isFolder(), hasExtended);
        this.mPersistenceState = status.getPersistenceState();
        this.mFileLocations = new ArrayList<String>();
        this.mAlluxioConfiguration = alluxioConfiguration;
        this.mOrderedTierAliases = orderedTierAliases;
    }

    public UIFileInfo(FileInfo info, AlluxioConfiguration alluxioConfiguration, List<String> orderedTierAliases) {
        this(new URIStatus(info), alluxioConfiguration, orderedTierAliases);
    }

    public UIFileInfo(LocalFileInfo fileInfo, AlluxioConfiguration alluxioConfiguration, List<String> orderedTierAliases) {
        this.mId = -1L;
        this.mName = fileInfo.mName;
        this.mAbsolutePath = fileInfo.mAbsolutePath;
        this.mBlockSizeBytes = 0L;
        this.mSize = fileInfo.mSize;
        this.mCreationTimeMs = fileInfo.mCreationTimeMs;
        this.mLastModificationTimeMs = fileInfo.mLastModificationTimeMs;
        this.mInAlluxio = false;
        this.mInAlluxioPercentage = 0;
        this.mIsDirectory = fileInfo.mIsDirectory;
        this.mPinned = false;
        this.mOwner = "";
        this.mGroup = "";
        this.mMode = FormatUtils.formatMode(Mode.createNoAccess().toShort(), true, false);
        this.mPersistenceState = PersistenceState.NOT_PERSISTED.name();
        this.mFileLocations = new ArrayList<String>();
        this.mAlluxioConfiguration = alluxioConfiguration;
        this.mOrderedTierAliases = orderedTierAliases;
    }

    public void addBlock(String tierAlias, long blockId, long blockSize, long blockLastAccessTimeMs) {
        UIFileBlockInfo block = new UIFileBlockInfo(blockId, blockSize, blockLastAccessTimeMs, tierAlias, this.mAlluxioConfiguration);
        List blocksOnTier = this.mBlocksOnTier.computeIfAbsent(tierAlias, k -> new ArrayList());
        blocksOnTier.add(block);
        Long sizeOnTier = this.mSizeOnTier.get(tierAlias);
        this.mSizeOnTier.put(tierAlias, (sizeOnTier == null ? 0L : sizeOnTier) + blockSize);
        this.mBlockIds.add(blockId);
    }

    public String getAbsolutePath() {
        return this.mAbsolutePath;
    }

    public String getBlockSizeBytes() {
        if (this.mIsDirectory) {
            return "";
        }
        return FormatUtils.getSizeFromBytes(this.mBlockSizeBytes);
    }

    public Map<String, List<UIFileBlockInfo>> getBlocksOnTier() {
        return this.mBlocksOnTier;
    }

    public String getCreationTime() {
        if (this.mCreationTimeMs == 0L) {
            return "";
        }
        return CommonUtils.convertMsToDate(this.mCreationTimeMs, this.mAlluxioConfiguration.get(PropertyKey.USER_DATE_FORMAT_PATTERN));
    }

    public String getModificationTime() {
        return CommonUtils.convertMsToDate(this.mLastModificationTimeMs, this.mAlluxioConfiguration.get(PropertyKey.USER_DATE_FORMAT_PATTERN));
    }

    public List<String> getFileLocations() {
        return this.mFileLocations;
    }

    public long getId() {
        return this.mId;
    }

    public boolean getInAlluxio() {
        return this.mInAlluxio;
    }

    public int getInAlluxioPercentage() {
        return this.mInAlluxioPercentage;
    }

    public boolean getIsDirectory() {
        return this.mIsDirectory;
    }

    public boolean isPinned() {
        return this.mPinned;
    }

    public String getPersistenceState() {
        return this.mPersistenceState;
    }

    public Map<String, Integer> getOnTierPercentages() {
        return this.mOrderedTierAliases.stream().collect(Collectors.toMap(tier -> tier, tier -> {
            Long sizeOnTier = this.mSizeOnTier.getOrDefault(tier, 0L);
            return this.mSize > 0L ? (int)(100L * sizeOnTier / this.mSize) : 0;
        }));
    }

    public String getName() {
        if ("/".equals(this.mAbsolutePath)) {
            return "root";
        }
        return this.mName;
    }

    public String getSize() {
        if (this.mIsDirectory) {
            return "";
        }
        return FormatUtils.getSizeFromBytes(this.mSize);
    }

    public void setFileLocations(List<String> fileLocations) {
        this.mFileLocations.clear();
        this.mFileLocations.addAll(fileLocations);
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public String getMode() {
        return this.mMode;
    }

    public List<Long> getBlockIds() {
        return this.mBlockIds;
    }

    @ThreadSafe
    public static class LocalFileInfo {
        public static final long EMPTY_CREATION_TIME = 0L;
        private final String mName;
        private final String mAbsolutePath;
        private final long mSize;
        private final long mCreationTimeMs;
        private final long mLastModificationTimeMs;
        private final boolean mIsDirectory;

        public LocalFileInfo(String name, String absolutePath, long size, long creationTimeMs, long lastModificationTimeMs, boolean isDirectory) {
            this.mName = Preconditions.checkNotNull(name, "name");
            this.mAbsolutePath = Preconditions.checkNotNull(absolutePath, "absolutePath");
            this.mSize = size;
            this.mCreationTimeMs = creationTimeMs;
            this.mLastModificationTimeMs = lastModificationTimeMs;
            this.mIsDirectory = isDirectory;
        }
    }
}

