/*
 * Decompiled with CFR 0.152.
 */
package alluxio.concurrent;

import alluxio.concurrent.jsr.ForkJoinPool;
import alluxio.util.logging.SamplingLogger;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinPoolHelper {
    private static final Logger SAMPLING_LOG = new SamplingLogger(LoggerFactory.getLogger(ForkJoinPoolHelper.class), 30000L);

    public static void safeManagedBlock(ForkJoinPool.ManagedBlocker blocker) throws InterruptedException {
        try {
            ForkJoinPool.managedBlock(blocker);
        }
        catch (RejectedExecutionException re) {
            SAMPLING_LOG.warn("Failed to compensate rpc pool. Consider increasing thread pool size.", (Throwable)re);
            while (!blocker.isReleasable() && !blocker.block()) {
            }
        }
    }
}

