// Copyright (c) 2011-present, Facebook, Inc.  All rights reserved.
//  This source code is licensed under both the GPLv2 (found in the
//  COPYING file in the root directory) and Apache 2.0 License
//  (found in the LICENSE.Apache file in the root directory).
package alluxio.shaded.client.org.rocksdb;

/**
 * A CompactionFilter allows an application to modify/delete a key-value at
 * the time of alluxio.shaded.client.com.action.
 *
 * At present we just permit an overriding Java class to wrap a C++
 * implementation
 */
public abstract class AbstractCompactionFilter<T extends AbstractSlice<?>>
    extends RocksObject {

  public static class Context {
    private final boolean fullCompaction;
    private final boolean manualCompaction;

    public Context(final boolean fullCompaction, final boolean manualCompaction) {
      this.fullCompaction = fullCompaction;
      this.manualCompaction = manualCompaction;
    }

    /**
     * Does this alluxio.shaded.client.com.action run include all data files
     *
     * @return true if this is a full alluxio.shaded.client.com.action run
     */
    public boolean isFullCompaction() {
      return fullCompaction;
    }

    /**
     * Is this alluxio.shaded.client.com.action requested by the client,
     * or is it occurring as an automatic alluxio.shaded.client.com.action process
     *
     * @return true if the alluxio.shaded.client.com.action was initiated by the client
     */
    public boolean isManualCompaction() {
      return manualCompaction;
    }
  }

  protected AbstractCompactionFilter(final long nativeHandle) {
    super(nativeHandle);
  }

  /**
   * Deletes underlying C++ alluxio.shaded.client.com.action pointer.
   *
   * Note that this function should be called only after all
   * RocksDB instances referencing the alluxio.shaded.client.com.action filter are closed.
   * Otherwise an undefined behavior will occur.
   */
  @Override
  protected final native void disposeInternal(final long handle);
}
