/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.security.authorization.AccessControlList;
import alluxio.shaded.client.com.google.common.base.Splitter;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@NotThreadSafe
public final class Fingerprint {
    private static final Tag[] REQUIRED_TAGS = new Tag[]{Tag.TYPE, Tag.UFS, Tag.OWNER, Tag.GROUP, Tag.MODE};
    private static final Tag[] OPTIONAL_TAGS = new Tag[]{Tag.CONTENT_HASH, Tag.ACL};
    private static final Tag[] METADATA_TAGS = new Tag[]{Tag.OWNER, Tag.GROUP, Tag.MODE, Tag.ACL};
    private static final Tag[] CONTENT_TAGS = new Tag[]{Tag.TYPE, Tag.UFS, Tag.CONTENT_HASH};
    public static final Fingerprint INVALID_FINGERPRINT = new Fingerprint(Collections.emptyMap());
    private static final char KVDELIMTER = '|';
    private static final char TAGDELIMTER = ' ';
    private static final Pattern SANITIZE_REGEX = Pattern.compile("[| ]");
    public static final String UNDERSCORE = "_";
    private final Map<Tag, String> mValues = new HashMap<Tag, String>();

    public static Fingerprint create(String ufsName, UfsStatus status) {
        if (status == null) {
            return new Fingerprint(Collections.emptyMap());
        }
        return new Fingerprint(Fingerprint.createTags(ufsName, status));
    }

    public static Fingerprint create(String ufsName, UfsStatus status, AccessControlList acl) {
        if (status == null) {
            return new Fingerprint(Collections.emptyMap());
        }
        Map<Tag, String> tagMap = Fingerprint.createTags(ufsName, status);
        if (acl != null) {
            tagMap.put(Tag.ACL, acl.toString());
        }
        return new Fingerprint(tagMap);
    }

    private static Map<Tag, String> createTags(String ufsName, UfsStatus status) {
        HashMap<Tag, String> tagMap = new HashMap<Tag, String>();
        tagMap.put(Tag.UFS, ufsName);
        tagMap.put(Tag.OWNER, status.getOwner());
        tagMap.put(Tag.GROUP, status.getGroup());
        tagMap.put(Tag.MODE, String.valueOf(status.getMode()));
        if (status instanceof UfsFileStatus) {
            tagMap.put(Tag.TYPE, Type.FILE.name());
            tagMap.put(Tag.CONTENT_HASH, ((UfsFileStatus)status).getContentHash());
        } else {
            tagMap.put(Tag.TYPE, Type.DIRECTORY.name());
        }
        return tagMap;
    }

    @Nullable
    public static Fingerprint parse(String input) {
        if (input == null) {
            return null;
        }
        if ("".equals(input)) {
            return INVALID_FINGERPRINT;
        }
        Map<String, String> kv = Splitter.on(' ').trimResults().omitEmptyStrings().withKeyValueSeparator('|').split(input);
        HashMap<Tag, String> tagMap = new HashMap<Tag, String>();
        for (Map.Entry<String, String> entry : kv.entrySet()) {
            tagMap.put(Tag.valueOf(entry.getKey()), entry.getValue());
        }
        for (Tag tag : REQUIRED_TAGS) {
            if (tagMap.containsKey((Object)tag)) continue;
            return null;
        }
        return new Fingerprint(tagMap);
    }

    public boolean isValid() {
        if (this.mValues.isEmpty()) {
            return false;
        }
        for (Tag tag : REQUIRED_TAGS) {
            if (this.mValues.containsKey((Object)tag)) continue;
            return false;
        }
        return true;
    }

    public String serialize() {
        if (this.mValues.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Tag tag : REQUIRED_TAGS) {
            sb.append((Object)tag).append('|').append(this.getTag(tag)).append(' ');
        }
        for (Tag tag : OPTIONAL_TAGS) {
            if (!this.mValues.containsKey((Object)tag)) continue;
            sb.append((Object)tag).append('|').append(this.getTag(tag)).append(' ');
        }
        return sb.toString();
    }

    public boolean matchMetadata(Fingerprint fp) {
        for (Tag tag : METADATA_TAGS) {
            if (this.getTag(tag).equals(fp.getTag(tag))) continue;
            return false;
        }
        return true;
    }

    public boolean matchContent(Fingerprint fp) {
        for (Tag tag : CONTENT_TAGS) {
            if (this.getTag(tag).equals(fp.getTag(tag))) continue;
            return false;
        }
        return true;
    }

    public void putTag(Tag tag, String value) {
        if (value != null) {
            this.mValues.put(tag, this.sanitizeString(value));
        }
    }

    public String getTag(Tag tag) {
        String value = this.mValues.get((Object)tag);
        if (value == null) {
            return UNDERSCORE;
        }
        return value;
    }

    private Fingerprint(Map<Tag, String> values) {
        for (Map.Entry<Tag, String> entry : values.entrySet()) {
            this.putTag(entry.getKey(), entry.getValue());
        }
    }

    private String sanitizeString(String input) {
        if (input == null || input.isEmpty()) {
            return UNDERSCORE;
        }
        return SANITIZE_REGEX.matcher(input).replaceAll(UNDERSCORE);
    }

    public static enum Tag {
        TYPE,
        UFS,
        OWNER,
        GROUP,
        MODE,
        CONTENT_HASH,
        ACL;

    }

    public static enum Type {
        FILE,
        DIRECTORY;

    }
}

