/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import alluxio.client.file.cache.cuckoofilter.ClockCuckooFilter;
import alluxio.client.file.cache.cuckoofilter.CuckooStatus;
import alluxio.client.file.cache.cuckoofilter.CuckooTable;
import alluxio.client.file.cache.cuckoofilter.CuckooUtils;
import alluxio.client.file.cache.cuckoofilter.ScopeEncoder;
import alluxio.client.file.cache.cuckoofilter.SegmentedLock;
import alluxio.client.file.cache.cuckoofilter.SimpleCuckooTable;
import alluxio.client.file.cache.cuckoofilter.SlidingWindowType;
import alluxio.client.file.cache.cuckoofilter.TagPosition;
import alluxio.client.quota.CacheScope;
import alluxio.collections.BuiltinBitSet;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.hash.Funnel;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentClockCuckooFilter<T>
implements ClockCuckooFilter<T>,
Serializable {
    public static final double DEFAULT_FPP = 0.01;
    public static final double DEFAULT_LOAD_FACTOR = 0.955;
    public static final int TAGS_PER_BUCKET = 4;
    private static final long serialVersionUID = 1L;
    private static final int NON_EXISTENT_TAG = 0;
    private static final int DEFAULT_NUM_LOCKS = 4096;
    private static final int MAX_BFS_PATH_LEN = 5;
    private static final int MAX_AGING_PER_OPERATION = 500;
    private static final int AGING_STEP_SIZE = 5;
    private final AtomicLong mNumItems = new AtomicLong(0L);
    private final AtomicLong mTotalBytes = new AtomicLong(0L);
    private final AtomicLong mOperationCount = new AtomicLong(0L);
    private final AtomicLong mAgingCount = new AtomicLong(0L);
    private final AtomicInteger[] mScopeToNumber;
    private final AtomicLong[] mScopeToSize;
    private final int mNumBuckets;
    private final int mBitsPerTag;
    private final int mBitsPerClock;
    private final int mBitsPerSize;
    private final int mBitsPerScope;
    private final int mMaxSize;
    private final int mMaxAge;
    private final Funnel<? super T> mFunnel;
    private final HashFunction mHashFunction;
    private final ScopeEncoder mScopeEncoder;
    private final SegmentedLock mLocks;
    private final int[] mSegmentedAgingPointers;
    private final SlidingWindowType mSlidingWindowType;
    private final long mWindowSize;
    private final long mStartTime = System.currentTimeMillis();
    private final CuckooTable mTable;
    private final CuckooTable mClockTable;
    private final CuckooTable mSizeTable;
    private final CuckooTable mScopeTable;

    private ConcurrentClockCuckooFilter(CuckooTable table, CuckooTable clockTable, CuckooTable sizeTable, CuckooTable scopeTable, SlidingWindowType slidingWindowType, long windowSize, Funnel<? super T> funnel, HashFunction hasher) {
        this.mTable = table;
        this.mNumBuckets = table.getNumBuckets();
        this.mBitsPerTag = table.getBitsPerTag();
        this.mClockTable = clockTable;
        this.mBitsPerClock = clockTable.getBitsPerTag();
        this.mSizeTable = sizeTable;
        this.mBitsPerSize = sizeTable.getBitsPerTag();
        this.mScopeTable = scopeTable;
        this.mBitsPerScope = scopeTable.getBitsPerTag();
        Preconditions.checkArgument(this.mBitsPerSize > 0 && this.mBitsPerSize < 31, "check the value of bitsPerSize");
        Preconditions.checkArgument(this.mBitsPerClock > 0 && this.mBitsPerClock < 31, "check the value of bitsPerClock");
        Preconditions.checkArgument(this.mBitsPerScope > 0 && this.mBitsPerScope < 31, "check the value of bitsPerScope");
        Preconditions.checkArgument(this.mBitsPerTag > 0 && this.mBitsPerTag < 31, "check the value of bitsPerTag");
        this.mMaxSize = 1 << this.mBitsPerSize;
        this.mMaxAge = (1 << this.mBitsPerClock) - 1;
        this.mSlidingWindowType = slidingWindowType;
        this.mWindowSize = windowSize;
        this.mFunnel = funnel;
        this.mHashFunction = hasher;
        this.mLocks = new SegmentedLock(Math.min(4096, this.mNumBuckets >> 1), this.mNumBuckets);
        this.mScopeEncoder = new ScopeEncoder(this.mBitsPerScope);
        this.mScopeEncoder.encode(CacheScope.GLOBAL);
        int maxNumScopes = 1 << this.mBitsPerScope;
        this.mScopeToNumber = new AtomicInteger[maxNumScopes];
        this.mScopeToSize = new AtomicLong[maxNumScopes];
        for (int i = 0; i < maxNumScopes; ++i) {
            this.mScopeToNumber[i] = new AtomicInteger(0);
            this.mScopeToSize[i] = new AtomicLong(0L);
        }
        this.mSegmentedAgingPointers = new int[this.mLocks.getNumLocks()];
        Arrays.fill(this.mSegmentedAgingPointers, 0);
    }

    public static <T> ConcurrentClockCuckooFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, int bitsPerClock, int bitsPerSize, int bitsPerScope, SlidingWindowType slidingWindowType, long windowSize, double fpp, double loadFactor, HashFunction hasher) {
        int bitsPerTag = CuckooUtils.optimalBitsPerTag(fpp, loadFactor);
        long numBuckets = CuckooUtils.optimalBuckets(expectedInsertions, loadFactor, 4);
        long numBits = numBuckets * 4L * (long)bitsPerTag;
        BuiltinBitSet bits = new BuiltinBitSet((int)numBits);
        SimpleCuckooTable table = new SimpleCuckooTable(bits, (int)numBuckets, 4, bitsPerTag);
        BuiltinBitSet clockBits = new BuiltinBitSet((int)(numBuckets * 4L * (long)bitsPerClock));
        SimpleCuckooTable clockTable = new SimpleCuckooTable(clockBits, (int)numBuckets, 4, bitsPerClock);
        BuiltinBitSet sizeBits = new BuiltinBitSet((int)(numBuckets * 4L * (long)bitsPerSize));
        SimpleCuckooTable sizeTable = new SimpleCuckooTable(sizeBits, (int)numBuckets, 4, bitsPerSize);
        BuiltinBitSet scopeBits = new BuiltinBitSet((int)(numBuckets * 4L * (long)bitsPerScope));
        SimpleCuckooTable scopeTable = new SimpleCuckooTable(scopeBits, (int)numBuckets, 4, bitsPerScope);
        return new ConcurrentClockCuckooFilter<T>(table, clockTable, sizeTable, scopeTable, slidingWindowType, windowSize, funnel, hasher);
    }

    public static <T> ConcurrentClockCuckooFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, int bitsPerClock, int bitsPerSize, int bitsPerScope, SlidingWindowType slidingWindowType, long windowSize, double fpp, double loadFactor) {
        return ConcurrentClockCuckooFilter.create(funnel, expectedInsertions, bitsPerClock, bitsPerSize, bitsPerScope, slidingWindowType, windowSize, fpp, loadFactor, Hashing.murmur3_128());
    }

    public static <T> ConcurrentClockCuckooFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, int bitsPerClock, int bitsPerSize, int bitsPerScope, SlidingWindowType slidingWindowType, long windowSize, double fpp) {
        return ConcurrentClockCuckooFilter.create(funnel, expectedInsertions, bitsPerClock, bitsPerSize, bitsPerScope, slidingWindowType, windowSize, fpp, 0.955);
    }

    public static <T> ConcurrentClockCuckooFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, int bitsPerClock, int bitsPerSize, int bitsPerScope, SlidingWindowType slidingWindowType, long windowSize) {
        return ConcurrentClockCuckooFilter.create(funnel, expectedInsertions, bitsPerClock, bitsPerSize, bitsPerScope, slidingWindowType, windowSize, 0.01);
    }

    public static <T> ConcurrentClockCuckooFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, int bitsPerClock, int bitsPerSize, int bitsPerScope) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions > 0L);
        Preconditions.checkArgument(bitsPerClock > 0);
        Preconditions.checkArgument(bitsPerSize > 0);
        Preconditions.checkArgument(bitsPerScope > 0);
        return ConcurrentClockCuckooFilter.create(funnel, expectedInsertions, bitsPerClock, bitsPerSize, bitsPerScope, SlidingWindowType.NONE, -1L, 0.01);
    }

    @Override
    public boolean put(T item, int size, CacheScope scopeInfo) {
        if (size <= 0) {
            return false;
        }
        long hv = this.hashValue(item);
        int tag = this.tagHash(hv);
        int b1 = this.indexHash(hv);
        int b2 = this.altIndex(b1, tag);
        size = this.encodeSize(size);
        this.writeLockAndOpportunisticAging(b1, b2);
        TagPosition pos = this.cuckooInsertLoop(b1, b2, tag);
        if (pos.getStatus() == CuckooStatus.OK) {
            int scope = this.encodeScope(scopeInfo);
            this.mTable.writeTag(pos.getBucketIndex(), pos.getSlotIndex(), tag);
            this.mClockTable.writeTag(pos.getBucketIndex(), pos.getSlotIndex(), this.mMaxAge);
            this.mScopeTable.writeTag(pos.getBucketIndex(), pos.getSlotIndex(), scope);
            this.mSizeTable.writeTag(pos.getBucketIndex(), pos.getSlotIndex(), size);
            this.mNumItems.incrementAndGet();
            this.mTotalBytes.addAndGet(size);
            this.updateScopeStatistics(scope, 1, size);
            this.mLocks.unlockWrite(b1, b2);
            return true;
        }
        this.mLocks.unlockWrite(b1, b2);
        return false;
    }

    @Override
    public boolean mightContainAndResetClock(T item) {
        return this.mightContainAndOptionalResetClock(item, true);
    }

    @Override
    public boolean mightContain(T item) {
        return this.mightContainAndOptionalResetClock(item, false);
    }

    private boolean mightContainAndOptionalResetClock(T item, boolean shouldReset) {
        boolean found;
        long hv = this.hashValue(item);
        int tag = this.tagHash(hv);
        int b1 = this.indexHash(hv);
        int b2 = this.altIndex(b1, tag);
        this.mLocks.readLock(b1, b2);
        TagPosition pos = this.mTable.findTag(b1, b2, tag);
        boolean bl = found = pos.getStatus() == CuckooStatus.OK;
        if (found && shouldReset) {
            this.mClockTable.writeTag(pos.getBucketIndex(), pos.getSlotIndex(), this.mMaxAge);
        }
        this.mLocks.unlockRead(b1, b2);
        return found;
    }

    @Override
    public boolean delete(T item) {
        long hv = this.hashValue(item);
        int tag = this.tagHash(hv);
        int b1 = this.indexHash(hv);
        int b2 = this.altIndex(b1, tag);
        this.writeLockAndOpportunisticAging(b1, b2);
        TagPosition pos = this.mTable.deleteTag(b1, tag);
        if (pos.getStatus() != CuckooStatus.OK) {
            pos = this.mTable.deleteTag(b2, tag);
        }
        if (pos.getStatus() == CuckooStatus.OK) {
            this.mNumItems.decrementAndGet();
            int scope = this.mScopeTable.readTag(pos.getBucketIndex(), pos.getSlotIndex());
            int size = this.mSizeTable.readTag(pos.getBucketIndex(), pos.getSlotIndex());
            size = this.decodeSize(size);
            this.updateScopeStatistics(scope, -1, -size);
            this.mClockTable.writeTag(pos.getBucketIndex(), pos.getSlotIndex(), 0);
            this.mLocks.unlockWrite(b1, b2);
            return true;
        }
        this.mLocks.unlockWrite(b1, b2);
        return false;
    }

    @Override
    public void aging() {
        int numSegments = this.mLocks.getNumLocks();
        int bucketsPerSegment = this.mLocks.getNumBucketsPerSegment();
        for (int i = 0; i < numSegments; ++i) {
            this.mLocks.writeLockSegment(i);
            if (this.mSegmentedAgingPointers[i] < bucketsPerSegment) {
                this.agingSegment(i, bucketsPerSegment);
            }
            this.mSegmentedAgingPointers[i] = 0;
            this.mLocks.unlockWriteSegment(i);
        }
    }

    public int getAge(T item) {
        long hv = this.hashValue(item);
        int tag = this.tagHash(hv);
        int b1 = this.indexHash(hv);
        int b2 = this.altIndex(b1, tag);
        this.mLocks.readLock(b1, b2);
        TagPosition pos = this.mTable.findTag(b1, b2, tag);
        if (pos.getStatus() == CuckooStatus.OK) {
            int clock = this.mClockTable.readTag(pos.getBucketIndex(), pos.getSlotIndex());
            this.mLocks.unlockRead(b1, b2);
            return clock;
        }
        this.mLocks.unlockRead(b1, b2);
        return 0;
    }

    public String getSummary() {
        return "numBuckets: " + this.getNumBuckets() + "\ntagsPerBucket: " + this.getTagsPerBucket() + "\nbitsPerTag: " + this.getBitsPerTag() + "\nbitsPerClock: " + this.getBitsPerClock() + "\nbitsPerSize: " + this.mBitsPerSize + "\nbitsPerScope: " + this.mBitsPerScope + "\nSizeInMB: " + ((double)(this.getNumBuckets() * this.getTagsPerBucket() * this.getBitsPerTag()) / 8.0 / 1048576.0 + (double)(this.getNumBuckets() * this.getTagsPerBucket() * this.getBitsPerClock()) / 8.0 / 1048576.0 + (double)(this.getNumBuckets() * this.getTagsPerBucket() * this.mBitsPerSize) / 8.0 / 1048576.0 + (double)(this.getNumBuckets() * this.getTagsPerBucket() * this.mBitsPerScope) / 8.0 / 1048576.0);
    }

    @Override
    public double expectedFpp() {
        return 2.0 * this.mNumItems.doubleValue() / (double)((long)(this.mNumBuckets * 4) * ((1L << this.mBitsPerTag) - 1L));
    }

    @Override
    public long approximateElementCount() {
        return this.mNumItems.intValue();
    }

    @Override
    public long approximateElementCount(CacheScope scopeInfo) {
        return this.mScopeToNumber[this.encodeScope(scopeInfo)].get();
    }

    @Override
    public long approximateElementSize() {
        return this.mTotalBytes.get();
    }

    @Override
    public long approximateElementSize(CacheScope scopeInfo) {
        return this.mScopeToSize[this.encodeScope(scopeInfo)].get();
    }

    public void increaseOperationCount(int count) {
        this.mOperationCount.addAndGet(count);
    }

    public int getNumBuckets() {
        return this.mTable.getNumBuckets();
    }

    public int getTagsPerBucket() {
        return this.mTable.getNumTagsPerBuckets();
    }

    public int getBitsPerTag() {
        return this.mTable.getBitsPerTag();
    }

    public int getBitsPerClock() {
        return this.mClockTable.getBitsPerTag();
    }

    public int getBitsPerSize() {
        return this.mSizeTable.getBitsPerTag();
    }

    public int getBitsPerScope() {
        return this.mScopeTable.getBitsPerTag();
    }

    private long hashValue(T item) {
        return this.mHashFunction.newHasher().putObject(item, this.mFunnel).hash().asLong();
    }

    private int indexHash(long hv) {
        return CuckooUtils.indexHash((int)(hv >> 32), this.mNumBuckets);
    }

    private int tagHash(long hv) {
        return CuckooUtils.tagHash((int)hv, this.mBitsPerTag);
    }

    private int altIndex(int index, int tag) {
        return CuckooUtils.altIndex(index, tag, this.mNumBuckets);
    }

    private int encodeScope(CacheScope scopeInfo) {
        if (scopeInfo.level() == CacheScope.Level.PARTITION) {
            return this.mScopeEncoder.encode(scopeInfo.parent());
        }
        return this.mScopeEncoder.encode(scopeInfo);
    }

    private int encodeSize(int size) {
        return Math.min(this.mMaxSize, size);
    }

    private int decodeSize(int size) {
        if (size == 0) {
            size = this.mMaxSize;
        }
        return size;
    }

    private void updateScopeStatistics(int scope, int number, int size) {
        this.mScopeToNumber[scope].addAndGet(number);
        this.mScopeToSize[scope].addAndGet(size);
    }

    private TagPosition cuckooInsertLoop(int b1, int b2, int tag) {
        TagPosition pos = this.cuckooInsert(b1, b2, tag);
        if (pos.getStatus() == CuckooStatus.OK) {
            return pos;
        }
        return new TagPosition(-1, -1, CuckooStatus.FAILURE);
    }

    private TagPosition cuckooInsert(int b1, int b2, int tag) {
        TagPosition pos1 = this.tryFindInsertBucket(b1, tag);
        if (pos1.getStatus() == CuckooStatus.FAILURE_KEY_DUPLICATED) {
            return pos1;
        }
        TagPosition pos2 = this.tryFindInsertBucket(b2, tag);
        if (pos2.getStatus() == CuckooStatus.FAILURE_KEY_DUPLICATED) {
            return pos2;
        }
        if (pos1.getStatus() == CuckooStatus.OK) {
            return pos1;
        }
        if (pos2.getStatus() == CuckooStatus.OK) {
            return pos2;
        }
        TagPosition pos = this.runCuckoo(b1, b2);
        if (pos.getStatus() == CuckooStatus.OK && this.mTable.findTag(b1, b2, tag).getStatus() == CuckooStatus.OK) {
            pos.setStatus(CuckooStatus.FAILURE_KEY_DUPLICATED);
        }
        return pos;
    }

    private TagPosition runCuckoo(int b1, int b2) {
        int depth;
        this.mLocks.unlockWrite(b1, b2);
        TagPosition pos = new TagPosition(-1, -1, CuckooStatus.FAILURE);
        int maxPathLen = 5;
        CuckooRecord[] cuckooPath = new CuckooRecord[maxPathLen];
        for (int i = 0; i < maxPathLen; ++i) {
            cuckooPath[i] = new CuckooRecord();
        }
        boolean done = false;
        while (!done && (depth = this.cuckooPathSearch(b1, b2, cuckooPath)) >= 0) {
            if (!this.cuckooPathMove(b1, b2, cuckooPath, depth)) continue;
            pos.setBucketAndSlot(cuckooPath[0].mBucketIndex, cuckooPath[0].mSlotIndex);
            pos.setStatus(CuckooStatus.OK);
            done = true;
        }
        if (!done) {
            this.mLocks.writeLock(b1, b2);
        }
        return pos;
    }

    private int cuckooPathSearch(int b1, int b2, CuckooRecord[] cuckooPath) {
        int i;
        BFSEntry x = this.slotBFSSearch(b1, b2);
        if (x.mDepth == -1) {
            return -1;
        }
        for (i = x.mDepth; i >= 0; --i) {
            cuckooPath[i].mSlotIndex = x.mPathcode % 4;
            x.mPathcode /= 4;
        }
        cuckooPath[0].mBucketIndex = x.mPathcode == 0 ? b1 : b2;
        this.mLocks.writeLock(cuckooPath[0].mBucketIndex);
        cuckooPath[0].mTag = this.mTable.readTag(cuckooPath[0].mBucketIndex, cuckooPath[0].mSlotIndex);
        if (cuckooPath[0].mTag == 0) {
            this.mLocks.unlockWrite(cuckooPath[0].mBucketIndex);
            return 0;
        }
        this.mLocks.unlockWrite(cuckooPath[0].mBucketIndex);
        for (i = 1; i <= x.mDepth; ++i) {
            CuckooRecord curr = cuckooPath[i];
            CuckooRecord prev = cuckooPath[i - 1];
            curr.mBucketIndex = this.altIndex(prev.mBucketIndex, prev.mTag);
            this.mLocks.writeLock(curr.mBucketIndex);
            curr.mTag = this.mTable.readTag(curr.mBucketIndex, curr.mSlotIndex);
            if (curr.mTag == 0) {
                this.mLocks.unlockWrite(curr.mBucketIndex);
                return i;
            }
            this.mLocks.unlockWrite(curr.mBucketIndex);
        }
        return x.mDepth;
    }

    private BFSEntry slotBFSSearch(int b1, int b2) {
        LinkedList<BFSEntry> queue = new LinkedList<BFSEntry>();
        queue.offer(new BFSEntry(b1, 0, 0));
        queue.offer(new BFSEntry(b2, 1, 0));
        while (!queue.isEmpty()) {
            BFSEntry x = (BFSEntry)queue.poll();
            this.mLocks.writeLock(x.mBucketIndex);
            int startingSlot = x.mPathcode % 4;
            for (int i = 0; i < 4; ++i) {
                int slot = (startingSlot + i) % 4;
                int tag = this.mTable.readTag(x.mBucketIndex, slot);
                if (tag == 0) {
                    x.mPathcode = x.mPathcode * 4 + slot;
                    this.mLocks.unlockWrite(x.mBucketIndex);
                    return x;
                }
                if (x.mDepth >= 4) continue;
                queue.offer(new BFSEntry(this.altIndex(x.mBucketIndex, tag), x.mPathcode * 4 + slot, x.mDepth + 1));
            }
            this.mLocks.unlockWrite(x.mBucketIndex);
        }
        return new BFSEntry(0, 0, -1);
    }

    private boolean cuckooPathMove(int b1, int b2, CuckooRecord[] cuckooPath, int depth) {
        if (depth == 0) {
            this.mLocks.writeLock(b1, b2);
            if (this.mTable.readTag(cuckooPath[0].mBucketIndex, cuckooPath[0].mSlotIndex) == 0) {
                this.mLocks.unlockWrite(b1, b2);
                return true;
            }
            this.mLocks.unlockWrite(b1, b2);
            return false;
        }
        while (depth > 0) {
            CuckooRecord from = cuckooPath[depth - 1];
            CuckooRecord to = cuckooPath[depth];
            if (depth == 1) {
                this.mLocks.writeLock(b1, b2, to.mBucketIndex);
            } else {
                this.mLocks.writeLock(from.mBucketIndex, to.mBucketIndex);
            }
            int fromTag = this.mTable.readTag(from.mBucketIndex, from.mSlotIndex);
            if (this.mTable.readTag(to.mBucketIndex, to.mSlotIndex) != 0 || fromTag != from.mTag) {
                if (depth == 1) {
                    this.mLocks.unlockWrite(b1, b2, to.mBucketIndex);
                } else {
                    this.mLocks.unlockWrite(from.mBucketIndex, to.mBucketIndex);
                }
                return false;
            }
            int clock = this.mClockTable.readTag(from.mBucketIndex, from.mSlotIndex);
            int fromSegIndex = this.mLocks.getSegmentIndex(from.mBucketIndex);
            int toSegIndex = this.mLocks.getSegmentIndex(to.mBucketIndex);
            if (from.mBucketIndex % this.mLocks.getNumBucketsPerSegment() < this.mSegmentedAgingPointers[fromSegIndex] && to.mBucketIndex % this.mLocks.getNumBucketsPerSegment() >= this.mSegmentedAgingPointers[toSegIndex]) {
                clock = Math.min(this.mMaxAge, clock + 1);
            } else if (from.mBucketIndex % this.mLocks.getNumBucketsPerSegment() >= this.mSegmentedAgingPointers[fromSegIndex] && to.mBucketIndex % this.mLocks.getNumBucketsPerSegment() < this.mSegmentedAgingPointers[toSegIndex]) {
                clock = Math.max(0, clock - 1);
            }
            this.mTable.writeTag(to.mBucketIndex, to.mSlotIndex, fromTag);
            this.mClockTable.writeTag(to.mBucketIndex, to.mSlotIndex, clock);
            this.mScopeTable.writeTag(to.mBucketIndex, to.mSlotIndex, this.mScopeTable.readTag(from.mBucketIndex, from.mSlotIndex));
            this.mSizeTable.writeTag(to.mBucketIndex, to.mSlotIndex, this.mSizeTable.readTag(from.mBucketIndex, from.mSlotIndex));
            this.mTable.writeTag(from.mBucketIndex, from.mSlotIndex, 0);
            if (depth == 1) {
                int seg1 = this.mLocks.getSegmentIndex(b1);
                int seg2 = this.mLocks.getSegmentIndex(b2);
                int seg3 = this.mLocks.getSegmentIndex(to.mBucketIndex);
                if (seg3 != seg1 && seg3 != seg2) {
                    this.mLocks.unlockWrite(to.mBucketIndex);
                }
            } else {
                this.mLocks.unlockWrite(from.mBucketIndex, to.mBucketIndex);
            }
            --depth;
        }
        return true;
    }

    private TagPosition tryFindInsertBucket(int i, int tag) {
        TagPosition pos = new TagPosition(i, -1, CuckooStatus.FAILURE_TABLE_FULL);
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            int t = this.mTable.readTag(i, slotIndex);
            if (t != 0) {
                if (t != tag) continue;
                pos.setSlotIndex(slotIndex);
                pos.setStatus(CuckooStatus.FAILURE_KEY_DUPLICATED);
                return pos;
            }
            pos.setSlotIndex(slotIndex);
            pos.setStatus(CuckooStatus.OK);
        }
        return pos;
    }

    private void writeLockAndOpportunisticAging(int b1, int b2) {
        this.mLocks.writeLock(b1, b2);
        this.opportunisticAgingSegment(this.mLocks.getSegmentIndex(b1));
        this.opportunisticAgingSegment(this.mLocks.getSegmentIndex(b2));
    }

    private void opportunisticAgingSegment(int i) {
        int bucketsToAge = this.computeAgingNumber();
        this.agingSegment(i, Math.min(bucketsToAge, 500));
    }

    private int computeAgingNumber() {
        int bucketsToAge;
        if (this.mSlidingWindowType == SlidingWindowType.NONE || this.mWindowSize < 0L) {
            bucketsToAge = 0;
        } else if (this.mSlidingWindowType == SlidingWindowType.COUNT_BASED) {
            bucketsToAge = (int)((double)this.mNumBuckets * (this.mOperationCount.doubleValue() / (double)(this.mWindowSize >> this.mBitsPerClock)) - (double)this.mAgingCount.get());
        } else {
            long elapsedTime = System.currentTimeMillis() - this.mStartTime;
            bucketsToAge = Math.min(this.mNumBuckets, (int)((double)this.mNumBuckets * ((double)elapsedTime / (double)(this.mWindowSize >> this.mBitsPerClock)) - (double)this.mAgingCount.get()));
        }
        return bucketsToAge;
    }

    private int agingSegment(int i, int maxAgingNumber) {
        int remainingBuckets;
        int bucketsToAge;
        int bucketsPerSegment = this.mLocks.getNumBucketsPerSegment();
        int startPos = this.mLocks.getSegmentStartPos(i);
        int numCleaned = 0;
        for (int numAgedBuckets = 0; numAgedBuckets < maxAgingNumber && (remainingBuckets = bucketsPerSegment - this.mSegmentedAgingPointers[i]) != 0; numAgedBuckets += bucketsToAge) {
            bucketsToAge = Math.min(5, remainingBuckets);
            int from = startPos + this.mSegmentedAgingPointers[i];
            this.mAgingCount.addAndGet(bucketsToAge);
            int n = i;
            this.mSegmentedAgingPointers[n] = this.mSegmentedAgingPointers[n] + bucketsToAge;
            numCleaned += this.agingRange(from, from + bucketsToAge);
        }
        return numCleaned;
    }

    private int agingRange(int from, int to) {
        int numCleaned = 0;
        for (int i = from; i < to; ++i) {
            numCleaned += this.agingBucket(i);
        }
        return numCleaned;
    }

    private int agingBucket(int b) {
        int numCleaned = 0;
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            int tag = this.mTable.readTag(b, slotIndex);
            if (tag == 0) continue;
            int oldClock = this.mClockTable.readTag(b, slotIndex);
            if (oldClock > 0) {
                this.mClockTable.writeTag(b, slotIndex, oldClock - 1);
                continue;
            }
            ++numCleaned;
            this.mTable.writeTag(b, slotIndex, 0);
            this.mNumItems.decrementAndGet();
            int scope = this.mScopeTable.readTag(b, slotIndex);
            int size = this.mSizeTable.readTag(b, slotIndex);
            size = this.decodeSize(size);
            this.updateScopeStatistics(scope, -1, -size);
            this.mTotalBytes.addAndGet(-size);
        }
        return numCleaned;
    }

    static final class CuckooRecord {
        public int mBucketIndex;
        public int mSlotIndex;
        public int mTag;

        CuckooRecord() {
            this(-1, -1, 0);
        }

        CuckooRecord(int bucketIndex, int slotIndex, int tag) {
            this.mBucketIndex = bucketIndex;
            this.mSlotIndex = slotIndex;
            this.mTag = tag;
        }
    }

    static final class BFSEntry {
        public int mBucketIndex;
        public int mPathcode;
        public int mDepth;

        BFSEntry(int bucketIndex, int pathcode, int depth) {
            this.mBucketIndex = bucketIndex;
            this.mPathcode = pathcode;
            this.mDepth = depth;
        }
    }
}

