/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServerAddress;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.util.network.NetworkAddressUtils;
import java.util.Objects;
import java.util.UUID;

public class GrpcChannelKey {
    GrpcNetworkGroup mNetworkGroup = GrpcNetworkGroup.RPC;
    private GrpcServerAddress mServerAddress;
    private final UUID mChannelId = UUID.randomUUID();
    private final String mLocalHostName;
    private String mClientType;

    private GrpcChannelKey(AlluxioConfiguration conf) {
        String localHostName;
        try {
            localHostName = NetworkAddressUtils.getLocalHostName((int)conf.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS));
        }
        catch (Exception e) {
            localHostName = "<UNKNOWN>";
        }
        this.mLocalHostName = localHostName;
    }

    public static GrpcChannelKey create(AlluxioConfiguration conf) {
        return new GrpcChannelKey(conf);
    }

    public UUID getChannelId() {
        return this.mChannelId;
    }

    public GrpcServerAddress getServerAddress() {
        return this.mServerAddress;
    }

    public GrpcChannelKey setServerAddress(GrpcServerAddress address) {
        this.mServerAddress = address;
        return this;
    }

    public GrpcChannelKey setNetworkGroup(GrpcNetworkGroup group) {
        this.mNetworkGroup = group;
        return this;
    }

    public GrpcNetworkGroup getNetworkGroup() {
        return this.mNetworkGroup;
    }

    public GrpcChannelKey setClientType(String clientType) {
        this.mClientType = clientType;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mNetworkGroup, this.mServerAddress});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcChannelKey other = (GrpcChannelKey)o;
        return this.mNetworkGroup.equals((Object)other.mNetworkGroup) && this.mServerAddress.equals(other.mServerAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ClientType", this.mClientType).add("ClientHostname", this.mLocalHostName).add("ServerAddress", this.mServerAddress).add("ChannelId", this.mChannelId).omitNullValues().toString();
    }
}

