/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.metrics.MaxReservoir;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.CachedGauge;
import alluxio.shaded.client.com.codahale.metrics.ExponentiallyDecayingReservoir;
import alluxio.shaded.client.com.codahale.metrics.Histogram;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.javax.annotation.Nonnull;
import alluxio.util.ConfigurationUtils;
import alluxio.util.logging.SamplingLogger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentedExecutorService
implements ExecutorService {
    private static final AlluxioConfiguration CONF = new InstancedConfiguration(ConfigurationUtils.defaults());
    private final Logger mSamplingLog = new SamplingLogger(LoggerFactory.getLogger(InstrumentedExecutorService.class), CONF.getMs(PropertyKey.METRICS_EXECUTOR_TASK_WARN_FREQUENCY));
    private alluxio.shaded.client.com.codahale.metrics.InstrumentedExecutorService mDelegate;
    private final String mName;
    private final MetricRegistry mRegistry;
    private final ExecutorService mExecutorService;
    private final MetricRegistry.MetricSupplier<Histogram> mSupplier = () -> new Histogram(new MaxReservoir(new ExponentiallyDecayingReservoir()));
    private Meter mSubmitted;
    private Meter mCompleted;
    private Histogram mHist;

    public InstrumentedExecutorService(ExecutorService executorService, MetricRegistry registry, String name) {
        this.mName = name;
        this.mRegistry = registry;
        this.mExecutorService = executorService;
        if (executorService instanceof ThreadPoolExecutor) {
            final BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)executorService).getQueue();
            MetricsSystem.registerCachedGaugeIfAbsent(MetricRegistry.name(this.mName, "queueSize"), new CachedGauge<Integer>(1L, TimeUnit.SECONDS){

                @Override
                protected Integer loadValue() {
                    return queue.size();
                }
            });
        }
        this.reset();
    }

    protected void reset() {
        this.mDelegate = new alluxio.shaded.client.com.codahale.metrics.InstrumentedExecutorService(this.mExecutorService, this.mRegistry, this.mName);
        this.mSubmitted = this.mRegistry.meter(MetricRegistry.name(this.mName, "submitted"));
        this.mCompleted = this.mRegistry.meter(MetricRegistry.name(this.mName, "completed"));
        String histName = MetricRegistry.name(this.mName, "activeTaskQueue");
        this.mRegistry.remove(histName);
        this.mHist = this.mRegistry.histogram(histName, this.mSupplier);
    }

    private void addedTasks(int count) {
        long activeCount = this.mSubmitted.getCount() - this.mCompleted.getCount() + (long)count;
        this.mHist.update(activeCount);
        if (activeCount >= (long)CONF.getInt(PropertyKey.METRICS_EXECUTOR_TASK_WARN_SIZE)) {
            this.mSamplingLog.warn("Number of active tasks (queued and running) for executor {} is {}", (Object)this.mName, (Object)activeCount);
        }
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.addedTasks(1);
        this.mDelegate.execute(runnable);
    }

    @Override
    public Future<?> submit(@Nonnull Runnable runnable) {
        this.addedTasks(1);
        return this.mDelegate.submit(runnable);
    }

    @Override
    public <T> Future<T> submit(@Nonnull Runnable runnable, T result) {
        this.addedTasks(1);
        return this.mDelegate.submit(runnable, result);
    }

    @Override
    public <T> Future<T> submit(@Nonnull Callable<T> task) {
        this.addedTasks(1);
        return this.mDelegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.addedTasks(tasks.size());
        return this.mDelegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        this.addedTasks(tasks.size());
        return this.mDelegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        this.addedTasks(tasks.size());
        return this.mDelegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.addedTasks(tasks.size());
        return this.mDelegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void shutdown() {
        this.mDelegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.mDelegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.mDelegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.mDelegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        return this.mDelegate.awaitTermination(l, timeUnit);
    }
}

